/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.output;

import avrora.sim.output.EventBuffer;
import cck.util.Arithmetic;

public class EventGen {
    private boolean enabled;
    private final EventBuffer buffer;

    public EventGen(EventBuffer buf) {
        this.buffer = buf;
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public void gen(Object o) {
        if (this.enabled) {
            this.buffer.recordEvent(o, 0L);
        }
    }

    public void gen(Object o, int param) {
        if (this.enabled) {
            this.buffer.recordEvent(o, param);
        }
    }

    public void gen(Object o, float param) {
        if (this.enabled) {
            this.buffer.recordEvent(o, Float.floatToIntBits(param));
        }
    }

    public void gen(Object o, double param) {
        if (this.enabled) {
            this.buffer.recordEvent(o, Double.doubleToLongBits(param));
        }
    }

    public void gen(Object o, int p1, int p2) {
        if (this.enabled) {
            long param = (long)p1 << 32 | 0xFFFFFFFFL & (long)p2;
            this.buffer.recordEvent(o, param);
        }
    }

    public void gen(Object o, byte param) {
        if (this.enabled) {
            this.buffer.recordEvent(o, param);
        }
    }

    public void gen(Object o, byte p1, byte p2) {
        if (this.enabled) {
            long param = Arithmetic.word(p1, p2);
            this.buffer.recordEvent(o, param);
        }
    }

    public void gen(Object o, char param) {
        if (this.enabled) {
            this.buffer.recordEvent(o, param);
        }
    }
}

