/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.output;

import avrora.sim.Simulator;
import java.util.ArrayList;
import java.util.List;

public class EventBuffer {
    public static final DiscardPolicy DISCARD = new DiscardPolicy();
    public static final WrapAroundPolicy WRAPAROUND = new WrapAroundPolicy();
    public static final GrowPolicy GROW = new GrowPolicy();
    public final Simulator sim;
    protected final OverflowPolicy policy;
    protected Event[] buffer;
    protected int index;

    public EventBuffer(Simulator s, int length, OverflowPolicy p) {
        this.buffer = new Event[length];
        this.sim = s;
        this.policy = p;
    }

    protected Event recordEvent(Object o, long param) {
        Event e;
        if (this.index >= this.buffer.length) {
            this.policy.overflow(this);
        }
        if ((e = this.buffer[this.index]) == null) {
            this.buffer[this.index] = e = new Event();
        }
        ++this.index;
        e.time = this.sim.getClock().getCount();
        e.object = o;
        e.param = param;
        return e;
    }

    public void flush() {
        for (int i = 0; i < this.index; ++i) {
            Event e = this.buffer[i];
            e.time = 0L;
            e.object = null;
        }
        this.index = 0;
    }

    public List toList() {
        ArrayList<Event> list = new ArrayList<Event>(this.index);
        for (int i = 0; i < this.index; ++i) {
            list.add(this.buffer[i]);
        }
        return list;
    }

    public List extractList() {
        List list = this.toList();
        this.flush();
        return list;
    }

    protected static class GrowPolicy
    implements OverflowPolicy {
        protected GrowPolicy() {
        }

        public void overflow(EventBuffer buf) {
            Event[] old = buf.buffer;
            buf.buffer = new Event[old.length * 2];
            System.arraycopy(buf.buffer, 0, old, 0, old.length);
        }
    }

    protected static class WrapAroundPolicy
    implements OverflowPolicy {
        protected WrapAroundPolicy() {
        }

        public void overflow(EventBuffer buf) {
            buf.index = 0;
        }
    }

    protected static class DiscardPolicy
    implements OverflowPolicy {
        protected DiscardPolicy() {
        }

        public void overflow(EventBuffer buf) {
            buf.flush();
        }
    }

    public static interface OverflowPolicy {
        public void overflow(EventBuffer var1);
    }

    public class Event {
        protected long time;
        protected long param;
        protected Object object;

        protected Simulator getSimulator() {
            return EventBuffer.this.sim;
        }
    }
}

