/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.mcu;

import avrora.sim.RWRegister;
import avrora.sim.Simulator;
import avrora.sim.mcu.ATMegaFamily;
import avrora.sim.mcu.AtmelInternalDevice;
import avrora.sim.mcu.AtmelMicrocontroller;
import avrora.sim.mcu.MCUProperties;
import avrora.sim.mcu.Microcontroller;
import avrora.sim.output.SimPrinter;
import avrora.sim.state.BooleanView;
import avrora.sim.state.RegisterUtil;
import avrora.sim.state.RegisterView;
import avrora.sim.util.SimUtil;
import cck.text.StringUtil;
import cck.util.Arithmetic;
import java.util.LinkedList;

public class USART
extends AtmelInternalDevice {
    static final int RXCn = 7;
    static final int TXCn = 6;
    static final int UDREn = 5;
    static final int FEn = 4;
    static final int DORn = 3;
    static final int UPEn = 2;
    static final int U2Xn = 1;
    static final int MPCMn = 0;
    static final int RXCIEn = 7;
    static final int TXCIEn = 6;
    static final int UDRIEn = 5;
    static final int RXENn = 4;
    static final int TXENn = 3;
    static final int UCSZn2 = 2;
    static final int RXB8n = 1;
    static final int TXB8n = 0;
    static final int UMSELn = 6;
    static final int UPMn1 = 5;
    static final int UPMn0 = 4;
    static final int USBSn = 3;
    static final int UCSZn1 = 2;
    static final int UCSZn0 = 1;
    static final int UCPOLn = 0;
    static final int PARITY_DISABLED = 0;
    static final int PARITY_EVEN = 2;
    static final int PARITY_ODD = 3;
    static final int[] FRAME_SIZE = new int[]{5, 6, 7, 8, 8, 8, 8, 9};
    final DataRegister UDRn_reg;
    final ControlRegisterA UCSRnA_reg;
    final ControlRegisterB UCSRnB_reg;
    final ControlRegisterC UCSRnC_reg;
    final UBRRnLReg UBRRnL_reg;
    final UBRRnHReg UBRRnH_reg;
    final Transmitter transmitter;
    final Receiver receiver;
    final USARTProperties properties;
    public USARTDevice connectedDevice;
    int period;
    int UBRRMultiplier = 16;

    static USARTProperties getUSARTProperties(String subID, Microcontroller m) {
        MCUProperties mp = m.getProperties();
        USARTProperties props = new USARTProperties();
        props.subID = subID;
        props.USART_name = "USART" + subID;
        props.UDR_name = "UDR" + subID;
        props.UCSR_name = "UCSR" + subID;
        props.UBRR_name = "UBRR" + subID;
        props.USART_RX_inum = mp.getInterrupt(props.USART_name + ", RX");
        props.USART_UDRE_inum = mp.getInterrupt(props.USART_name + ", UDRE");
        props.USART_TX_inum = mp.getInterrupt(props.USART_name + ", TX");
        props.interruptMapping = new int[]{-1, -1, -1, -1, -1, props.USART_UDRE_inum, props.USART_TX_inum, props.USART_RX_inum};
        return props;
    }

    public Frame transmitFrame() {
        return new Frame(this.UDRn_reg.transmitRegister.read(), this.UCSRnB_reg.readBit(0), this.UCSRnC_reg.getFrameSize());
    }

    public void receiveFrame(Frame frame) {
        this.UDRn_reg.receiveRegister.writeFrame(frame);
    }

    public USART(String subID, AtmelMicrocontroller m) {
        super("usart" + subID, m);
        this.properties = USART.getUSARTProperties(subID, m);
        this.UDRn_reg = new DataRegister();
        this.UCSRnA_reg = new ControlRegisterA();
        this.UCSRnB_reg = new ControlRegisterB();
        this.UCSRnC_reg = new ControlRegisterC();
        this.UBRRnL_reg = new UBRRnLReg();
        this.UBRRnH_reg = new UBRRnHReg();
        this.transmitter = new Transmitter();
        this.receiver = new Receiver();
        this.installIOReg(this.properties.UDR_name, this.UDRn_reg);
        this.installIOReg(this.properties.UCSR_name + "A", this.UCSRnA_reg);
        this.installIOReg(this.properties.UCSR_name + "B", this.UCSRnB_reg);
        this.installIOReg(this.properties.UCSR_name + "C", this.UCSRnC_reg);
        this.installIOReg(this.properties.UBRR_name + "L", this.UBRRnL_reg);
        this.installIOReg(this.properties.UBRR_name + "H", this.UBRRnH_reg);
        this.connect(new SerialPrinter());
    }

    public void connect(USARTDevice d) {
        this.connectedDevice = d;
    }

    void updatePeriod() {
        this.period = USART.read16(this.UBRRnH_reg, this.UBRRnL_reg) + 1;
        if (this.devicePrinter.enabled) {
            this.devicePrinter.println(this.properties.USART_name + ": period set to " + this.period);
        }
        this.period *= this.UBRRMultiplier;
    }

    public void startReceive() {
        this.receiver.enableReceive();
    }

    protected class SerialPrinter
    implements USARTDevice {
        SimPrinter serialPrinter;
        char[] stream;
        int count;

        protected SerialPrinter() {
            this.serialPrinter = SimUtil.getPrinter(USART.this.simulator, "atmel.usart.printer");
            this.stream = new char[]{'h', 'e', 'l', 'l', 'o', 'w', 'o', 'r', 'l', 'd'};
        }

        public Frame transmitFrame() {
            return new Frame((byte)this.stream[this.count++ % this.stream.length], false, 8);
        }

        public void receiveFrame(Frame frame) {
            if (this.serialPrinter.enabled) {
                this.serialPrinter.println("Serial Printer " + frame.toString());
            }
        }
    }

    protected class UBRRnLReg
    extends RWRegister {
        protected UBRRnLReg() {
        }

        public void write(byte val) {
            super.write(val);
            USART.this.updatePeriod();
        }
    }

    protected class UBRRnHReg
    extends RWRegister {
        protected UBRRnHReg() {
        }

        public void write(byte val) {
            super.write((byte)(0xF & val));
        }
    }

    protected class ControlRegisterC
    extends RWRegister {
        final RegisterView _stopBits = RegisterUtil.bitView(this, 3);
        final RegisterView _ucszLow = RegisterUtil.bitRangeView(this, 1, 2);
        final RegisterView _umsel = RegisterUtil.bitView(this, 6);

        protected ControlRegisterC() {
        }

        public int getFrameSize() {
            return 8;
        }

        public int getStopBits() {
            if (this._stopBits.getValue() == 1) {
                return 2;
            }
            return 1;
        }
    }

    protected class ControlRegisterB
    extends ATMegaFamily.MaskRegister {
        final RegisterView _ucszHigh;
        final BooleanView _rxb8n;

        ControlRegisterB() {
            super(USART.this.interpreter, USART.this.properties.interruptMapping);
            this._ucszHigh = RegisterUtil.bitView(this, 2);
            this._rxb8n = RegisterUtil.booleanView(this, 1);
        }
    }

    protected class ControlRegisterA
    extends RWRegister {
        final ATMegaFamily.InterruptFlag UDRE_flag;
        final ATMegaFamily.InterruptFlag TXC_flag;
        final ATMegaFamily.InterruptFlag RXC_flag;
        final BooleanView _dor = RegisterUtil.booleanView(this, 3);
        final BooleanView _u2xn = RegisterUtil.booleanView(this, 1);

        public ControlRegisterA() {
            this.UDRE_flag = new ATMegaFamily.InterruptFlag(USART.this.interpreter, false, USART.this.properties.USART_UDRE_inum, RegisterUtil.booleanView(this, 5));
            this.TXC_flag = new ATMegaFamily.InterruptFlag(USART.this.interpreter, true, USART.this.properties.USART_TX_inum, RegisterUtil.booleanView(this, 6));
            this.RXC_flag = new ATMegaFamily.InterruptFlag(USART.this.interpreter, false, USART.this.properties.USART_RX_inum, RegisterUtil.booleanView(this, 7));
            this.UDRE_flag.flag(true);
        }

        public void write(byte val) {
            this.value = (byte)(val & 3);
            this.RXC_flag.sync();
            this.TXC_flag.sync();
            this.UDRE_flag.sync();
            USART.this.UBRRMultiplier = USART.this.UCSRnC_reg._umsel.getValue() == 1 ? 2 : (this._u2xn.getValue() ? 8 : 16);
            if (USART.this.devicePrinter.enabled) {
                USART.this.devicePrinter.println(USART.this.properties.USART_name + ": multiplier set to " + USART.this.UBRRMultiplier);
            }
        }
    }

    protected class DataRegister
    extends RWRegister {
        RWRegister transmitRegister = new RWRegister();
        TwoLevelFIFO receiveRegister = new TwoLevelFIFO();

        DataRegister() {
        }

        public void write(byte val) {
            this.transmitRegister.write(val);
            USART.this.UCSRnA_reg.UDRE_flag.flag(false);
            if (USART.this.UCSRnB_reg.readBit(3)) {
                USART.this.transmitter.enableTransmit();
            }
        }

        public byte read() {
            return this.receiveRegister.read();
        }

        private class TwoLevelFIFO
        extends RWRegister {
            LinkedList readyQueue = new LinkedList();
            LinkedList waitQueue = new LinkedList();

            TwoLevelFIFO() {
                this.waitQueue.add(new USARTFrameWrapper());
                this.waitQueue.add(new USARTFrameWrapper());
                this.waitQueue.add(new USARTFrameWrapper());
            }

            public byte read() {
                if (this.readyQueue.isEmpty()) {
                    USART.this.UCSRnA_reg.UDRE_flag.flag(true);
                    return 0;
                }
                USARTFrameWrapper current = (USARTFrameWrapper)this.readyQueue.removeLast();
                if (this.readyQueue.isEmpty()) {
                    USART.this.UCSRnA_reg.RXC_flag.flag(false);
                }
                USART.this.UCSRnB_reg._rxb8n.setValue(Arithmetic.getBit(current.frame.value, 8));
                this.waitQueue.add(current);
                return (byte)current.frame.value;
            }

            public void writeFrame(Frame frame) {
                if (this.waitQueue.isEmpty()) {
                    USART.this.UCSRnA_reg._dor.setValue(true);
                } else {
                    USARTFrameWrapper current = (USARTFrameWrapper)this.waitQueue.removeLast();
                    current.frame = frame;
                    this.readyQueue.addFirst(current);
                }
            }

            protected void flush() {
                while (!this.waitQueue.isEmpty()) {
                    this.readyQueue.add(this.waitQueue.removeLast());
                }
            }

            private class USARTFrameWrapper {
                Frame frame;

                private USARTFrameWrapper() {
                }
            }
        }
    }

    protected class Receiver {
        boolean receiving;
        Receive receive = new Receive();

        protected Receiver() {
        }

        protected void enableReceive() {
            if (!this.receiving) {
                this.receive.frame = USART.this.connectedDevice.transmitFrame();
                USART.this.mainClock.insertEvent(this.receive, (1 + USART.this.UCSRnC_reg.getFrameSize() + USART.this.UCSRnC_reg.getStopBits()) * USART.this.period);
                this.receiving = true;
            }
        }

        protected class Receive
        implements Simulator.Event {
            Frame frame;

            protected Receive() {
            }

            public void fire() {
                USART.this.receiveFrame(this.frame);
                if (USART.this.devicePrinter.enabled) {
                    USART.this.devicePrinter.println(USART.this.properties.USART_name + ": Received frame " + this.frame + ' ' + USART.this.UBRRnH_reg.read() + ' ' + USART.this.UBRRnL_reg.read() + ' ' + USART.this.UBRRMultiplier + ' ');
                }
                USART.this.UCSRnA_reg.RXC_flag.flag(true);
                Receiver.this.receiving = false;
            }
        }
    }

    protected class Transmitter {
        boolean transmitting;
        Transmit transmit = new Transmit();

        protected Transmitter() {
        }

        protected void enableTransmit() {
            if (!this.transmitting) {
                this.transmit.frame = new Frame(USART.this.UDRn_reg.transmitRegister.read(), USART.this.UCSRnB_reg.readBit(0), USART.this.UCSRnC_reg.getFrameSize());
                USART.this.UCSRnA_reg.UDRE_flag.flag(true);
                this.transmitting = true;
                USART.this.mainClock.insertEvent(this.transmit, (1 + USART.this.UCSRnC_reg.getFrameSize() + USART.this.UCSRnC_reg.getStopBits()) * USART.this.period);
            }
        }

        protected class Transmit
        implements Simulator.Event {
            Frame frame;

            protected Transmit() {
            }

            public void fire() {
                USART.this.connectedDevice.receiveFrame(this.frame);
                if (USART.this.devicePrinter.enabled) {
                    USART.this.devicePrinter.println(USART.this.properties.USART_name + ": Transmitted frame " + this.frame);
                }
                Transmitter.this.transmitting = false;
                USART.this.UCSRnA_reg.TXC_flag.flag(true);
                if (!USART.this.UCSRnA_reg.UDRE_flag.get()) {
                    USART.this.transmitter.enableTransmit();
                }
            }
        }
    }

    public static class Frame {
        public final int value;
        public final int size;

        public Frame(byte low, boolean high, int sz) {
            int val = low;
            if (sz > 8) {
                val = Arithmetic.setBit(val, 8, high);
            }
            this.value = val;
            this.size = sz;
        }

        public String toString() {
            return StringUtil.toMultirepString(this.value, this.size);
        }
    }

    public static interface USARTDevice {
        public Frame transmitFrame();

        public void receiveFrame(Frame var1);
    }

    static class USARTProperties {
        String subID;
        int USART_RX_inum;
        int USART_UDRE_inum;
        int USART_TX_inum;
        int[] interruptMapping;
        String USART_name;
        String UDR_name;
        String UCSR_name;
        String UBRR_name;

        USARTProperties() {
        }
    }
}

