/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.mcu;

import avrora.sim.RWRegister;
import avrora.sim.Simulator;
import avrora.sim.clock.Clock;
import avrora.sim.mcu.ATMegaFamily;
import avrora.sim.mcu.AtmelInternalDevice;
import avrora.sim.mcu.AtmelMicrocontroller;
import avrora.sim.mcu.DefaultMCU;
import avrora.sim.state.RegisterUtil;
import avrora.sim.state.RegisterView;

public abstract class Timer8Bit
extends AtmelInternalDevice {
    public static final int MODE_NORMAL = 0;
    public static final int MODE_PWM = 1;
    public static final int MODE_CTC = 2;
    public static final int MODE_FASTPWM = 3;
    public static final int MAX = 255;
    public static final int BOTTOM = 0;
    final ControlRegister TCCRn_reg = new ControlRegister();
    final TCNTnRegister TCNTn_reg = new TCNTnRegister();
    final BufferedRegister OCRn_reg = new BufferedRegister();
    protected final int n;
    protected Simulator.Event ticker;
    protected final Clock externalClock;
    protected Clock timerClock;
    protected int period;
    final DefaultMCU.Pin outputComparePin;
    final Simulator.Event[] tickers;
    boolean blockCompareMatch;
    final int OCIEn;
    final int TOIEn;
    final int OCFn;
    final int TOVn;
    protected ATMegaFamily.FlagRegister TIFR_reg;
    protected ATMegaFamily.MaskRegister TIMSK_reg;
    final int[] periods;

    protected Timer8Bit(AtmelMicrocontroller m, int n, int OCIEn, int TOIEn, int OCFn, int TOVn, int[] periods) {
        super("timer" + n, m);
        this.TIFR_reg = (ATMegaFamily.FlagRegister)m.getIOReg("TIFR");
        this.TIMSK_reg = (ATMegaFamily.MaskRegister)m.getIOReg("TIMSK");
        this.externalClock = m.getClock("external");
        this.timerClock = this.mainClock;
        this.outputComparePin = (DefaultMCU.Pin)this.microcontroller.getPin("OC" + n);
        this.OCIEn = OCIEn;
        this.TOIEn = TOIEn;
        this.OCFn = OCFn;
        this.TOVn = TOVn;
        this.n = n;
        this.periods = periods;
        this.installIOReg("TCCR" + n, this.TCCRn_reg);
        this.installIOReg("TCNT" + n, this.TCNTn_reg);
        this.installIOReg("OCR" + n, this.OCRn_reg);
        this.tickers = new Simulator.Event[4];
        this.installTickers();
    }

    private void installTickers() {
        this.tickers[0] = new Mode_Normal();
        this.tickers[2] = new Mode_CTC();
        this.tickers[3] = new Mode_FastPWM();
        this.tickers[1] = new Mode_PWM();
    }

    protected void compareMatch() {
        if (this.devicePrinter.enabled) {
            boolean enabled = this.TIMSK_reg.readBit(this.OCIEn);
            this.devicePrinter.println("Timer" + this.n + ".compareMatch (enabled: " + enabled + ')');
        }
        this.TIFR_reg.flagBit(this.OCFn);
    }

    protected void overflow() {
        if (this.devicePrinter.enabled) {
            boolean enabled = this.TIMSK_reg.readBit(this.TOIEn);
            this.devicePrinter.println("Timer" + this.n + ".overFlow (enabled: " + enabled + ')');
        }
        this.TIFR_reg.flagBit(this.TOVn);
    }

    private void tickerFinish(Simulator.Event ticker, int ncount, int ocount) {
        if (!this.blockCompareMatch && ocount == (this.OCRn_reg.read() & 0xFF)) {
            this.compareMatch();
        }
        this.TCNTn_reg.write((byte)ncount);
        this.blockCompareMatch = false;
        this.timerClock.insertEvent(ticker, this.period);
    }

    class Mode_FastPWM
    implements Simulator.Event {
        Mode_FastPWM() {
        }

        public void fire() {
            int ncount;
            int ocount = ncount = 1 + (Timer8Bit.this.TCNTn_reg.read() & 0xFF);
            if (ncount == 255) {
                ncount = 0;
                Timer8Bit.this.overflow();
                Timer8Bit.this.OCRn_reg.flush();
            }
            Timer8Bit.this.tickerFinish(this, ncount, ocount);
        }
    }

    class Mode_CTC
    implements Simulator.Event {
        Mode_CTC() {
        }

        public void fire() {
            int ncount = 1 + (Timer8Bit.this.TCNTn_reg.read() & 0xFF);
            int ocount = ncount;
            if (ocount == (Timer8Bit.this.OCRn_reg.read() & 0xFF)) {
                ncount = 0;
            }
            Timer8Bit.this.tickerFinish(this, ncount, ocount);
        }
    }

    class Mode_PWM
    implements Simulator.Event {
        protected byte increment = 1;

        Mode_PWM() {
        }

        public void fire() {
            int ncount;
            int ocount = ncount = this.increment + (Timer8Bit.this.TCNTn_reg.read() & 0xFF);
            if (ncount >= 255) {
                this.increment = (byte)-1;
                ncount = 255;
                Timer8Bit.this.OCRn_reg.flush();
            }
            if (ncount <= 0) {
                Timer8Bit.this.overflow();
                this.increment = 1;
                ncount = 0;
            }
            Timer8Bit.this.tickerFinish(this, ncount, ocount);
        }
    }

    class Mode_Normal
    implements Simulator.Event {
        Mode_Normal() {
        }

        public void fire() {
            int ncount;
            int ocount = ncount = 1 + (Timer8Bit.this.TCNTn_reg.read() & 0xFF);
            if (ncount == 255) {
                Timer8Bit.this.overflow();
                ncount = 0;
            }
            Timer8Bit.this.tickerFinish(this, ncount, ocount);
        }
    }

    protected class ControlRegister
    extends RWRegister {
        public static final int FOCn = 7;
        public static final int WGMn0 = 6;
        public static final int COMn1 = 5;
        public static final int COMn0 = 4;
        public static final int WGMn1 = 3;
        public static final int CSn2 = 2;
        public static final int CSn1 = 1;
        public static final int CSn0 = 0;
        final RegisterView CSn = RegisterUtil.bitRangeView(this, 0, 2);
        final RegisterView COMn = RegisterUtil.bitRangeView(this, 4, 5);
        final RegisterView WGMn = RegisterUtil.permutedView(this, new byte[]{6, 3});
        int mode = -1;
        int scale = -1;

        protected ControlRegister() {
        }

        public void write(byte val) {
            this.value = (byte)(val & 0x7F);
            if ((val & 0x80) != 0) {
                this.forcedOutputCompare();
            }
            int nmode = this.WGMn.getValue();
            int nscale = this.CSn.getValue();
            if (nmode != this.mode || nscale != this.scale) {
                if (Timer8Bit.this.ticker != null) {
                    Timer8Bit.this.timerClock.removeEvent(Timer8Bit.this.ticker);
                }
                this.mode = nmode;
                this.scale = nscale;
                Timer8Bit.this.ticker = Timer8Bit.this.tickers[this.mode];
                Timer8Bit.this.period = Timer8Bit.this.periods[this.scale];
                if (Timer8Bit.this.period != 0) {
                    Timer8Bit.this.timerClock.insertEvent(Timer8Bit.this.ticker, Timer8Bit.this.period);
                }
            }
        }

        private void forcedOutputCompare() {
            int compare;
            int count = Timer8Bit.this.TCNTn_reg.read() & 0xFF;
            if (count == (compare = Timer8Bit.this.OCRn_reg.read() & 0xFF)) {
                switch (this.COMn.getValue()) {
                    case 1: {
                        Timer8Bit.this.outputComparePin.write(!Timer8Bit.this.outputComparePin.read());
                        break;
                    }
                    case 2: {
                        Timer8Bit.this.outputComparePin.write(false);
                        break;
                    }
                    case 3: {
                        Timer8Bit.this.outputComparePin.write(true);
                    }
                }
            }
        }
    }

    protected class BufferedRegister
    extends RWRegister {
        final RWRegister register = new RWRegister();

        protected BufferedRegister() {
        }

        public void write(byte val) {
            super.write(val);
            if (Timer8Bit.this.TCCRn_reg.mode == 0 || Timer8Bit.this.TCCRn_reg.mode == 2) {
                this.flush();
            }
        }

        public byte readBuffer() {
            return super.read();
        }

        public byte read() {
            return this.register.read();
        }

        protected void flush() {
            this.register.write(this.value);
        }
    }

    protected class TCNTnRegister
    extends RWRegister {
        protected TCNTnRegister() {
        }

        public void write(byte val) {
            this.value = val;
            Timer8Bit.this.blockCompareMatch = true;
        }
    }
}

