/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.mcu;

import avrora.sim.RWRegister;
import avrora.sim.Simulator;
import avrora.sim.clock.Clock;
import avrora.sim.mcu.ATMegaFamily;
import avrora.sim.mcu.AtmelInternalDevice;
import avrora.sim.mcu.AtmelMicrocontroller;
import avrora.sim.mcu.DefaultMCU;
import avrora.sim.mcu.Microcontroller;
import avrora.sim.mcu.RegisterSet;
import avrora.sim.state.BooleanView;

public abstract class Timer16Bit
extends AtmelInternalDevice {
    public static final int MODE_NORMAL = 0;
    public static final int MODE_PWM_PHASE_CORRECT_8_BIT = 1;
    public static final int MODE_PWM_PHASE_CORRECT_9_BIT = 2;
    public static final int MODE_PWM_PHASE_CORRECT_10_BIT = 3;
    public static final int MODE_CTC_OCRnA = 4;
    public static final int MODE_FASTPWM_8_BIT = 5;
    public static final int MODE_FASTPWM_9_BIT = 6;
    public static final int MODE_FASTPWM_10_BIT = 7;
    public static final int MODE_PWM_PNF_ICRn = 8;
    public static final int MODE_PWM_PNF_OCRnA = 9;
    public static final int MODE_PWN_PHASE_CORRECT_ICRn = 10;
    public static final int MODE_PWN_PHASE_CORRECT_OCRnA = 11;
    public static final int MODE_CTC_ICRn = 12;
    public static final int MODE_FASTPWM_ICRn = 14;
    public static final int MODE_FASTPWM_OCRnA = 15;
    public static final int MAX = 65535;
    public static final int BOTTOM = 0;
    final RWRegister TCNTnH_reg;
    final TCNTnRegister TCNTnL_reg;
    final PairedRegister TCNTn_reg;
    final OutputCompareUnit[] compareUnits;
    final Simulator.Event[] tickers;
    final RWRegister highTempReg;
    final RWRegister ICRnH_reg;
    final RWRegister ICRnL_reg;
    final PairedRegister ICRn_reg;
    Simulator.Event ticker;
    final RegisterSet.Field WGMn;
    final RegisterSet.Field CSn;
    final InputCapturePin inputCapturePin;
    long period;
    boolean blockCompareMatch;
    protected final Clock externalClock;
    Clock timerClock;
    final int n;
    int OCIEnA;
    int OCIEnB;
    int OCIEnC;
    int TOIEn;
    int TOVn;
    int OCFnA;
    int OCFnB;
    int OCFnC;
    int ICFn;
    int inputCaptureInterrupt;
    protected ATMegaFamily.FlagRegister xTIFR_reg;
    protected ATMegaFamily.MaskRegister xTIMSK_reg;
    protected int[] periods;

    protected abstract void initValues();

    protected Timer16Bit(int n, int numUnits, AtmelMicrocontroller m) {
        super("timer" + n, m);
        this.n = n;
        RegisterSet rset = m.getRegisterSet();
        this.initValues();
        this.WGMn = rset.installField("WGM" + n, new RegisterSet.Field(){

            public void update() {
                Timer16Bit.this.resetTicker(Timer16Bit.this.tickers[this.value]);
            }
        });
        this.CSn = rset.installField("CS" + n, new RegisterSet.Field(){

            public void update() {
                Timer16Bit.this.resetPeriod(Timer16Bit.this.periods[this.value]);
            }
        });
        this.inputCaptureInterrupt = m.getProperties().getInterrupt("TIMER" + n + " CAPT");
        this.inputCapturePin = new InputCapturePin();
        this.highTempReg = new RWRegister();
        this.compareUnits = new OutputCompareUnit[numUnits];
        this.newOCU(0, numUnits, m, rset, 'A', this.OCFnA);
        this.newOCU(1, numUnits, m, rset, 'B', this.OCFnB);
        this.newOCU(2, numUnits, m, rset, 'C', this.OCFnC);
        this.TCNTnH_reg = new RWRegister();
        this.TCNTnL_reg = new TCNTnRegister();
        this.TCNTn_reg = new PairedRegister(this.TCNTnH_reg, this.TCNTnL_reg);
        this.ICRnH_reg = new RWRegister();
        this.ICRnL_reg = new RWRegister();
        this.ICRn_reg = new PairedRegister(this.ICRnL_reg, this.ICRnH_reg);
        this.externalClock = m.getClock("external");
        this.timerClock = this.mainClock;
        this.installIOReg("TCNT" + n + "H", this.highTempReg);
        this.installIOReg("TCNT" + n + "L", this.TCNTn_reg);
        this.installIOReg("ICR" + n + "H", this.highTempReg);
        this.installIOReg("ICR" + n + "L", this.ICRn_reg);
        this.tickers = new Simulator.Event[16];
        this.installTickers();
    }

    private void installTickers() {
        OutputCompareUnit ocA = this.compareUnits[0];
        BufferedRegister ocrah = ocA.OCRnXH_reg;
        BufferedRegister ocral = ocA.OCRnXL_reg;
        this.tickers[0] = new Mode_Normal();
        this.tickers[1] = new Mode_PWMPhaseCorrect(255, null, null);
        this.tickers[2] = new Mode_PWMPhaseCorrect(511, null, null);
        this.tickers[3] = new Mode_PWMPhaseCorrect(1023, null, null);
        this.tickers[4] = new Mode_CTC(ocrah, ocral);
        this.tickers[5] = new Mode_FastPWM(255, null, null);
        this.tickers[6] = new Mode_FastPWM(511, null, null);
        this.tickers[7] = new Mode_FastPWM(1023, null, null);
        this.tickers[8] = new Mode_PWM_PNF(this.ICRnH_reg, this.ICRnL_reg);
        this.tickers[9] = new Mode_PWM_PNF(ocrah, ocral);
        this.tickers[10] = new Mode_PWMPhaseCorrect(0, this.ICRnH_reg, this.ICRnL_reg);
        this.tickers[11] = new Mode_PWMPhaseCorrect(0, ocrah, ocral);
        this.tickers[12] = new Mode_CTC(this.ICRnH_reg, this.ICRnL_reg);
        this.tickers[13] = new Mode_Reserved();
        this.tickers[14] = new Mode_FastPWM(0, this.ICRnH_reg, this.ICRnL_reg);
        this.tickers[15] = new Mode_FastPWM(0, ocrah, ocral);
    }

    public BooleanView getInputCapturePin() {
        return this.inputCapturePin;
    }

    void captureInput() {
        this.ICRnL_reg.write(this.TCNTnL_reg.value);
        this.ICRnH_reg.write(this.TCNTnH_reg.value);
        this.xTIFR_reg.flagBit(this.ICFn);
        this.interpreter.getInterruptTable().post(this.inputCaptureInterrupt);
    }

    void newOCU(int unit, int numUnits, Microcontroller m, RegisterSet rset, char uname, int fb) {
        if (unit < numUnits) {
            this.compareUnits[unit] = new OutputCompareUnit(m, rset, uname, fb);
        }
    }

    protected void overflow() {
        if (this.devicePrinter.enabled) {
            boolean enabled = this.xTIMSK_reg.readBit(this.TOIEn);
            this.devicePrinter.println("Timer" + this.n + ".overFlow (enabled: " + enabled + ')' + "  ");
        }
        this.xTIFR_reg.flagBit(this.TOVn);
    }

    private void resetPeriod(int nPeriod) {
        if (nPeriod == 0) {
            if (this.devicePrinter.enabled) {
                this.devicePrinter.println("Timer" + this.n + " disabled");
            }
            if (this.ticker != null) {
                this.timerClock.removeEvent(this.ticker);
            }
        } else {
            if (this.devicePrinter.enabled) {
                this.devicePrinter.println("Timer" + this.n + " enabled: period = " + nPeriod + " mode = " + this.WGMn.value);
            }
            if (this.ticker != null) {
                this.timerClock.removeEvent(this.ticker);
            }
            this.ticker = this.tickers[this.WGMn.value];
            this.period = nPeriod;
            this.timerClock.insertEvent(this.ticker, this.period);
        }
    }

    public void resetTicker(Simulator.Event e) {
        if (this.ticker != null) {
            this.simulator.removeEvent(this.ticker);
        }
        this.ticker = e;
        this.simulator.insertEvent(e, this.period);
    }

    private void tickerFinish(Simulator.Event ticker, int ocount, int ncount) {
        if (!this.blockCompareMatch) {
            for (int cntr = 0; cntr < this.compareUnits.length; ++cntr) {
                this.compareUnits[cntr].compare(ocount);
            }
        }
        Timer16Bit.write16(ncount, this.TCNTnH_reg, this.TCNTnL_reg);
        this.blockCompareMatch = false;
        if (this.period != 0L) {
            this.timerClock.insertEvent(ticker, this.period);
        }
    }

    private void flushOCRnx() {
        for (int cntr = 0; cntr < this.compareUnits.length; ++cntr) {
            this.compareUnits[cntr].flush();
        }
    }

    protected class Mode_PWMPhaseCorrect
    implements Simulator.Event {
        protected byte increment = 1;
        protected final int top;
        protected final RWRegister compareRegHigh;
        protected final RWRegister compareRegLow;

        protected Mode_PWMPhaseCorrect(int t, RWRegister compareRegH, RWRegister compareRegL) {
            this.top = t;
            this.compareRegHigh = compareRegH;
            this.compareRegLow = compareRegL;
        }

        public void fire() {
            int ncount = AtmelInternalDevice.read16(Timer16Bit.this.TCNTnH_reg, Timer16Bit.this.TCNTnL_reg) + this.increment;
            int top = this.top;
            int ocount = ncount;
            if (this.compareRegHigh != null) {
                top = AtmelInternalDevice.read16(this.compareRegHigh, this.compareRegLow);
            }
            if (ncount >= top) {
                this.increment = (byte)-1;
                ncount = top;
                Timer16Bit.this.flushOCRnx();
            }
            if (ncount <= 0) {
                Timer16Bit.this.overflow();
                this.increment = 1;
                ncount = 0;
            }
            Timer16Bit.this.tickerFinish(this, ocount, ncount);
        }
    }

    protected class Mode_PWM_PNF
    implements Simulator.Event {
        protected byte increment = 1;
        protected final RWRegister compareRegHigh;
        protected final RWRegister compareRegLow;

        protected Mode_PWM_PNF(RWRegister compareRegH, RWRegister compareRegL) {
            this.compareRegHigh = compareRegH;
            this.compareRegLow = compareRegL;
        }

        public void fire() {
            int compare;
            int ncount;
            int ocount = ncount = AtmelInternalDevice.read16(Timer16Bit.this.TCNTnH_reg, Timer16Bit.this.TCNTnL_reg) + this.increment;
            if (this.compareRegHigh != null && ncount >= (compare = AtmelInternalDevice.read16(this.compareRegHigh, this.compareRegLow))) {
                this.increment = (byte)-1;
                ncount = compare;
            }
            if (ncount <= 0) {
                Timer16Bit.this.overflow();
                Timer16Bit.this.flushOCRnx();
                this.increment = 1;
                ncount = 0;
            }
            Timer16Bit.this.tickerFinish(this, ocount, ncount);
        }
    }

    protected class Mode_FastPWM
    implements Simulator.Event {
        protected final int top;
        protected final RWRegister compareRegHigh;
        protected final RWRegister compareRegLow;

        protected Mode_FastPWM(int t, RWRegister compareRegH, RWRegister compareRegL) {
            this.top = t;
            this.compareRegHigh = compareRegH;
            this.compareRegLow = compareRegL;
        }

        public void fire() {
            int ncount = AtmelInternalDevice.read16(Timer16Bit.this.TCNTnH_reg, Timer16Bit.this.TCNTnL_reg) + 1;
            int top = this.top;
            int ocount = ncount;
            if (this.compareRegHigh != null) {
                top = AtmelInternalDevice.read16(this.compareRegHigh, this.compareRegLow);
            }
            if (ncount == top) {
                ncount = 0;
                Timer16Bit.this.overflow();
                Timer16Bit.this.flushOCRnx();
            }
            Timer16Bit.this.tickerFinish(this, ocount, ncount);
        }
    }

    protected class Mode_CTC
    implements Simulator.Event {
        protected final RWRegister compareRegHigh;
        protected final RWRegister compareRegLow;

        public Mode_CTC(RWRegister compareRegH, RWRegister compareRegL) {
            this.compareRegHigh = compareRegH;
            this.compareRegLow = compareRegL;
        }

        public void fire() {
            int ncount;
            int ocount = ncount = AtmelInternalDevice.read16(Timer16Bit.this.TCNTnH_reg, Timer16Bit.this.TCNTnL_reg) + 1;
            if (this.compareRegHigh != null && ncount == AtmelInternalDevice.read16(this.compareRegHigh, this.compareRegLow)) {
                ncount = 0;
            }
            if (ncount == 65535) {
                Timer16Bit.this.overflow();
            }
            Timer16Bit.this.tickerFinish(this, ocount, ncount);
        }
    }

    protected class Mode_Normal
    implements Simulator.Event {
        protected Mode_Normal() {
        }

        public void fire() {
            int ncount;
            int ocount = ncount = AtmelInternalDevice.read16(Timer16Bit.this.TCNTnH_reg, Timer16Bit.this.TCNTnL_reg) + 1;
            if (ncount == 65535) {
                Timer16Bit.this.overflow();
                ncount = 0;
            }
            Timer16Bit.this.tickerFinish(this, ocount, ncount);
        }
    }

    protected class Mode_Reserved
    implements Simulator.Event {
        protected Mode_Reserved() {
        }

        public void fire() {
        }
    }

    protected class BufferedRegister
    extends RWRegister {
        final RWRegister register = new RWRegister();

        protected BufferedRegister() {
        }

        public void write(byte val) {
            super.write(val);
            int mode = Timer16Bit.this.WGMn.value;
            if (mode == 0 || mode == 4 || mode == 12) {
                this.flush();
            }
        }

        public byte readBuffer() {
            return super.read();
        }

        public byte read() {
            return this.register.read();
        }

        protected void flush() {
            this.register.write(this.value);
        }
    }

    protected class TCNTnRegister
    extends RWRegister {
        protected TCNTnRegister() {
        }

        public void write(byte val) {
            this.value = val;
            Timer16Bit.this.blockCompareMatch = true;
        }
    }

    protected class OCRnxTempHighRegister
    extends RWRegister {
        RWRegister register;

        OCRnxTempHighRegister(RWRegister register) {
            this.register = register;
        }

        public void write(byte val) {
            Timer16Bit.this.highTempReg.write(val);
        }

        public byte read() {
            return this.register.read();
        }
    }

    protected class OCRnxPairedRegister
    extends PairedRegister {
        OCRnxPairedRegister(RWRegister high, RWRegister low) {
            super(high, low);
        }

        public byte read() {
            return this.low.read();
        }
    }

    protected class PairedRegister
    extends RWRegister {
        RWRegister high;
        RWRegister low;

        PairedRegister(RWRegister high, RWRegister low) {
            this.high = high;
            this.low = low;
        }

        public void write(byte val) {
            this.low.write(val);
            this.high.write(Timer16Bit.this.highTempReg.read());
        }

        public byte read() {
            Timer16Bit.this.highTempReg.write(this.high.read());
            return this.low.read();
        }
    }

    class OutputCompareUnit {
        final BufferedRegister OCRnXH_reg;
        final BufferedRegister OCRnXL_reg;
        final OCRnxPairedRegister OCRnX_reg;
        final DefaultMCU.Pin outputComparePin;
        final RegisterSet.Field mode;
        final RegisterSet.Field force;
        final char unit;
        final int flagBit;

        OutputCompareUnit(Microcontroller m, RegisterSet rset, char c, int fb) {
            this.unit = c;
            this.OCRnXH_reg = new BufferedRegister();
            this.OCRnXL_reg = new BufferedRegister();
            this.OCRnX_reg = new OCRnxPairedRegister(this.OCRnXH_reg, this.OCRnXL_reg);
            this.outputComparePin = (DefaultMCU.Pin)m.getPin("OC" + Timer16Bit.this.n + this.unit);
            this.mode = rset.getField("COM" + Timer16Bit.this.n + c);
            this.force = rset.installField("FOC" + Timer16Bit.this.n + c, new FOC_Field());
            this.flagBit = fb;
            Timer16Bit.this.installIOReg("OCR" + Timer16Bit.this.n + this.unit + "H", new OCRnxTempHighRegister(this.OCRnXH_reg));
            Timer16Bit.this.installIOReg("OCR" + Timer16Bit.this.n + this.unit + "L", this.OCRnX_reg);
        }

        void forceCompare(int count) {
            if (count == this.read()) {
                this.output();
            }
        }

        void compare(int count) {
            int r = this.read();
            if (count == this.read()) {
                this.output();
                Timer16Bit.this.xTIFR_reg.flagBit(this.flagBit);
            }
        }

        void flush() {
            this.OCRnXH_reg.flush();
            this.OCRnXL_reg.flush();
        }

        private void output() {
            switch (this.mode.value) {
                case 1: {
                    this.outputComparePin.write(!this.outputComparePin.read());
                    break;
                }
                case 2: {
                    this.outputComparePin.write(false);
                    break;
                }
                case 3: {
                    this.outputComparePin.write(true);
                }
            }
        }

        int read() {
            return AtmelInternalDevice.read16(this.OCRnXH_reg, this.OCRnXL_reg);
        }

        class FOC_Field
        extends RegisterSet.Field {
            FOC_Field() {
            }

            public void update() {
                if (this.value == 1 && AtmelInternalDevice.read16(Timer16Bit.this.TCNTnH_reg, Timer16Bit.this.TCNTnL_reg) == OutputCompareUnit.this.read()) {
                    OutputCompareUnit.this.output();
                }
            }
        }
    }

    public class InputCapturePin
    implements BooleanView {
        boolean level;

        public boolean getValue() {
            return this.level;
        }

        public void setValue(boolean v) {
            if (v != this.level) {
                this.level = v;
                Timer16Bit.this.captureInput();
            }
        }
    }
}

