/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.mcu;

import avrora.sim.ActiveRegister;
import avrora.sim.InterruptTable;
import avrora.sim.RWRegister;
import avrora.sim.Simulator;
import avrora.sim.mcu.AtmelInternalDevice;
import avrora.sim.mcu.AtmelMicrocontroller;
import avrora.sim.mcu.SPIDevice;
import avrora.sim.state.BooleanView;
import avrora.sim.state.RegisterUtil;
import avrora.sim.state.RegisterView;
import cck.text.StringUtil;
import cck.util.Arithmetic;

public class SPI
extends AtmelInternalDevice
implements SPIDevice,
InterruptTable.Notification {
    final SPDReg SPDR_reg;
    final SPCRReg SPCR_reg;
    final SPSReg SPSR_reg;
    SPIDevice connectedDevice;
    final TransferEvent transferEvent = new TransferEvent();
    boolean spifAccessed;
    int interruptNum;
    protected int period;
    private static final Frame[] frameCache = new Frame[256];
    public static final Frame ZERO_FRAME;
    public static final Frame FF_FRAME;

    public static Frame newFrame(byte data) {
        return frameCache[data & 0xFF];
    }

    public void connect(SPIDevice d) {
        this.connectedDevice = d;
    }

    public Frame exchange(Frame frame) {
        Frame result = SPI.newFrame(this.SPDR_reg.transmitReg.read());
        this.receive(frame);
        return result;
    }

    public void receive(Frame frame) {
        this.SPDR_reg.receiveReg.write(frame.data);
        if (!this.SPCR_reg._master.getValue() && !this.transferEvent.transmitting) {
            this.postSPIInterrupt();
        }
    }

    public SPI(AtmelMicrocontroller m) {
        super("spi", m);
        this.SPDR_reg = new SPDReg();
        this.SPCR_reg = new SPCRReg();
        this.SPSR_reg = new SPSReg();
        this.interruptNum = m.getProperties().getInterrupt("SPI, STC");
        this.installIOReg("SPDR", this.SPDR_reg);
        this.installIOReg("SPSR", this.SPSR_reg);
        this.installIOReg("SPCR", this.SPCR_reg);
        this.interpreter.getInterruptTable().registerInternalNotification(this, this.interruptNum);
    }

    private void postSPIInterrupt() {
        this.interpreter.setPosted(this.interruptNum, true);
        this.SPSR_reg.setSPIF();
    }

    private void unpostSPIInterrupt() {
        this.interpreter.setPosted(this.interruptNum, false);
        this.SPSR_reg.clearSPIF();
    }

    public void force(int inum) {
        this.SPSR_reg.setSPIF();
    }

    public void invoke(int inum) {
        this.unpostSPIInterrupt();
    }

    static {
        for (int cntr = 0; cntr < 256; ++cntr) {
            SPI.frameCache[cntr] = new Frame((byte)cntr);
        }
        ZERO_FRAME = frameCache[0];
        FF_FRAME = frameCache[255];
    }

    class SPSReg
    extends RWRegister {
        static final int SPIF = 7;
        static final int WCOL = 6;
        final BooleanView _spif = RegisterUtil.booleanView(this, 7);
        final BooleanView _spi2x = RegisterUtil.booleanView(this, 0);
        byte prev_value;

        SPSReg() {
        }

        public void write(byte val) {
            if (SPI.this.devicePrinter.enabled) {
                SPI.this.devicePrinter.println("SPI: wrote " + val + " to SPSR");
            }
            super.write(val);
            this.decode(val);
        }

        public byte read() {
            if (this._spif.getValue()) {
                SPI.this.spifAccessed = true;
            }
            return super.read();
        }

        protected void decode(byte val) {
            if (!Arithmetic.getBit(this.prev_value, 7) && Arithmetic.getBit(val, 7)) {
                SPI.this.postSPIInterrupt();
            }
            SPI.this.spifAccessed = false;
            this.prev_value = val;
        }

        public void setSPIF() {
            this._spif.setValue(true);
            SPI.this.spifAccessed = false;
        }

        public void clearSPIF() {
            this._spif.setValue(false);
            SPI.this.spifAccessed = false;
        }
    }

    protected class SPCRReg
    extends RWRegister {
        static final int SPIE = 7;
        static final int SPE = 6;
        static final int MSTR = 4;
        static final int SPR1 = 1;
        static final int SPR0 = 0;
        boolean prev_spie;
        final BooleanView _master = RegisterUtil.booleanView(this, 4);
        final BooleanView _enabled = RegisterUtil.booleanView(this, 6);
        final RegisterView _spr = RegisterUtil.bitRangeView(this, 0, 1);

        protected SPCRReg() {
        }

        public void write(byte val) {
            if (SPI.this.devicePrinter.enabled) {
                SPI.this.devicePrinter.println("SPI: wrote " + StringUtil.toMultirepString(val, 8) + " to SPCR");
            }
            super.write(val);
            this.decode(val);
        }

        protected void decode(byte val) {
            boolean spie = Arithmetic.getBit(val, 7);
            SPI.this.interpreter.setEnabled(SPI.this.interruptNum, spie);
            if (spie && !this.prev_spie) {
                this.prev_spie = true;
                SPI.this.SPSR_reg.clearSPIF();
            }
            if (!spie && this.prev_spie) {
                this.prev_spie = false;
            }
            int divider = 0;
            switch (this._spr.getValue()) {
                case 0: {
                    divider = 4;
                    break;
                }
                case 1: {
                    divider = 16;
                    break;
                }
                case 2: {
                    divider = 64;
                    break;
                }
                case 3: {
                    divider = 128;
                }
            }
            if (SPI.this.SPSR_reg._spi2x.getValue()) {
                divider /= 2;
            }
            SPI.this.period = divider * 8;
        }
    }

    class SPDReg
    implements ActiveRegister {
        protected final RWRegister receiveReg = new RWRegister();
        protected final TransmitRegister transmitReg = new TransmitRegister();

        SPDReg() {
        }

        public byte read() {
            if (SPI.this.spifAccessed) {
                SPI.this.unpostSPIInterrupt();
            }
            return this.receiveReg.read();
        }

        public void write(byte val) {
            this.transmitReg.write(val);
        }

        protected class TransmitRegister
        extends RWRegister {
            protected TransmitRegister() {
            }

            public void write(byte val) {
                super.write(val);
                SPI.this.transferEvent.enableTransfer();
            }
        }
    }

    protected class TransferEvent
    implements Simulator.Event {
        Frame frame;
        boolean transmitting;

        protected TransferEvent() {
        }

        protected void enableTransfer() {
            if (SPI.this.SPCR_reg._master.getValue() && SPI.this.SPCR_reg._enabled.getValue() && !this.transmitting) {
                SPI.this.SPSR_reg.clearSPIF();
                if (SPI.this.devicePrinter.enabled) {
                    SPI.this.devicePrinter.println("SPI: Master mode. Enabling transfer. ");
                }
                this.transmitting = true;
                this.frame = SPI.newFrame(SPI.this.SPDR_reg.transmitReg.read());
                SPI.this.mainClock.insertEvent(this, SPI.this.period);
            }
        }

        public void fire() {
            if (SPI.this.SPCR_reg._enabled.getValue()) {
                SPI.this.SPSR_reg.clearSPIF();
                SPI.this.receive(SPI.this.connectedDevice.exchange(this.frame));
                this.transmitting = false;
                SPI.this.postSPIInterrupt();
            }
        }
    }

    public static class Frame {
        public final byte data;

        protected Frame(byte data) {
            this.data = data;
        }
    }
}

