/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.mcu;

import avrora.arch.legacy.LegacyDisassembler;
import avrora.arch.legacy.LegacyInstr;
import avrora.arch.legacy.LegacyInstrVisitor;
import avrora.arch.legacy.LegacyOperand;
import avrora.arch.legacy.LegacyRegister;
import avrora.core.Program;
import avrora.sim.AtmelInterpreter;
import avrora.sim.CodeSegment;
import avrora.sim.RWRegister;
import avrora.sim.Simulator;
import avrora.sim.clock.MainClock;
import avrora.sim.mcu.MCUProperties;
import avrora.sim.output.SimPrinter;
import avrora.sim.util.SimUtil;
import cck.text.StringUtil;
import cck.util.Arithmetic;
import cck.util.Util;

public class ReprogrammableCodeSegment
extends CodeSegment {
    private static final double ERASE_MS_MIN = 3.7;
    private static final double WRITE_MS_MIN = 3.7;
    private static final double ERASE_MS_MAX = 4.5;
    private static final double WRITE_MS_MAX = 4.5;
    private static final int SPM_TIMEOUT = 4;
    private static final int STATE_NONE = 0;
    private static final int STATE_PGERASE = 3;
    private static final int STATE_RWWSRE = 17;
    private static final int STATE_BLBSET = 9;
    private static final int STATE_FILL = 1;
    private static final int STATE_PGWRITE = 5;
    private static final int SPM_READY = 35;
    private static final int SPMCSR_LOWERBITS = 31;
    private static final byte DEFAULT_VALUE = -1;
    final SimPrinter flashPrinter;
    LegacyDisassembler disassembler = new LegacyDisassembler();
    byte[] buffer;
    final SPMCSR_reg SPMCSR = new SPMCSR_reg();
    final int ERASE_CYCLES;
    final int WRITE_CYCLES;
    final int pagesize;
    final int addressMask;
    final MainClock mainClock;

    public ReprogrammableCodeSegment(String name, int size, AtmelInterpreter bi, int pagesize) {
        super(name, size, bi);
        this.mainClock = bi.getMainClock();
        this.pagesize = pagesize;
        this.addressMask = Arithmetic.getBitRangeMask(1, pagesize + 1);
        this.resetBuffer();
        MCUProperties props = bi.getSimulator().getMicrocontroller().getProperties();
        bi.installIOReg(props.getIOReg("SPMCSR"), this.SPMCSR);
        this.ERASE_CYCLES = (int)((double)this.mainClock.getHZ() * 4.5 / 1000.0);
        this.WRITE_CYCLES = (int)((double)this.mainClock.getHZ() * 4.5 / 1000.0);
        this.flashPrinter = SimUtil.getPrinter(bi.getSimulator(), "atmel.flash");
    }

    public void update() {
        int Z = this.interpreter.getRegisterWord(LegacyRegister.Z);
        int pageoffset = Z & this.addressMask;
        int pagenum = Z >> this.pagesize + 1;
        if (this.interpreter.RAMPZ > 0) {
            pagenum += this.interpreter.getIORegisterByte(this.interpreter.RAMPZ) << 16 - this.pagesize - 1;
        }
        int state = this.SPMCSR.getState();
        switch (state) {
            case 3: {
                if (this.flashPrinter.enabled) {
                    this.flashPrinter.println("FLASH: page erase of page " + pagenum);
                }
                this.pageErase(pagenum, pageoffset);
                break;
            }
            case 17: {
                if (this.flashPrinter.enabled) {
                    this.flashPrinter.println("FLASH: reset RWW section ");
                }
                this.resetRWW();
                break;
            }
            case 9: {
                if (this.flashPrinter.enabled) {
                    this.flashPrinter.println("FLASH: boot lock bits set");
                }
                this.mainClock.removeEvent(this.SPMCSR.reset);
                break;
            }
            case 1: {
                if (this.flashPrinter.enabled) {
                    this.flashPrinter.println("FLASH: fill buffer @ " + pageoffset);
                }
                this.fillBuffer(pagenum, pageoffset);
                break;
            }
            case 5: {
                if (this.flashPrinter.enabled) {
                    this.flashPrinter.println("FLASH: page write to page " + pagenum);
                }
                this.pageWrite(pagenum, pageoffset);
                break;
            }
        }
    }

    private void pageErase(int pagenum, int pageoffset) {
        this.mainClock.removeEvent(this.SPMCSR.reset);
        this.SPMCSR.setBusy();
        this.mainClock.insertEvent(new EraseEvent(pagenum), this.ERASE_CYCLES);
    }

    private void pageWrite(int pagenum, int pageoffset) {
        this.mainClock.removeEvent(this.SPMCSR.reset);
        this.SPMCSR.setBusy();
        this.mainClock.insertEvent(new WriteEvent(pagenum, this.buffer), this.WRITE_CYCLES);
        this.resetBuffer();
    }

    private void resetRWW() {
        this.mainClock.removeEvent(this.SPMCSR.reset);
        if (!this.SPMCSR.isBusy()) {
            this.SPMCSR.clearBusy();
            this.SPMCSR.reset();
        }
        this.resetBuffer();
    }

    private void fillBuffer(int pagenum, int pageoffset) {
        byte r0 = this.interpreter.getRegisterByte(LegacyRegister.R0);
        byte r1 = this.interpreter.getRegisterByte(LegacyRegister.R1);
        this.SPMCSR.reset();
        this.buffer[pageoffset] = r0;
        this.buffer[pageoffset + 1] = r1;
        this.mainClock.removeEvent(this.SPMCSR.reset);
    }

    protected void resetBuffer() {
        this.buffer = new byte[this.bufferSize()];
        for (int cntr = 0; cntr < this.buffer.length; ++cntr) {
            this.buffer[cntr] = -1;
        }
    }

    private int bufferSize() {
        return 2 << this.pagesize;
    }

    public class DisassembleLegacyInstr
    extends LegacyInstr {
        protected final int address;

        DisassembleLegacyInstr(int addr) {
            super(null);
            this.address = addr;
        }

        public void accept(LegacyInstrVisitor v) {
            LegacyInstr i = ReprogrammableCodeSegment.this.disassembler.disassembleLegacy(ReprogrammableCodeSegment.this.segment_data, 0, this.address);
            if (i == null) {
                throw Util.failure("invalid instruction at " + StringUtil.addrToString(this.address));
            }
            ReprogrammableCodeSegment.this.replaceInstr(this.address, i);
            i.accept(v);
        }

        public LegacyInstr build(int address, LegacyOperand[] ops) {
            throw Util.failure("DisassembleLegacyInstr should be confined to BaseInterpreter");
        }

        public String getOperands() {
            throw Util.failure("DisassembleLegacyInstr has no operands");
        }

        public LegacyInstr asInstr() {
            LegacyInstr i = ReprogrammableCodeSegment.this.disassembler.disassembleLegacy(ReprogrammableCodeSegment.this.segment_data, 0, this.address);
            if (i == null) {
                return null;
            }
            ReprogrammableCodeSegment.this.replaceInstr(this.address, i);
            return i;
        }
    }

    class WriteEvent
    implements Simulator.Event {
        int pagenum;
        byte[] buffer;

        WriteEvent(int pagenum, byte[] buf) {
            this.pagenum = pagenum;
            this.buffer = buf;
        }

        public void fire() {
            if (ReprogrammableCodeSegment.this.flashPrinter.enabled) {
                ReprogrammableCodeSegment.this.flashPrinter.println("FLASH: page write completed for page " + this.pagenum);
            }
            int size = ReprogrammableCodeSegment.this.bufferSize();
            int addr = this.pagenum * size;
            for (int offset = 0; offset < size; ++offset) {
                int baddr = addr + offset;
                ReprogrammableCodeSegment.this.write(baddr, this.buffer[offset]);
                if ((offset & 1) != 0) continue;
                ReprogrammableCodeSegment.this.replaceInstr(baddr, new DisassembleLegacyInstr(baddr));
            }
            ReprogrammableCodeSegment.this.SPMCSR.reset();
        }
    }

    class EraseEvent
    implements Simulator.Event {
        int pagenum;

        EraseEvent(int pagenum) {
            this.pagenum = pagenum;
        }

        public void fire() {
            if (ReprogrammableCodeSegment.this.flashPrinter.enabled) {
                ReprogrammableCodeSegment.this.flashPrinter.println("FLASH: page erase completed for page " + this.pagenum);
            }
            int size = ReprogrammableCodeSegment.this.bufferSize();
            int addr = this.pagenum * size;
            for (int offset = 0; offset < size; ++offset) {
                int baddr = addr + offset;
                ReprogrammableCodeSegment.this.write(baddr, (byte)-1);
                if ((offset & 1) != 0) continue;
                ReprogrammableCodeSegment.this.replaceInstr(baddr, new DisassembleLegacyInstr(baddr));
            }
            ReprogrammableCodeSegment.this.SPMCSR.reset();
        }
    }

    private class SPMCSR_reg
    extends RWRegister {
        ResetEvent reset = new ResetEvent();

        private SPMCSR_reg() {
        }

        public void write(byte val) {
            int lower = val & 0x1F;
            switch (lower) {
                case 1: 
                case 3: 
                case 5: 
                case 9: 
                case 17: {
                    ReprogrammableCodeSegment.this.mainClock.removeEvent(this.reset);
                    ReprogrammableCodeSegment.this.mainClock.insertEvent(this.reset, 6L);
                    break;
                }
                default: {
                    lower = 0;
                }
            }
            this.value = (byte)(val & 0xFFFFFFE0 | lower);
            ReprogrammableCodeSegment.this.interpreter.setEnabled(35, Arithmetic.getBit(this.value, 7));
            ReprogrammableCodeSegment.this.interpreter.setPosted(35, !Arithmetic.getBit(this.value, 0));
        }

        int getState() {
            return this.value & 0x1F;
        }

        void reset() {
            this.write((byte)(this.value & 0xFFFFFFE0));
        }

        boolean isBusy() {
            return Arithmetic.getBit(this.value, 6);
        }

        void setBusy() {
            this.value = Arithmetic.setBit(this.value, 6);
        }

        void clearBusy() {
            this.value = Arithmetic.clearBit(this.value, 6);
        }

        class ResetEvent
        implements Simulator.Event {
            ResetEvent() {
            }

            public void fire() {
                if (ReprogrammableCodeSegment.this.flashPrinter.enabled) {
                    ReprogrammableCodeSegment.this.flashPrinter.println("FLASH: write to SPMCSR timed out after 4 cycles");
                }
                SPMCSR_reg.this.reset();
            }
        }
    }

    public static class Factory
    implements CodeSegment.Factory {
        final int pagesize;
        final int size;

        Factory(int size, int pagesize) {
            this.size = size;
            this.pagesize = pagesize;
        }

        public CodeSegment newCodeSegment(String name, AtmelInterpreter bi, Program p) {
            ReprogrammableCodeSegment cs;
            if (p != null) {
                cs = new ReprogrammableCodeSegment(name, p.program_end, bi, this.pagesize);
                cs.load(p);
            } else {
                cs = new ReprogrammableCodeSegment(name, this.size, bi, this.pagesize);
            }
            return cs;
        }
    }
}

