/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.mcu;

import avrora.sim.ActiveRegister;
import avrora.sim.RWRegister;
import avrora.sim.mcu.RegisterLayout;
import cck.text.StringUtil;
import cck.util.Util;
import java.util.HashMap;

public class RegisterSet {
    protected final HashMap fields = new HashMap();
    protected final ActiveRegister[] registers;
    protected final RegisterLayout layout;

    public RegisterSet(RegisterLayout rl) {
        this.registers = new ActiveRegister[rl.ioreg_size];
        this.layout = rl;
        for (RegisterLayout.Field f : rl.fields.values()) {
            FieldWriter fw = new FieldWriter();
            fw.fobject = new Field();
            this.fields.put(f.name, fw);
        }
        for (int ior = 0; ior < rl.ioreg_size; ++ior) {
            RegisterLayout.RegisterInfo ri = rl.info[ior];
            this.registers[ior] = ri == null || ri.subfields == null ? new RWRegister() : this.createMultiFieldRegister(ri);
        }
    }

    private MultiFieldRegister createMultiFieldRegister(RegisterLayout.RegisterInfo ri) {
        SubRegWriter[] srw = new SubRegWriter[ri.subfields.length];
        for (int cntr = 0; cntr < srw.length; ++cntr) {
            this.createSubRegWriter(ri, cntr, srw);
        }
        return new MultiFieldRegister(srw);
    }

    private void createSubRegWriter(RegisterLayout.RegisterInfo ri, int cntr, SubRegWriter[] srw) {
        RegisterLayout.SubField sf = ri.subfields[cntr];
        RegisterLayout.Field field = sf.field;
        srw[cntr] = sf.field == RegisterLayout.RESERVED ? new ReservedWriter(sf) : (sf.field == RegisterLayout.UNUSED ? new UnusedWriter(sf) : (sf.field.subfields.length == 1 ? new TotalFieldWriter(sf, (FieldWriter)this.fields.get(field.name)) : new SubFieldWriter(sf, (FieldWriter)this.fields.get(field.name))));
    }

    public int getSize() {
        return this.registers.length;
    }

    public RegisterLayout getRegisterLayout() {
        return this.layout;
    }

    public ActiveRegister[] share() {
        return this.registers;
    }

    public Field getField(String fname) {
        FieldWriter fwriter = this.getFieldWriter(fname);
        return fwriter.fobject;
    }

    private FieldWriter getFieldWriter(String fname) {
        FieldWriter fwriter = (FieldWriter)this.fields.get(fname);
        if (fwriter == null) {
            throw Util.failure("Field not found in RegisterSet: " + StringUtil.quote(fname));
        }
        return fwriter;
    }

    public Field installField(String fname, Field fo) {
        FieldWriter fwriter = this.getFieldWriter(fname);
        fwriter.fobject = fo;
        return fo;
    }

    public class MultiFieldRegister
    implements ActiveRegister {
        byte value;
        final SubRegWriter[] subFields;

        MultiFieldRegister(SubRegWriter[] srw) {
            this.subFields = srw;
        }

        public byte read() {
            return this.value;
        }

        public void write(byte nval) {
            this.value = nval;
            for (int cntr = 0; cntr < this.subFields.length; ++cntr) {
                SubRegWriter sf = this.subFields[cntr];
                sf.write(nval);
            }
        }
    }

    static class UnusedWriter
    extends SubRegWriter {
        UnusedWriter(RegisterLayout.SubField sf) {
            super(sf);
        }

        void write(byte val) {
        }
    }

    static class ReservedWriter
    extends SubRegWriter {
        ReservedWriter(RegisterLayout.SubField sf) {
            super(sf);
        }

        void write(byte val) {
        }
    }

    static class TotalFieldWriter
    extends SubRegWriter {
        final FieldWriter fieldWriter;

        TotalFieldWriter(RegisterLayout.SubField sf, FieldWriter fw) {
            super(sf);
            this.fieldWriter = fw;
        }

        void write(byte val) {
            int value = val >> this.ior_low_bit & this.mask;
            this.fieldWriter.fobject.write(value);
        }
    }

    static class SubFieldWriter
    extends SubRegWriter {
        final FieldWriter fieldWriter;
        final RegisterLayout.SubField subField;

        SubFieldWriter(RegisterLayout.SubField sf, FieldWriter fw) {
            super(sf);
            this.subField = sf;
            this.fieldWriter = fw;
        }

        void write(byte val) {
            int wval = val >> this.ior_low_bit & this.mask;
            this.fieldWriter.value |= wval << this.subField.field_low_bit;
            this.fieldWriter.writtenMask |= this.mask << this.subField.field_low_bit;
            if (this.subField.commit) {
                this.fieldWriter.commit();
            }
        }
    }

    static abstract class SubRegWriter {
        final int ior_low_bit;
        final int mask;
        final int length;

        SubRegWriter(RegisterLayout.SubField sf) {
            this.ior_low_bit = sf.ior_low_bit;
            this.mask = sf.mask;
            this.length = sf.length;
        }

        abstract void write(byte var1);
    }

    static class FieldWriter {
        int value;
        int writtenMask;
        Field fobject;

        FieldWriter() {
        }

        void commit() {
            this.fobject.write(this.value, this.writtenMask);
            this.value = 0;
            this.writtenMask = 0;
        }
    }

    public static class Field {
        public int value;

        public void write(int nval, int wmask) {
            this.value = this.value & ~wmask | nval;
            this.update();
        }

        public void write(int nval) {
            this.value = nval;
            this.update();
        }

        public void set(int nval) {
            throw Util.unimplemented();
        }

        public void update() {
        }
    }
}

