/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.mcu;

import avrora.sim.mcu.RegisterSet;
import cck.text.StringUtil;
import cck.util.Arithmetic;
import cck.util.Util;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.NoSuchElementException;

public class RegisterLayout {
    public static final Field UNUSED = new Field("UNUSED");
    public static final Field RESERVED = new Field("RESERVED");
    public final int ioreg_size;
    public final int ioreg_length;
    protected final HashMap ioregAssignments;
    protected final RegisterInfo[] info;
    protected final HashMap fields;

    public RegisterLayout(int is, int rlength) {
        this.ioreg_size = is;
        this.ioregAssignments = new HashMap();
        this.fields = new HashMap();
        this.info = new RegisterInfo[is];
        this.ioreg_length = rlength;
    }

    public void addIOReg(String n, int ior_num) {
        RegisterInfo i;
        if (ior_num >= this.ioreg_size) {
            throw new Util.Error("Layout Error", "invalid register address " + ior_num + " for register " + StringUtil.quote(n));
        }
        this.info[ior_num] = i = new RegisterInfo(n, ior_num);
        this.ioregAssignments.put(n, i);
    }

    public void addIOReg(String n, int ior_num, String format) {
        if (ior_num >= this.ioreg_size) {
            throw new Util.Error("Layout Error", "invalid register address " + ior_num + " for register " + StringUtil.quote(n));
        }
        RegisterInfo i = new RegisterInfo(n, ior_num);
        i.subfields = this.parseSubFields(n, ior_num, format);
        this.info[ior_num] = i;
        this.ioregAssignments.put(n, i);
    }

    public int getIOReg(String n) {
        RegisterInfo i = (RegisterInfo)this.ioregAssignments.get(n);
        if (i == null) {
            throw new NoSuchElementException(StringUtil.quote(n) + " IO register not found");
        }
        return i.ior_num;
    }

    public boolean hasIOReg(String n) {
        return this.ioregAssignments.containsKey(n);
    }

    public RegisterSet instantiate() {
        return new RegisterSet(this);
    }

    public String getRegisterName(int ior) {
        RegisterInfo registerInfo = this.info[ior];
        return registerInfo != null ? registerInfo.name : "";
    }

    private SubField[] parseSubFields(String name, int ior, String desc) {
        int totalbits = 0;
        int count = 0;
        SubField[] sfs = new SubField[8];
        StringCharacterIterator i = new StringCharacterIterator(desc);
        int ior_hbit = 7;
        while (ior_hbit >= 0 && i.current() != '\uffff') {
            if (i.current() == '.') {
                ior_hbit = this.readUnusedField(i, sfs, count, ior_hbit);
                totalbits += sfs[count].length;
            } else if (i.current() == 'x') {
                ior_hbit = this.readReservedField(i, sfs, count, ior_hbit);
                totalbits += sfs[count].length;
            } else {
                ior_hbit = this.readNamedField(i, ior, sfs, count, ior_hbit);
                totalbits += sfs[count].length;
            }
            ++count;
            StringUtil.peekAndEat((CharacterIterator)i, ',');
            StringUtil.skipWhiteSpace(i);
        }
        if (totalbits != this.ioreg_length) {
            throw new Util.Error("Layout Error", "expected " + this.ioreg_length + " bits, found: " + totalbits + " in " + StringUtil.quote(name));
        }
        SubField[] subFields = new SubField[count];
        System.arraycopy(sfs, 0, subFields, 0, count);
        HashSet<Field> fs = new HashSet<Field>();
        for (int cntr = subFields.length - 1; cntr >= 0; --cntr) {
            SubField subField = subFields[cntr];
            if (!fs.contains(subField.field)) {
                subField.commit = true;
            }
            fs.add(subField.field);
        }
        return subFields;
    }

    private int readNamedField(StringCharacterIterator i, int ior, SubField[] sfs, int count, int ior_hbit) {
        String fid = StringUtil.readIdentifier(i);
        Field field = this.getField(fid);
        SubField sf = new SubField(field, ior);
        field.add(sf);
        sfs[count] = sf;
        ior_hbit = StringUtil.peekAndEat((CharacterIterator)i, '[') ? this.readBitRange(i, ior_hbit, sf) : this.readBit(ior_hbit, sf);
        return ior_hbit;
    }

    private int readReservedField(StringCharacterIterator i, SubField[] sfs, int count, int ior_hbit) {
        SubField sf;
        sfs[count] = sf = new SubField(RESERVED, -1);
        ior_hbit = this.eat(ior_hbit, i, sf, 'x');
        return ior_hbit;
    }

    private int readUnusedField(StringCharacterIterator i, SubField[] sfs, int count, int ior_hbit) {
        SubField sf;
        sfs[count] = sf = new SubField(UNUSED, -1);
        ior_hbit = this.eat(ior_hbit, i, sf, '.');
        return ior_hbit;
    }

    private int readBit(int ior_hbit, SubField sf) {
        sf.ior_low_bit = ior_hbit--;
        sf.field_low_bit = 0;
        sf.mask = 1;
        sf.length = 1;
        return ior_hbit;
    }

    private int readBitRange(StringCharacterIterator i, int ior_hbit, SubField sf) {
        int fhbit;
        int flbit = fhbit = StringUtil.readDecimalValue(i, 1);
        if (StringUtil.peekAndEat((CharacterIterator)i, ':')) {
            flbit = StringUtil.readDecimalValue(i, 1);
        }
        int length = fhbit - flbit + 1;
        sf.ior_low_bit = ior_hbit - length + 1;
        sf.field_low_bit = flbit;
        sf.mask = 255 >> 8 - length;
        sf.length = length;
        StringUtil.peekAndEat((CharacterIterator)i, ']');
        return ior_hbit -= length;
    }

    private int eat(int ior_hbit, StringCharacterIterator i, SubField sf, char c) {
        int hbit = ior_hbit;
        while (i.current() == c) {
            ++sf.length;
            i.next();
        }
        sf.ior_low_bit = hbit - sf.length + 1;
        sf.mask = Arithmetic.getBitMask(sf.length);
        return ior_hbit -= sf.length;
    }

    private Field getField(String name) {
        Field f = (Field)this.fields.get(name);
        if (f == null) {
            f = new Field(name);
            this.fields.put(name, f);
        }
        return f;
    }

    protected static class SubField {
        final Field field;
        final int ior;
        int length;
        int ior_low_bit;
        int field_low_bit;
        int mask;
        boolean commit;

        SubField(Field f, int ior) {
            this.field = f;
            this.ior = ior;
        }
    }

    protected static class Field {
        final String name;
        int length;
        SubField[] subfields;

        Field(String n) {
            this.name = n;
        }

        void add(SubField sf) {
            if (this.subfields == null) {
                this.subfields = new SubField[1];
            } else {
                SubField[] nsf = new SubField[this.subfields.length + 1];
                System.arraycopy(this.subfields, 0, nsf, 0, this.subfields.length);
                this.subfields = nsf;
            }
            this.subfields[this.subfields.length - 1] = sf;
            int highbit = sf.field_low_bit + sf.length;
            if (highbit > this.length) {
                this.length = highbit;
            }
        }
    }

    protected static class RegisterInfo {
        final String name;
        final int ior_num;
        SubField[] subfields;

        RegisterInfo(String n, int ior) {
            this.name = n;
            this.ior_num = ior;
        }
    }
}

