/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.mcu;

import avrora.sim.mcu.RegisterLayout;
import cck.text.StringUtil;
import java.util.HashMap;
import java.util.NoSuchElementException;

public class MCUProperties {
    protected static final int BASE_ADDRESS = 32;
    protected final HashMap pinAssignments;
    protected final RegisterLayout layout;
    protected final HashMap interruptAssignments;
    protected final String[] ioreg_name;
    protected final String[] interrupt_name;
    public final int num_interrupts;

    protected MCUProperties(HashMap pa, RegisterLayout rl, HashMap inta, int ni) {
        this.pinAssignments = pa;
        this.layout = rl;
        this.interruptAssignments = inta;
        this.ioreg_name = this.initIORNames();
        this.interrupt_name = this.initInterruptNames();
        this.num_interrupts = ni;
    }

    public RegisterLayout getRegisterLayout() {
        return this.layout;
    }

    protected String[] initInterruptNames() {
        int max = this.getMax();
        String[] interrupt_name = new String[max + 1];
        for (String s : this.interruptAssignments.keySet()) {
            Integer iv = (Integer)this.interruptAssignments.get(s);
            interrupt_name[iv.intValue()] = s;
        }
        return interrupt_name;
    }

    private int getMax() {
        int max = 0;
        for (String s : this.interruptAssignments.keySet()) {
            int v = (Integer)this.interruptAssignments.get(s);
            if (max >= v) continue;
            max = v;
        }
        return max;
    }

    protected String[] initIORNames() {
        String[] ioreg_name = new String[this.layout.ioreg_size];
        for (int cntr = 0; cntr < this.layout.ioreg_size; ++cntr) {
            RegisterLayout.RegisterInfo registerInfo = this.layout.info[cntr];
            if (registerInfo == null) continue;
            ioreg_name[cntr] = registerInfo.name;
        }
        return ioreg_name;
    }

    public int getPin(String n) {
        Integer i = (Integer)this.pinAssignments.get(n);
        if (i == null) {
            throw new NoSuchElementException(StringUtil.quote(n) + " pin not found");
        }
        return i;
    }

    public int getIOReg(String n) {
        return this.layout.getIOReg(n);
    }

    public int getIORegAddr(String n) {
        return this.getIOReg(n) + 32;
    }

    public boolean hasIOReg(String n) {
        return this.layout.hasIOReg(n);
    }

    public int getInterrupt(String n) {
        Integer i = (Integer)this.interruptAssignments.get(n);
        if (i == null) {
            throw new NoSuchElementException(StringUtil.quote(n) + " interrupt not found");
        }
        return i;
    }

    public String getIORegName(int ioreg) {
        return this.ioreg_name[ioreg];
    }

    public String getInterruptName(int inum) {
        return this.interrupt_name[inum];
    }
}

