/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.mcu;

import avrora.sim.RWRegister;
import avrora.sim.Simulator;
import avrora.sim.mcu.AtmelInternalDevice;
import avrora.sim.mcu.AtmelMicrocontroller;
import avrora.sim.state.BooleanView;
import avrora.sim.state.RegisterUtil;
import cck.text.StringUtil;
import cck.util.Arithmetic;

public class EEPROM
extends AtmelInternalDevice {
    final int EEPROM_SIZE;
    final int EEPROM_SIZE_numBits;
    public static final int EEARH = 31;
    public static final int EEARL = 30;
    public static final int EEDR = 29;
    public static final int EECR = 28;
    final byte[] EEPROM_data;
    final RWRegister EEDR_reg;
    final EECRReg EECR_reg;
    final RWRegister EEARL_reg;
    final EEARHReg EEARH_reg;
    static final int EERIE = 3;
    static final int EEMWE = 2;
    static final int EEWE = 1;
    static final int EERE = 0;
    static final int EEPROM_INTERRUPT = 23;
    boolean masterWriteEnable;
    boolean writeEnable;
    boolean readEnable;
    final EEPROMTicker ticker = new EEPROMTicker();
    final EEPROMWriteFinishedEvent writeFinishedEvent = new EEPROMWriteFinishedEvent();
    int writeCount = -1;
    boolean writeEnableWritten;
    boolean readEnableWritten;

    EEPROM(int size, AtmelMicrocontroller m) {
        super("eeprom", m);
        this.EEDR_reg = new RWRegister();
        this.EECR_reg = new EECRReg();
        this.EEARL_reg = new EEARLReg();
        this.EEARH_reg = new EEARHReg();
        this.EEPROM_SIZE = size;
        this.EEPROM_SIZE_numBits = Arithmetic.log(size);
        this.EEPROM_data = new byte[this.EEPROM_SIZE];
        this.installIOReg("EEDR", this.EEDR_reg);
        this.installIOReg("EECR", this.EECR_reg);
        this.installIOReg("EEARL", this.EEARL_reg);
        this.installIOReg("EEARH", this.EEARH_reg);
    }

    public int getSize() {
        return this.EEPROM_SIZE;
    }

    public void setContent(byte[] contents) {
        for (int addr = 0; addr < contents.length; ++addr) {
            this.EEPROM_data[addr] = contents[addr];
        }
        if (this.devicePrinter.enabled) {
            this.devicePrinter.println("EEPROM: content set");
        }
    }

    public byte[] getContent() {
        return this.EEPROM_data;
    }

    protected class EEPROMWriteFinishedEvent
    implements Simulator.Event {
        protected EEPROMWriteFinishedEvent() {
        }

        public void fire() {
            if (EEPROM.this.devicePrinter.enabled) {
                EEPROM.this.devicePrinter.println("EEPROM: write finished, clearing EEWE");
            }
            EEPROM.this.EECR_reg.resetEEWE();
        }
    }

    protected class EEPROMTicker
    implements Simulator.Event {
        protected EEPROMTicker() {
        }

        public void fire() {
            if (EEPROM.this.devicePrinter.enabled) {
                EEPROM.this.devicePrinter.println("Tick : " + EEPROM.this.writeCount);
            }
            int address = AtmelInternalDevice.read16(EEPROM.this.EEARH_reg, EEPROM.this.EEARL_reg);
            if (EEPROM.this.writeCount > 0 && EEPROM.this.writeEnableWritten) {
                if (EEPROM.this.devicePrinter.enabled) {
                    EEPROM.this.devicePrinter.println("EEPROM: " + EEPROM.this.EEDR_reg.read() + " written to " + address);
                }
                EEPROM.this.EEPROM_data[address] = EEPROM.this.EEDR_reg.read();
                EEPROM.this.mainClock.insertEvent(EEPROM.this.writeFinishedEvent, (long)((double)EEPROM.this.mainClock.getHZ() * 0.0085));
                EEPROM.this.simulator.delay(2L);
            }
            if (EEPROM.this.readEnableWritten && !EEPROM.this.writeEnable) {
                if (EEPROM.this.devicePrinter.enabled) {
                    EEPROM.this.devicePrinter.println("EEPROM: " + EEPROM.this.EEPROM_data[address] + " read from " + address);
                }
                EEPROM.this.EEDR_reg.write(EEPROM.this.EEPROM_data[address]);
                EEPROM.this.EECR_reg.resetEERE();
                EEPROM.this.simulator.delay(4L);
            }
            if (EEPROM.this.writeCount > 0) {
                --EEPROM.this.writeCount;
                EEPROM.this.mainClock.insertEvent(EEPROM.this.ticker, 1L);
            }
            if (EEPROM.this.writeCount == 0) {
                if (EEPROM.this.devicePrinter.enabled) {
                    EEPROM.this.devicePrinter.println("EEPROM: write count hit 0, clearing EEMWE");
                }
                --EEPROM.this.writeCount;
                EEPROM.this.EECR_reg.resetEEMWE();
            }
            EEPROM.this.writeEnableWritten = false;
            EEPROM.this.readEnableWritten = false;
        }
    }

    protected class EECRReg
    extends RWRegister {
        final BooleanView _eerie = RegisterUtil.booleanView(this, 3);
        final BooleanView _eere = RegisterUtil.booleanView(this, 0);
        final BooleanView _eemwe = RegisterUtil.booleanView(this, 2);
        final BooleanView _eewe = RegisterUtil.booleanView(this, 1);

        protected EECRReg() {
        }

        public void decode() {
            EEPROM.this.readEnable = this._eere.getValue();
            if (this.newTrue(EEPROM.this.readEnable, EEPROM.this.readEnable)) {
                if (EEPROM.this.devicePrinter.enabled) {
                    EEPROM.this.devicePrinter.println("EEPROM: EERE flagged");
                }
                EEPROM.this.readEnableWritten = true;
            }
            if (this.newTrue(EEPROM.this.writeEnable = this._eewe.getValue(), EEPROM.this.writeEnable)) {
                if (EEPROM.this.devicePrinter.enabled) {
                    EEPROM.this.devicePrinter.println("EEPROM: EEWE flagged");
                }
                EEPROM.this.writeEnableWritten = true;
            }
            if (this.newTrue(EEPROM.this.masterWriteEnable = this._eemwe.getValue(), EEPROM.this.masterWriteEnable)) {
                if (EEPROM.this.devicePrinter.enabled) {
                    EEPROM.this.devicePrinter.println("EEPROM: reset write count to 4");
                }
                EEPROM.this.writeCount = 4;
            }
            EEPROM.this.interpreter.setEnabled(23, this._eerie.getValue());
            EEPROM.this.interpreter.setPosted(23, !EEPROM.this.writeEnable);
            EEPROM.this.mainClock.insertEvent(EEPROM.this.ticker, 1L);
        }

        public void write(byte val) {
            this.value = (byte)(0xF & val);
            if (EEPROM.this.devicePrinter.enabled) {
                EEPROM.this.devicePrinter.println("EEPROM: EECR written to, val = " + StringUtil.toBin(this.value, 4));
            }
            this.decode();
        }

        private boolean newTrue(boolean b1, boolean b2) {
            return !b1 && b2;
        }

        public void resetEERE() {
            this._eere.setValue(false);
            this.decode();
        }

        public void resetEEMWE() {
            this._eemwe.setValue(false);
            this.decode();
        }

        public void resetEEWE() {
            this._eewe.setValue(false);
            this.decode();
        }
    }

    protected class EEARLReg
    extends RWRegister {
        protected EEARLReg() {
        }

        public void write(byte val) {
            if (EEPROM.this.writeEnable) {
                return;
            }
            this.value = (byte)(val & Math.min(EEPROM.this.EEPROM_SIZE - 1, 255));
        }
    }

    protected class EEARHReg
    extends RWRegister {
        protected EEARHReg() {
        }

        public void write(byte val) {
            if (EEPROM.this.writeEnable) {
                return;
            }
            this.value = (byte)(val & (EEPROM.this.EEPROM_SIZE >> 8) - 1);
        }
    }
}

