/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.mcu;

import avrora.sim.FiniteStateMachine;
import avrora.sim.Simulator;
import avrora.sim.clock.Clock;
import avrora.sim.clock.ClockDomain;
import avrora.sim.mcu.Microcontroller;
import avrora.sim.mcu.RegisterSet;
import avrora.sim.output.SimPrinter;
import avrora.sim.platform.Platform;
import avrora.sim.util.SimUtil;

public abstract class DefaultMCU
implements Microcontroller {
    protected final Microcontroller.Pin[] pins;
    protected final RegisterSet registers;
    protected Platform platform;
    protected Simulator simulator;
    protected SimPrinter pinPrinter;
    protected final ClockDomain clockDomain;
    protected final FiniteStateMachine sleepState;

    protected DefaultMCU(ClockDomain cd, int np, RegisterSet regs, FiniteStateMachine sleep) {
        this.clockDomain = cd;
        this.pins = new Microcontroller.Pin[np];
        this.sleepState = sleep;
        this.registers = regs;
    }

    public FiniteStateMachine getFSM() {
        return this.sleepState;
    }

    public RegisterSet getRegisterSet() {
        return this.registers;
    }

    public Microcontroller.Pin getPin(int num) {
        if (num < 0 || num > this.pins.length) {
            return null;
        }
        return this.pins[num];
    }

    public Clock getClock(String name) {
        return this.clockDomain.getClock(name);
    }

    public Simulator getSimulator() {
        return this.simulator;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform p) {
        this.platform = p;
    }

    public ClockDomain getClockDomain() {
        return this.clockDomain;
    }

    protected class Pin
    implements Microcontroller.Pin {
        protected final int number;
        boolean level;
        boolean outputDir;
        boolean pullup;
        Microcontroller.Pin.Input input;
        Microcontroller.Pin.Output output;

        protected Pin(int num) {
            this.number = num;
        }

        public void connectOutput(Microcontroller.Pin.Output o) {
            this.output = o;
        }

        public void connectInput(Microcontroller.Pin.Input i) {
            this.input = i;
        }

        protected void setOutputDir(boolean out2) {
            this.outputDir = out2;
            if (out2) {
                this.write(this.level);
            }
        }

        protected void setPullup(boolean pull) {
            this.pullup = pull;
        }

        protected boolean read() {
            boolean result = !this.outputDir ? (this.input != null ? this.input.read() : this.pullup) : this.level;
            this.printRead(result);
            return result;
        }

        private void printRead(boolean result) {
            if (DefaultMCU.this.pinPrinter == null) {
                DefaultMCU.this.pinPrinter = SimUtil.getPrinter(DefaultMCU.this.simulator, "mcu.pin");
            }
            if (DefaultMCU.this.pinPrinter.enabled) {
                String dir = this.getDirection();
                DefaultMCU.this.pinPrinter.println("READ PIN: " + this.number + ' ' + dir + "<- " + result);
            }
        }

        private String getDirection() {
            if (!this.outputDir) {
                if (this.input != null) {
                    return "[input] ";
                }
                return "[pullup:" + this.pullup + "] ";
            }
            return "[output] ";
        }

        protected void write(boolean value) {
            this.level = value;
            this.printWrite(value);
            if (this.outputDir && this.output != null) {
                this.output.write(value);
            }
        }

        private void printWrite(boolean value) {
            if (DefaultMCU.this.pinPrinter == null) {
                DefaultMCU.this.pinPrinter = SimUtil.getPrinter(DefaultMCU.this.simulator, "mcu.pin");
            }
            if (DefaultMCU.this.pinPrinter.enabled) {
                String dir = this.getDirection();
                DefaultMCU.this.pinPrinter.println("WRITE PIN: " + this.number + ' ' + dir + "-> " + value);
            }
        }
    }
}

