/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.mcu;

import avrora.arch.avr.AVRProperties;
import avrora.sim.ActiveRegister;
import avrora.sim.AtmelInterpreter;
import avrora.sim.FiniteStateMachine;
import avrora.sim.clock.ClockDomain;
import avrora.sim.clock.MainClock;
import avrora.sim.mcu.AtmelInternalDevice;
import avrora.sim.mcu.DefaultMCU;
import avrora.sim.mcu.MCUProperties;
import avrora.sim.mcu.Microcontroller;
import java.util.HashMap;

public abstract class AtmelMicrocontroller
extends DefaultMCU {
    protected final MainClock mainClock;
    protected AtmelInterpreter interpreter;
    public final AVRProperties properties;
    protected final HashMap devices;
    public static final int MODE_ACTIVE = 0;

    public void sleep() {
        this.sleepState.transition(this.getSleepMode());
    }

    protected abstract int getSleepMode();

    public int wakeup() {
        this.sleepState.transition(0);
        return this.sleepState.getTransitionTime(this.sleepState.getCurrentState(), 0);
    }

    protected AtmelMicrocontroller(ClockDomain cd, AVRProperties p, FiniteStateMachine fsm) {
        super(cd, p.num_pins, p.getRegisterLayout().instantiate(), fsm);
        this.mainClock = cd.getMainClock();
        this.properties = p;
        this.devices = new HashMap();
    }

    protected ActiveRegister installIOReg(String name, ActiveRegister reg) {
        this.interpreter.installIOReg(this.properties.getIOReg(name), reg);
        return reg;
    }

    protected ActiveRegister getIOReg(String name) {
        return this.interpreter.getIOReg(this.properties.getIOReg(name));
    }

    protected void addDevice(AtmelInternalDevice d) {
        this.devices.put(d.name, d);
    }

    public AtmelInternalDevice getDevice(String name) {
        return (AtmelInternalDevice)this.devices.get(name);
    }

    public static void addPin(HashMap pinMap, int p, String n) {
        pinMap.put(n, new Integer(p));
    }

    public static void addPin(HashMap pinMap, int p, String n1, String n2) {
        Integer i = new Integer(p);
        pinMap.put(n1, i);
        pinMap.put(n2, i);
    }

    public static void addPin(HashMap pinMap, int p, String n1, String n2, String n3) {
        Integer i = new Integer(p);
        pinMap.put(n1, i);
        pinMap.put(n2, i);
        pinMap.put(n3, i);
    }

    public static void addPin(HashMap pinMap, int p, String n1, String n2, String n3, String n4) {
        Integer i = new Integer(p);
        pinMap.put(n1, i);
        pinMap.put(n2, i);
        pinMap.put(n3, i);
        pinMap.put(n4, i);
    }

    public static void addInterrupt(HashMap iMap, String n, int i) {
        iMap.put(n, new Integer(i));
    }

    public Microcontroller.Pin getPin(String n) {
        return this.pins[this.properties.getPin(n)];
    }

    public MCUProperties getProperties() {
        return this.properties;
    }
}

