/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.mcu;

import avrora.sim.ActiveRegister;
import avrora.sim.AtmelInterpreter;
import avrora.sim.RWRegister;
import avrora.sim.Simulator;
import avrora.sim.clock.Clock;
import avrora.sim.mcu.AtmelMicrocontroller;
import avrora.sim.output.EventGen;
import avrora.sim.output.SimPrinter;
import avrora.sim.util.SimUtil;
import cck.util.Util;
import java.util.Iterator;

public abstract class AtmelInternalDevice {
    public final String name;
    protected final AtmelMicrocontroller microcontroller;
    protected final Simulator simulator;
    protected final AtmelInterpreter interpreter;
    protected final SimPrinter devicePrinter;
    protected final EventGen event;
    protected final Clock mainClock;

    public AtmelInternalDevice(String n, AtmelMicrocontroller m) {
        this.name = n;
        this.microcontroller = m;
        this.simulator = m.getSimulator();
        this.mainClock = this.simulator.getClock();
        this.interpreter = (AtmelInterpreter)this.simulator.getInterpreter();
        this.devicePrinter = SimUtil.getPrinter(m.getSimulator(), "atmel." + n);
        this.event = SimUtil.getEventGen(m.getSimulator(), "atmel." + n);
    }

    public Iterator getIORegs() {
        throw Util.unimplemented();
    }

    protected void installIOReg(String name, ActiveRegister reg) {
        this.microcontroller.installIOReg(name, reg);
    }

    protected static int read16(RWRegister high, RWRegister low) {
        int result = low.read() & 0xFF;
        return result |= (high.read() & 0xFF) << 8;
    }

    protected static void write16(int val, RWRegister high, RWRegister low) {
        high.write((byte)((val & 0xFF00) >> 8));
        low.write((byte)(val & 0xFF));
    }

    public Clock getClock() {
        return this.mainClock;
    }
}

