/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.mcu;

import avrora.arch.avr.AVRProperties;
import avrora.arch.legacy.LegacyInterpreter;
import avrora.core.Program;
import avrora.sim.ActiveRegister;
import avrora.sim.AtmelInterpreter;
import avrora.sim.FiniteStateMachine;
import avrora.sim.Simulator;
import avrora.sim.clock.Clock;
import avrora.sim.clock.ClockDomain;
import avrora.sim.mcu.ADC;
import avrora.sim.mcu.ATMegaFamilyNew;
import avrora.sim.mcu.AtmelMicrocontroller;
import avrora.sim.mcu.DefaultMCU;
import avrora.sim.mcu.EEPROM;
import avrora.sim.mcu.RegisterLayout;
import avrora.sim.mcu.SPI;
import avrora.sim.mcu.USART;
import cck.util.Arithmetic;
import java.util.HashMap;

public abstract class ATMegaX8
extends ATMegaFamilyNew {
    public static final int _1kb = 1024;
    public static final int _512b = 512;
    public static final int ATMEGAX8_IOREG_SIZE = 256;
    public static final int ATMEGAX8_NUM_PINS = 32;
    public static final int ATMEGAX8_NUM_INTS = 24;
    public static final int MODE_IDLE = 1;
    public static final int MODE_ADCNRED = 2;
    public static final int MODE_POWERDOWN = 3;
    public static final int MODE_POWERSAVE = 4;
    public static final int MODE_RESERVED1 = 5;
    public static final int MODE_RESERVED2 = 6;
    public static final int MODE_STANDBY = 7;
    public static final int MODE_RESERVED3 = 8;
    protected static final String[] idleModeNames = new String[]{"Active", "Idle", "ADC Noise Reduction", "Power Down", "Power Save", "RESERVED 1", "RESERVED 2", "Standby", "RESERVED 3"};
    protected final ActiveRegister MCUCR_reg;
    public static final int pkgPDIP = 0;
    public static final int pkgTQFP = 1;
    public static final int pkgMLF = 2;
    public static int pkg = 0;
    protected static final HashMap pinAssignments = new HashMap(150);
    protected static final RegisterLayout rl = new RegisterLayout(256, 8);
    protected static final HashMap interruptAssignments = new HashMap(30);
    protected ATMegaFamilyNew.FlagRegister TIFR0_reg;
    protected ATMegaFamilyNew.MaskRegister TIMSK0_reg;
    protected ATMegaFamilyNew.FlagRegister TIFR1_reg;
    protected ATMegaFamilyNew.MaskRegister TIMSK1_reg;
    protected ATMegaFamilyNew.FlagRegister TIFR2_reg;
    protected ATMegaFamilyNew.MaskRegister TIMSK2_reg;
    private static final int[] MCUCR_sm_perm;

    public ATMegaX8(int id, AVRProperties props, ClockDomain cd, Program p, int[][] transitionTimeMatrix) {
        super(cd, props, new FiniteStateMachine((Clock)cd.getMainClock(), 0, idleModeNames, transitionTimeMatrix));
        this.simulator = new Simulator(id, LegacyInterpreter.FACTORY, this, p);
        this.interpreter = (AtmelInterpreter)this.simulator.getInterpreter();
        this.MCUCR_reg = this.getIOReg("MCUCR");
        this.installPins();
        this.installDevices();
    }

    protected void installPins() {
        for (int cntr = 0; cntr < this.properties.num_pins; ++cntr) {
            this.pins[cntr] = new DefaultMCU.Pin(this, cntr);
        }
    }

    protected void installDevices() {
        this.EIFR_reg = this.buildInterruptRange(true, "EIMSK", "EIFR", 2, 5);
        int[] TIFR0_mapping = new int[]{10, 8, 9, -1, -1, -1, -1, -1, -1};
        this.TIFR0_reg = new ATMegaFamilyNew.FlagRegister(this.interpreter, TIFR0_mapping);
        this.TIMSK0_reg = new ATMegaFamilyNew.MaskRegister(this.interpreter, TIFR0_mapping);
        this.installIOReg("TIMSK0", this.TIMSK0_reg);
        this.installIOReg("TIFR0", this.TIFR0_reg);
        int[] TIFR1_mapping = new int[]{14, 12, 13, -1, -1, -1, 11, -1, -1};
        this.TIFR1_reg = new ATMegaFamilyNew.FlagRegister(this.interpreter, TIFR1_mapping);
        this.TIMSK1_reg = new ATMegaFamilyNew.MaskRegister(this.interpreter, TIFR1_mapping);
        this.installIOReg("TIMSK1", this.TIMSK1_reg);
        this.installIOReg("TIFR1", this.TIFR1_reg);
        int[] TIFR2_mapping = new int[]{17, 15, 16, -1, -1, -1, -1, -1, -1};
        this.TIFR2_reg = new ATMegaFamilyNew.FlagRegister(this.interpreter, TIFR2_mapping);
        this.TIMSK2_reg = new ATMegaFamilyNew.MaskRegister(this.interpreter, TIFR2_mapping);
        this.installIOReg("TIMSK2", this.TIMSK2_reg);
        this.installIOReg("TIFR2", this.TIFR2_reg);
        this.buildPort('B');
        this.buildPort('C', 7);
        this.buildPort('D');
        this.addDevice(new EEPROM(this.properties.eeprom_size, (AtmelMicrocontroller)this));
        this.addDevice(new USART("0", this));
        this.addDevice(new SPI(this));
        this.addDevice(new ADC(this, 8));
    }

    protected int getSleepMode() {
        byte value = this.MCUCR_reg.read();
        boolean sleepEnable = Arithmetic.getBit(value, 5);
        if (sleepEnable) {
            return Arithmetic.getBitField(value, MCUCR_sm_perm) + 1;
        }
        return 1;
    }

    static {
        switch (pkg) {
            case 0: {
                ATMegaX8.addPin(pinAssignments, 1, "RESET", "PC6");
                ATMegaX8.addPin(pinAssignments, 2, "RXD", "PD0");
                ATMegaX8.addPin(pinAssignments, 3, "TXD", "PD1");
                ATMegaX8.addPin(pinAssignments, 4, "INT0", "PD2");
                ATMegaX8.addPin(pinAssignments, 5, "INT1", "OC2B", "PD3");
                ATMegaX8.addPin(pinAssignments, 6, "T0", "XCK", "PD4");
                ATMegaX8.addPin(pinAssignments, 7, "VCC");
                ATMegaX8.addPin(pinAssignments, 8, "GND.1");
                ATMegaX8.addPin(pinAssignments, 9, "TOSC1", "XTAL1", "PB6");
                ATMegaX8.addPin(pinAssignments, 10, "TOSC2", "XTAL2", "PB7");
                ATMegaX8.addPin(pinAssignments, 11, "T1", "OC0B", "PD5");
                ATMegaX8.addPin(pinAssignments, 12, "AIN0", "OC0A", "PD6");
                ATMegaX8.addPin(pinAssignments, 13, "AIN1", "PD7");
                ATMegaX8.addPin(pinAssignments, 14, "ICP1", "CLK0", "PB0");
                ATMegaX8.addPin(pinAssignments, 15, "OC1A", "PB1");
                ATMegaX8.addPin(pinAssignments, 16, "SS", "OC1B", "PB2");
                ATMegaX8.addPin(pinAssignments, 17, "MOSI", "OC2A", "PB3");
                ATMegaX8.addPin(pinAssignments, 18, "MISO", "PB4");
                ATMegaX8.addPin(pinAssignments, 19, "SCK", "PB5");
                ATMegaX8.addPin(pinAssignments, 20, "AVCC");
                ATMegaX8.addPin(pinAssignments, 21, "AREF");
                ATMegaX8.addPin(pinAssignments, 22, "GND.2");
                ATMegaX8.addPin(pinAssignments, 23, "ADC0", "PC0");
                ATMegaX8.addPin(pinAssignments, 24, "ADC1", "PC1");
                ATMegaX8.addPin(pinAssignments, 25, "ADC2", "PC2");
                ATMegaX8.addPin(pinAssignments, 26, "ADC3", "PC3");
                ATMegaX8.addPin(pinAssignments, 27, "ADC4", "SDA", "PC4");
                ATMegaX8.addPin(pinAssignments, 28, "ADC5", "SLC", "PC5");
                break;
            }
            case 1: 
            case 2: {
                ATMegaX8.addPin(pinAssignments, 1, "INT1", "OC2B", "PD3");
                ATMegaX8.addPin(pinAssignments, 2, "T0", "XCK", "PD4");
                ATMegaX8.addPin(pinAssignments, 3, "GND.1");
                ATMegaX8.addPin(pinAssignments, 4, "VCC.1");
                ATMegaX8.addPin(pinAssignments, 5, "GND.2");
                ATMegaX8.addPin(pinAssignments, 6, "VCC.2");
                ATMegaX8.addPin(pinAssignments, 7, "TOSC1", "XTAL1", "PB6");
                ATMegaX8.addPin(pinAssignments, 8, "TOSC2", "XTAL2", "PB7");
                ATMegaX8.addPin(pinAssignments, 9, "T1", "OC0B", "PD5");
                ATMegaX8.addPin(pinAssignments, 10, "AIN0", "OC0A", "PD6");
                ATMegaX8.addPin(pinAssignments, 11, "AIN1", "PD7");
                ATMegaX8.addPin(pinAssignments, 12, "ICP1", "CLK0", "PB0");
                ATMegaX8.addPin(pinAssignments, 13, "OC1A", "PB1");
                ATMegaX8.addPin(pinAssignments, 14, "SS", "OC1B", "PB2");
                ATMegaX8.addPin(pinAssignments, 15, "MOSI", "OC2A", "PB3");
                ATMegaX8.addPin(pinAssignments, 16, "MISO", "PB4");
                ATMegaX8.addPin(pinAssignments, 17, "SCK", "PB5");
                ATMegaX8.addPin(pinAssignments, 18, "AVCC");
                ATMegaX8.addPin(pinAssignments, 19, "ADC6");
                ATMegaX8.addPin(pinAssignments, 20, "AREF");
                ATMegaX8.addPin(pinAssignments, 21, "GND.3");
                ATMegaX8.addPin(pinAssignments, 22, "ADC7");
                ATMegaX8.addPin(pinAssignments, 23, "ADC0", "PC0");
                ATMegaX8.addPin(pinAssignments, 24, "ADC1", "PC1");
                ATMegaX8.addPin(pinAssignments, 25, "ADC2", "PC2");
                ATMegaX8.addPin(pinAssignments, 26, "ADC3", "PC3");
                ATMegaX8.addPin(pinAssignments, 27, "ADC4", "SDA", "PC4");
                ATMegaX8.addPin(pinAssignments, 28, "ADC5", "SLC", "PC5");
                ATMegaX8.addPin(pinAssignments, 29, "RESET", "PC6");
                ATMegaX8.addPin(pinAssignments, 30, "RXD", "PD0");
                ATMegaX8.addPin(pinAssignments, 31, "TXD", "PD1");
            }
        }
        rl.addIOReg("UDR0", 198);
        rl.addIOReg("UBRR0H", 197);
        rl.addIOReg("UBRR0L", 196);
        rl.addIOReg("UCSR0C", 194);
        rl.addIOReg("UCSR0B", 193);
        rl.addIOReg("UCSR0A", 192);
        rl.addIOReg("TWAMR", 189);
        rl.addIOReg("TWCR", 188);
        rl.addIOReg("TWDR", 187);
        rl.addIOReg("TWAR", 186);
        rl.addIOReg("TWSR", 185);
        rl.addIOReg("TWBR", 184);
        rl.addIOReg("ASSR", 182);
        rl.addIOReg("OCR2B", 180);
        rl.addIOReg("OCR2A", 179);
        rl.addIOReg("TCNT2", 178);
        rl.addIOReg("TCCR2B", 177, "FOC2A,FOC2B,..,WGM2[2],CS2[2:0]");
        rl.addIOReg("TCCR2A", 176, "COM2A[1:0],COM2B[1:0],..,WGM2[1:0]");
        rl.addIOReg("OCR1BH", 139);
        rl.addIOReg("OCR1BL", 138);
        rl.addIOReg("OCR1AH", 137);
        rl.addIOReg("OCR1AL", 136);
        rl.addIOReg("ICR1H", 135);
        rl.addIOReg("ICR1L", 134);
        rl.addIOReg("TCNT1H", 133);
        rl.addIOReg("TCNT1L", 132);
        rl.addIOReg("TCCR1C", 130, "FOC1A,FOC1B");
        rl.addIOReg("TCCR1B", 129, "ICNC1,ICES1,.,WGM1[3:2],CS1[2:0]");
        rl.addIOReg("TCCR1A", 128, "COM1A[1:0],COM1B[1:0],..,WGM1[1:0]");
        rl.addIOReg("DIDR1", 127);
        rl.addIOReg("DIDR0", 126);
        rl.addIOReg("ADMUX", 124);
        rl.addIOReg("ADCSRB", 123);
        rl.addIOReg("ADCSRA", 122);
        rl.addIOReg("ADCH", 121);
        rl.addIOReg("ADCL", 120);
        rl.addIOReg("TIMSK2", 112, ".....,OCIE2B,OCIE2A,TOIE2");
        rl.addIOReg("TIMSK1", 111, "..,ICIE1,..,OCIE1B,OCIE1A,TOIE1");
        rl.addIOReg("TIMSK0", 110, "..,OCIE0B,OCIE0A,TOIE0");
        rl.addIOReg("PCMSK2", 109);
        rl.addIOReg("PCMSK1", 108);
        rl.addIOReg("PCMSK0", 107);
        rl.addIOReg("EICRA", 105);
        rl.addIOReg("PCICR", 104);
        rl.addIOReg("OSCCAL", 102);
        rl.addIOReg("PRR", 100);
        rl.addIOReg("CLKPR", 97);
        rl.addIOReg("WDTCSR", 96);
        rl.addIOReg("SREG", 63);
        rl.addIOReg("SPH", 62);
        rl.addIOReg("SPL", 61);
        rl.addIOReg("SPMCSR", 55);
        rl.addIOReg("MCUCR", 53);
        rl.addIOReg("MCUCSR", 52);
        rl.addIOReg("SMCR", 51);
        rl.addIOReg("ACSR", 48);
        rl.addIOReg("SPDR", 46);
        rl.addIOReg("SPSR", 45);
        rl.addIOReg("SPCR", 44);
        rl.addIOReg("GPIOR2", 43);
        rl.addIOReg("GPIOR1", 42);
        rl.addIOReg("OCR0B", 40);
        rl.addIOReg("OCR0A", 39);
        rl.addIOReg("TCNT0", 38, "FOC0A,FOC0B,..,WGM0[2],CS0[2:0]");
        rl.addIOReg("TCCR0B", 37, "COM0A[1:0],COM0B[1:0],..,WGM0[1:0]");
        rl.addIOReg("TCCR0A", 36);
        rl.addIOReg("GTCCR", 35);
        rl.addIOReg("EEARH", 34);
        rl.addIOReg("EEARL", 33);
        rl.addIOReg("EEDR", 32);
        rl.addIOReg("EECR", 31);
        rl.addIOReg("GPIOR0", 30);
        rl.addIOReg("EIMSK", 29);
        rl.addIOReg("EIFR", 28);
        rl.addIOReg("PCIFR", 27);
        rl.addIOReg("TIFR2", 23, ".....,OCF2B,OCF2A,TOV2");
        rl.addIOReg("TIFR1", 22, "..,ICF1,..,OCF1B,OCF1A,TOV1");
        rl.addIOReg("TIFR0", 21, ".....,OCF0B,OCF0A,TOV0");
        rl.addIOReg("PORTD", 11);
        rl.addIOReg("DDRD", 10);
        rl.addIOReg("PIND", 9);
        rl.addIOReg("PORTC", 8);
        rl.addIOReg("DDRC", 7);
        rl.addIOReg("PINC", 6);
        rl.addIOReg("PORTB", 5);
        rl.addIOReg("DDRB", 4);
        rl.addIOReg("PINB", 3);
        ATMegaX8.addInterrupt(interruptAssignments, "RESET", 1);
        ATMegaX8.addInterrupt(interruptAssignments, "INT0", 2);
        ATMegaX8.addInterrupt(interruptAssignments, "INT1", 3);
        ATMegaX8.addInterrupt(interruptAssignments, "PCINT0", 4);
        ATMegaX8.addInterrupt(interruptAssignments, "PCINT1", 5);
        ATMegaX8.addInterrupt(interruptAssignments, "PCINT2", 6);
        ATMegaX8.addInterrupt(interruptAssignments, "WDT", 7);
        ATMegaX8.addInterrupt(interruptAssignments, "TIMER2 COMPA", 8);
        ATMegaX8.addInterrupt(interruptAssignments, "TIMER2 COMPB", 9);
        ATMegaX8.addInterrupt(interruptAssignments, "TIMER2 OVF", 10);
        ATMegaX8.addInterrupt(interruptAssignments, "TIMER1 CAPT", 11);
        ATMegaX8.addInterrupt(interruptAssignments, "TIMER1 COMPA", 12);
        ATMegaX8.addInterrupt(interruptAssignments, "TIMER1 COMPB", 13);
        ATMegaX8.addInterrupt(interruptAssignments, "TIMER1 OVF", 14);
        ATMegaX8.addInterrupt(interruptAssignments, "TIMER0 COMPA", 15);
        ATMegaX8.addInterrupt(interruptAssignments, "TIMER0 COMPB", 16);
        ATMegaX8.addInterrupt(interruptAssignments, "TIMER0 OVF", 17);
        ATMegaX8.addInterrupt(interruptAssignments, "SPI, STC", 18);
        ATMegaX8.addInterrupt(interruptAssignments, "USART0, RX", 19);
        ATMegaX8.addInterrupt(interruptAssignments, "USART0, UDRE", 20);
        ATMegaX8.addInterrupt(interruptAssignments, "USART0, TX", 21);
        ATMegaX8.addInterrupt(interruptAssignments, "ADC", 22);
        ATMegaX8.addInterrupt(interruptAssignments, "EE READY", 23);
        MCUCR_sm_perm = new int[]{2, 4, 3};
    }
}

