/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.mcu;

import avrora.sim.ActiveRegister;
import avrora.sim.InterruptTable;
import avrora.sim.RW16Register;
import avrora.sim.RWRegister;
import avrora.sim.Simulator;
import avrora.sim.clock.Clock;
import avrora.sim.mcu.AtmelInternalDevice;
import avrora.sim.mcu.AtmelMicrocontroller;
import avrora.sim.mcu.DefaultMCU;
import avrora.sim.mcu.RegisterSet;
import cck.util.Util;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class ATMegaTimer
extends AtmelInternalDevice {
    Mode mode;
    final Map comparators = new HashMap();
    boolean timerEnabled;
    boolean countUp;
    long period;
    boolean compareMatchBlocked;
    protected final Clock externalClock;
    Clock timerClock;
    int timerNumber;
    final RegisterSet.Field TOIEn;
    final FlagField TOVn;
    final RegisterSet.Field WGMn;
    final RegisterSet.Field CSn;
    private final int[] periods;
    protected final RWRegister tempHighReg = new RWRegister();

    protected ATMegaTimer(int n, AtmelMicrocontroller m, int[] p, String ovfName) {
        super("Timer" + n, m);
        this.timerNumber = n;
        this.periods = p;
        RegisterSet rset = m.getRegisterSet();
        this.TOIEn = rset.getField("TOIE" + n);
        int overflowInterrupt = m.properties.getInterrupt(ovfName);
        this.TOVn = new FlagField(this.interpreter.getInterruptTable(), true, overflowInterrupt);
        rset.installField("TOV" + n, this.TOVn);
        this.WGMn = rset.installField("WGM" + n, this.newWGMField());
        this.CSn = rset.installField("CS" + n, this.newPeriodField());
        this.externalClock = m.getClock("external");
        this.timerClock = this.mainClock;
    }

    private RegisterSet.Field newPeriodField() {
        return new RegisterSet.Field(){

            public void update() {
                ATMegaTimer.this.resetPeriod(ATMegaTimer.this.periods[this.value]);
            }
        };
    }

    private RegisterSet.Field newWGMField() {
        return new RegisterSet.Field(){

            public void update() {
                ATMegaTimer.this.resetMode(this.value);
            }
        };
    }

    protected void addComparator(String name, Comparator comparator) {
        this.comparators.put(name, comparator);
    }

    protected Comparator getComparator(String name) {
        return (Comparator)this.comparators.get(name);
    }

    private void resetPeriod(int nPeriod) {
        if (nPeriod == 0) {
            if (this.timerEnabled) {
                if (this.devicePrinter.enabled) {
                    this.devicePrinter.println(this.name + " disabled");
                }
                this.timerClock.removeEvent(this.mode);
                this.timerEnabled = false;
            }
            return;
        }
        if (this.timerEnabled) {
            this.timerClock.removeEvent(this.mode);
        }
        if (this.devicePrinter.enabled) {
            this.devicePrinter.println(this.name + " enabled: period = " + nPeriod + " mode = " + this.WGMn.value);
        }
        this.period = nPeriod;
        this.timerEnabled = true;
        this.timerClock.insertEvent(this.mode, this.period);
    }

    public abstract void resetMode(int var1);

    public abstract int getCounter();

    public abstract void setCounter(int var1);

    public abstract String getCounterName();

    protected abstract int getMax();

    protected void signalOverflow() {
        if (this.devicePrinter.enabled) {
            this.devicePrinter.println(this.name + ".overFlow (interrupts enabled: " + this.TOIEn.value + ')');
        }
        this.TOVn.flag();
    }

    protected class OCRnxHighRegister
    extends HighRegister {
        final RW16Register reg;

        OCRnxHighRegister(RW16Register r) {
            this.reg = r;
        }

        public byte read() {
            return (byte)(this.reg.read16() >> 8);
        }
    }

    protected class HighRegister
    implements ActiveRegister {
        protected HighRegister() {
        }

        public void write(byte val) {
            ATMegaTimer.this.tempHighReg.write(val);
        }

        public byte read() {
            return ATMegaTimer.this.tempHighReg.read();
        }
    }

    protected class LowRegister
    implements ActiveRegister {
        final RW16Register reg;

        LowRegister(RW16Register r) {
            this.reg = r;
        }

        public void write(byte val) {
            this.reg.write((ATMegaTimer.this.tempHighReg.read() << 8) + val);
        }

        public byte read() {
            ATMegaTimer.this.tempHighReg.write((byte)(this.reg.read16() >> 8));
            return (byte)this.reg.read16();
        }
    }

    protected class BufferedRegister
    extends RW16Register
    implements TopValue,
    ActiveRegister {
        int value;
        private final ActiveRegister reg8;
        private final RW16Register reg16;

        protected BufferedRegister(ActiveRegister r) {
            this.reg8 = r;
            this.reg16 = null;
        }

        protected BufferedRegister(RW16Register r) {
            this.reg16 = r;
            this.reg8 = null;
        }

        public void write(byte val) {
            this.value = val;
            ATMegaTimer.this.mode.registerWritten(this);
        }

        public void write(int val) {
            this.value = val;
            ATMegaTimer.this.mode.registerWritten(this);
        }

        public int readBuffer() {
            return super.read16();
        }

        public byte read() {
            return (byte)this.read16();
        }

        public int read16() {
            return null != this.reg8 ? this.reg8.read() : this.reg16.read16();
        }

        public int mask() {
            return 65535;
        }

        public void flush() {
            if (null != this.reg8) {
                this.reg8.write((byte)this.value);
            } else {
                this.reg16.write(this.value);
            }
        }
    }

    protected class TCNTnRegister
    implements ActiveRegister {
        public final String name;
        private final ActiveRegister register;

        protected TCNTnRegister(String n, ActiveRegister r) {
            this.name = n;
            this.register = r;
        }

        public void write(byte val) {
            this.register.write(val);
            ATMegaTimer.this.compareMatchBlocked = true;
        }

        public byte read() {
            return this.register.read();
        }
    }

    abstract class InputComparator
    extends Comparator {
        InputComparator(String u, RegisterSet rset, int interruptNumber, DefaultMCU.Pin p) {
            super("IC", u, rset, interruptNumber, p);
        }

        protected void operate() {
        }
    }

    abstract class OutputComparator
    extends Comparator {
        final RegisterSet.Field pinmode;
        final RegisterSet.Field force;

        OutputComparator(String u, RegisterSet rset, int interruptNumber, DefaultMCU.Pin p) {
            super("OC", u, rset, interruptNumber, p);
            this.pinmode = rset.getField("COM" + ATMegaTimer.this.timerNumber + this.unit);
            this.force = rset.installField("FOC" + ATMegaTimer.this.timerNumber + this.unit, new RegisterSet.Field(){

                public void update() {
                    if (1 == this.value) {
                        OutputComparator.this.operate();
                    }
                }
            });
        }

        protected void operate() {
            if (null == this.pin) {
                return;
            }
            switch (this.pinmode.value) {
                case 1: {
                    this.pin.write(!this.pin.read());
                    break;
                }
                case 2: {
                    this.pin.write(false);
                    break;
                }
                case 3: {
                    this.pin.write(true);
                }
            }
        }
    }

    abstract class Comparator {
        public static final String _ = "";
        public static final String A = "A";
        public static final String B = "B";
        public static final String C = "C";
        public static final String I = "I";
        final String type;
        final String unit;
        final DefaultMCU.Pin pin;
        final FlagField flag;

        Comparator(String t, String u, RegisterSet rset, int interruptNumber, DefaultMCU.Pin p) {
            this.type = t;
            this.unit = u;
            this.pin = p;
            InterruptTable it = ATMegaTimer.this.interpreter.getInterruptTable();
            this.flag = new FlagField(it, true, interruptNumber);
            rset.installField(this.type + "F" + ATMegaTimer.this.timerNumber + this.unit, this.flag);
        }

        public String toString() {
            return this.type + "R" + ATMegaTimer.this.timerNumber + this.unit;
        }

        void compare(int count) {
            if (this.read() == count) {
                this.operate();
                this.flag.flag();
            }
        }

        protected abstract void operate();

        abstract int read();

        abstract int readBuffer();
    }

    static class FixedTop
    implements TopValue {
        public static final FixedTop FF = new FixedTop(255);
        public static final FixedTop _1FF = new FixedTop(511);
        public static final FixedTop _3FF = new FixedTop(1023);
        public static final FixedTop FFFF = new FixedTop(65535);
        final int top;

        protected FixedTop(int t) {
            this.top = t;
        }

        public int read16() {
            return this.top;
        }

        public int mask() {
            return this.top;
        }

        public void flush() {
            throw Util.failure("Fixed top value flushed");
        }
    }

    protected class Mode
    implements Simulator.Event {
        final TopValue top;
        final FlagField flag;
        final Strategy strategy;

        protected Mode(Class sc, RegisterSet.Field f, ActiveRegister t) {
            this(sc, f, (TopValue)((Object)t));
        }

        protected Mode(Class sc, RegisterSet.Field f, TopValue t) {
            if (NORMAL.class == sc) {
                this.strategy = new NORMAL();
            } else if (CTC.class == sc) {
                this.strategy = new CTC();
            } else if (PWM.class == sc) {
                this.strategy = new PWM();
            } else if (FC_PWM.class == sc) {
                this.strategy = new FC_PWM();
            } else if (FAST_PWM.class == sc) {
                this.strategy = new FAST_PWM();
            } else {
                throw new Error("Unknown Strategy class " + sc);
            }
            this.flag = (FlagField)f;
            this.top = t;
        }

        protected int getTop() {
            return this.top.read16();
        }

        protected void signalTop() {
            if (null != this.flag) {
                this.flag.flag();
            }
        }

        protected void updateTop() {
            this.top.flush();
        }

        public void fire() {
            Iterator i;
            int value = ATMegaTimer.this.getCounter();
            if (ATMegaTimer.this.devicePrinter.enabled) {
                ATMegaTimer.this.devicePrinter.println(ATMegaTimer.this.name + " [" + ATMegaTimer.this.getCounterName() + " = " + value);
                i = ATMegaTimer.this.comparators.values().iterator();
                Comparator c = (Comparator)i.next();
                while (c != null) {
                    ATMegaTimer.this.devicePrinter.println(", " + c + "(actual) = " + c.read() + ", " + c + "(buffer) = " + c.readBuffer() + ']');
                    c = (Comparator)i.next();
                }
            }
            value = this.strategy.nextValue(value);
            if (!ATMegaTimer.this.compareMatchBlocked) {
                i = ATMegaTimer.this.comparators.values().iterator();
                while (i.hasNext()) {
                    ((Comparator)i.next()).compare(value);
                }
            }
            ATMegaTimer.this.setCounter(value);
            ATMegaTimer.this.compareMatchBlocked = false;
            if (ATMegaTimer.this.period != 0L) {
                ATMegaTimer.this.timerClock.insertEvent(this, ATMegaTimer.this.period);
            }
        }

        protected void registerWritten(BufferedRegister reg) {
            this.strategy.registerWritten(reg);
        }

        protected class FC_PWM
        extends Strategy {
            protected FC_PWM() {
            }

            protected int nextValue(int count) {
                count = ATMegaTimer.this.countUp ? ++count : --count;
                if (count == Mode.this.getTop()) {
                    ATMegaTimer.this.countUp = false;
                    Mode.this.signalTop();
                }
                if (count == 0) {
                    ATMegaTimer.this.countUp = true;
                    ATMegaTimer.this.signalOverflow();
                    Mode.this.updateTop();
                }
                return count;
            }

            protected void registerWritten(BufferedRegister reg) {
            }
        }

        protected class PWM
        extends Strategy {
            protected PWM() {
            }

            protected int nextValue(int count) {
                count = ATMegaTimer.this.countUp ? ++count : --count;
                if (count == Mode.this.getTop()) {
                    ATMegaTimer.this.countUp = false;
                    Mode.this.signalTop();
                    Mode.this.updateTop();
                }
                if (count == 0) {
                    ATMegaTimer.this.countUp = true;
                    ATMegaTimer.this.signalOverflow();
                }
                return count;
            }

            protected void registerWritten(BufferedRegister reg) {
                reg.value &= Mode.this.top.mask();
            }
        }

        protected class FAST_PWM
        extends Strategy {
            boolean zero;

            protected FAST_PWM() {
                this.zero = false;
            }

            protected int nextValue(int count) {
                ++count;
                if (this.zero) {
                    this.zero = false;
                    count = 0;
                    Mode.this.updateTop();
                    ATMegaTimer.this.signalOverflow();
                }
                if (Mode.this.getTop() == count) {
                    this.zero = true;
                    Mode.this.signalTop();
                }
                return count;
            }

            protected void registerWritten(BufferedRegister reg) {
                reg.value &= Mode.this.top.mask();
            }
        }

        protected class CTC
        extends Strategy {
            protected CTC() {
            }

            protected int nextValue(int count) {
                if (Mode.this.getTop() == ++count) {
                    Mode.this.signalTop();
                    count = 0;
                }
                if (ATMegaTimer.this.getMax() + 1 == count) {
                    ATMegaTimer.this.signalOverflow();
                    count = 0;
                }
                return count;
            }

            protected void registerWritten(BufferedRegister reg) {
                reg.flush();
            }
        }

        protected class NORMAL
        extends Strategy {
            protected NORMAL() {
            }

            protected int nextValue(int count) {
                if (ATMegaTimer.this.getMax() + 1 == ++count) {
                    ATMegaTimer.this.signalOverflow();
                    count = 0;
                }
                return count;
            }

            protected void registerWritten(BufferedRegister reg) {
                reg.flush();
            }
        }

        protected abstract class Strategy {
            protected Strategy() {
            }

            protected abstract int nextValue(int var1);

            protected abstract void registerWritten(BufferedRegister var1);
        }
    }

    public class FlagField
    extends RegisterSet.Field
    implements InterruptTable.Notification {
        InterruptTable interrupts;
        int inum;
        boolean autoclear;

        public FlagField(InterruptTable it, boolean auto, int in2) {
            this.interrupts = it;
            this.autoclear = auto;
            this.inum = in2;
            this.interrupts.registerInternalNotification(this, this.inum);
        }

        public void update() {
            if (0 != this.value) {
                this.interrupts.post(this.inum);
            } else {
                this.interrupts.unpost(this.inum);
            }
        }

        public void flag() {
            this.write(1);
        }

        public void unflag() {
            this.write(0);
        }

        public void force(int inum) {
            this.flag();
        }

        public void invoke(int inum) {
            if (this.autoclear) {
                this.unflag();
            }
        }
    }

    static interface TopValue {
        public int mask();

        public int read16();

        public void flush();
    }
}

