/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.mcu;

import avrora.arch.avr.AVRProperties;
import avrora.sim.ActiveRegister;
import avrora.sim.AtmelInterpreter;
import avrora.sim.FiniteStateMachine;
import avrora.sim.InterruptTable;
import avrora.sim.RWRegister;
import avrora.sim.clock.ClockDomain;
import avrora.sim.mcu.AtmelMicrocontroller;
import avrora.sim.mcu.DefaultMCU;
import cck.util.Arithmetic;

public abstract class ATMegaFamilyNew
extends AtmelMicrocontroller {
    protected FlagRegister EIFR_reg;

    protected ATMegaFamilyNew(ClockDomain cd, AVRProperties p, FiniteStateMachine fsm) {
        super(cd, p, fsm);
    }

    protected void buildPort(char p) {
        this.buildPort(p, 8);
    }

    protected void buildPort(char p, int pins) {
        DefaultMCU.Pin[] portPins = new DefaultMCU.Pin[8];
        for (int bit = 0; bit < pins; ++bit) {
            portPins[bit] = (DefaultMCU.Pin)this.getPin("P" + p + bit);
        }
        this.installIOReg("PORT" + p, new PortRegister(portPins));
        this.installIOReg("DDR" + p, new DirectionRegister(portPins));
        this.installIOReg("PIN" + p, new PinRegister(portPins));
    }

    protected FlagRegister buildInterruptRange(boolean increasing, String maskRegNum, String flagRegNum, int baseVect, int numVects) {
        int bit;
        int[] mapping = new int[8];
        if (increasing) {
            for (bit = 0; bit < numVects; ++bit) {
                mapping[bit] = baseVect + bit;
            }
        } else {
            for (bit = 0; bit < numVects; ++bit) {
                mapping[bit] = baseVect - bit;
            }
        }
        for (int i = numVects; i < mapping.length; ++i) {
            mapping[i] = -1;
        }
        FlagRegister fr = new FlagRegister(this.interpreter, mapping);
        MaskRegister mr = new MaskRegister(this.interpreter, mapping);
        this.installIOReg(maskRegNum, mr);
        this.installIOReg(flagRegNum, fr);
        return fr;
    }

    public FlagRegister getEIFR_reg() {
        return this.EIFR_reg;
    }

    public static class PinRegister
    implements ActiveRegister {
        protected DefaultMCU.Pin[] pins;

        protected PinRegister(DefaultMCU.Pin[] p) {
            this.pins = p;
        }

        public byte read() {
            byte value = 0;
            for (int bit = 0; bit < this.pins.length; ++bit) {
                value = (byte)(value | (this.pinHigh(bit) ? 1 << bit : 0));
            }
            return value;
        }

        private boolean pinHigh(int bit) {
            return this.pins[bit] != null && this.pins[bit].read();
        }

        public void write(byte val) {
        }
    }

    public static class PortRegister
    extends RWRegister {
        protected DefaultMCU.Pin[] pins;

        protected PortRegister(DefaultMCU.Pin[] p) {
            this.pins = p;
        }

        public void write(byte val) {
            for (int bit = 0; bit < this.pins.length; ++bit) {
                if (this.pins[bit] == null) continue;
                this.pins[bit].write(Arithmetic.getBit(val, bit));
            }
            this.value = val;
        }
    }

    public static class DirectionRegister
    extends RWRegister {
        protected DefaultMCU.Pin[] pins;

        protected DirectionRegister(DefaultMCU.Pin[] p) {
            this.pins = p;
        }

        public void write(byte val) {
            for (int bit = 0; bit < this.pins.length; ++bit) {
                if (this.pins[bit] == null) continue;
                this.pins[bit].setOutputDir(Arithmetic.getBit(val, bit));
            }
            this.value = val;
        }
    }

    public static class MaskRegister
    extends RWRegister {
        protected final int[] mapping;
        protected final AtmelInterpreter interpreter;

        public MaskRegister(AtmelInterpreter interp, int[] map) {
            this.mapping = map;
            this.interpreter = interp;
        }

        public void write(byte val) {
            this.value = val;
            for (int cntr = 0; cntr < 8; ++cntr) {
                this.setEnabled(cntr, Arithmetic.getBit(val, cntr));
            }
        }

        void setEnabled(int cntr, boolean e) {
            if (this.mapping[cntr] > 0) {
                this.interpreter.setEnabled(this.mapping[cntr], e);
            }
        }
    }

    public static class FlagRegister
    extends RWRegister {
        protected final int[] mapping;
        protected final AtmelInterpreter interpreter;

        public FlagRegister(AtmelInterpreter interp, int[] map) {
            this.mapping = map;
            this.interpreter = interp;
            InterruptTable it = this.interpreter.getInterruptTable();
            for (int cntr = 0; cntr < 8; ++cntr) {
                if (this.mapping[cntr] <= 0) continue;
                it.registerInternalNotification(new Notification(cntr), this.mapping[cntr]);
            }
        }

        public void write(byte val) {
            this.value = (byte)(this.value & ~val);
            for (int cntr = 0; cntr < 8; ++cntr) {
                if (!Arithmetic.getBit(val, cntr)) continue;
                this.setPosted(cntr, false);
            }
        }

        private void setPosted(int inum, boolean p) {
            if (this.mapping[inum] > 0) {
                this.interpreter.setPosted(this.mapping[inum], p);
            }
        }

        public void flagBit(int bit) {
            this.value = Arithmetic.setBit(this.value, bit);
            this.setPosted(bit, true);
        }

        public void unflagBit(int bit) {
            this.value = Arithmetic.clearBit(this.value, bit);
            this.setPosted(bit, false);
        }

        class Notification
        implements InterruptTable.Notification {
            final int bit;

            Notification(int bit) {
                this.bit = bit;
            }

            public void force(int inum) {
                FlagRegister.this.value = Arithmetic.setBit(FlagRegister.this.value, this.bit, true);
            }

            public void invoke(int inum) {
                FlagRegister.this.value = Arithmetic.setBit(FlagRegister.this.value, this.bit, false);
                FlagRegister.this.interpreter.setPosted(inum, false);
            }
        }
    }

    public static class FlagBit
    implements InterruptTable.Notification {
        final AtmelInterpreter interpreter;
        final boolean autoclear;
        final int inum;
        boolean val;

        public FlagBit(AtmelInterpreter i, boolean auto, int in2) {
            this.interpreter = i;
            this.autoclear = auto;
            this.inum = in2;
            this.interpreter.getInterruptTable().registerInternalNotification(this, this.inum);
        }

        public void flag() {
            this.val = true;
            this.interpreter.setPosted(this.inum, true);
        }

        public void unflag() {
            this.val = false;
            this.interpreter.setPosted(this.inum, false);
        }

        public boolean get() {
            return this.val;
        }

        public void force(int inum) {
            this.val = true;
            this.interpreter.setPosted(inum, true);
        }

        public void invoke(int inum) {
            if (this.autoclear) {
                this.val = false;
                this.interpreter.setPosted(inum, false);
            }
        }
    }
}

