/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.mcu;

import avrora.arch.avr.AVRProperties;
import avrora.sim.ActiveRegister;
import avrora.sim.AtmelInterpreter;
import avrora.sim.FiniteStateMachine;
import avrora.sim.InterruptTable;
import avrora.sim.RWRegister;
import avrora.sim.clock.ClockDomain;
import avrora.sim.mcu.AtmelMicrocontroller;
import avrora.sim.mcu.DefaultMCU;
import avrora.sim.mcu.Timer16Bit;
import avrora.sim.mcu.Timer8Bit;
import avrora.sim.state.BooleanView;
import cck.util.Arithmetic;

public abstract class ATMegaFamily
extends AtmelMicrocontroller {
    protected static final int[] periods0 = new int[]{0, 1, 8, 32, 64, 128, 256, 1024};
    protected static final int[] periods2 = new int[]{0, 1, 8, 64, 256, 1024, 0, 0};
    protected static final int[] periods1 = new int[]{0, 1, 8, 64, 256, 1024};
    protected static final int[] periods3 = new int[]{0, 1, 8, 64, 256, 1024};
    protected FlagRegister EIFR_reg;
    protected FlagRegister TIFR_reg;
    protected MaskRegister TIMSK_reg;
    protected FlagRegister ETIFR_reg;
    protected MaskRegister ETIMSK_reg;

    protected ATMegaFamily(ClockDomain cd, AVRProperties p, FiniteStateMachine fsm) {
        super(cd, p, fsm);
    }

    protected void buildPort(char p) {
        DefaultMCU.Pin[] portPins = new DefaultMCU.Pin[8];
        for (int cntr = 0; cntr < 8; ++cntr) {
            portPins[cntr] = (DefaultMCU.Pin)this.getPin("P" + p + cntr);
        }
        this.installIOReg("PORT" + p, new PortRegister(portPins));
        this.installIOReg("DDR" + p, new DirectionRegister(portPins));
        this.installIOReg("PIN" + p, new PinRegister(portPins));
    }

    protected FlagRegister buildInterruptRange(boolean increasing, String maskRegNum, String flagRegNum, int baseVect, int numVects) {
        int cntr;
        int[] mapping = new int[8];
        if (increasing) {
            for (cntr = 0; cntr < 8; ++cntr) {
                mapping[cntr] = baseVect + cntr;
            }
        } else {
            for (cntr = 0; cntr < 8; ++cntr) {
                mapping[cntr] = baseVect - cntr;
            }
        }
        FlagRegister fr = new FlagRegister(this.interpreter, mapping);
        MaskRegister mr = new MaskRegister(this.interpreter, mapping);
        this.installIOReg(maskRegNum, mr);
        this.installIOReg(flagRegNum, fr);
        return fr;
    }

    public FlagRegister getEIFR_reg() {
        return this.EIFR_reg;
    }

    public static class InterruptFlag
    implements InterruptTable.Notification {
        final AtmelInterpreter interpreter;
        final boolean autoclear;
        final int inum;
        final BooleanView view;

        public InterruptFlag(AtmelInterpreter i, boolean auto, int in2, BooleanView b) {
            this.interpreter = i;
            this.autoclear = auto;
            this.inum = in2;
            this.interpreter.getInterruptTable().registerInternalNotification(this, this.inum);
            this.view = b;
        }

        public void flag(boolean flag) {
            this.view.setValue(flag);
            this.interpreter.setPosted(this.inum, flag);
        }

        public boolean get() {
            return this.view.getValue();
        }

        public void force(int inum) {
            this.view.setValue(true);
            this.interpreter.setPosted(inum, true);
        }

        public void sync() {
            this.interpreter.setPosted(this.inum, this.view.getValue());
        }

        public void invoke(int inum) {
            if (this.autoclear) {
                this.view.setValue(false);
                this.interpreter.setPosted(inum, false);
            }
        }
    }

    protected class Timer3
    extends Timer16Bit {
        protected void initValues() {
            this.OCIEnA = 4;
            this.OCIEnB = 3;
            this.OCIEnC = 1;
            this.TOIEn = 2;
            this.TOVn = 2;
            this.OCFnA = 4;
            this.OCFnB = 3;
            this.OCFnC = 1;
            this.ICFn = 5;
            this.periods = periods3;
        }

        protected Timer3(int compareUnits) {
            super(3, compareUnits, ATMegaFamily.this);
            this.xTIMSK_reg = (MaskRegister)this.microcontroller.getIOReg("ETIMSK");
            this.xTIFR_reg = (FlagRegister)this.microcontroller.getIOReg("ETIFR");
        }
    }

    protected class Timer1
    extends Timer16Bit {
        protected void initValues() {
            this.OCIEnA = 4;
            this.OCIEnB = 3;
            this.OCIEnC = 0;
            this.TOIEn = 2;
            this.TOVn = 2;
            this.OCFnA = 4;
            this.OCFnB = 3;
            this.OCFnC = 0;
            this.ICFn = 5;
            this.periods = periods1;
        }

        protected Timer1(int compareUnits) {
            super(1, compareUnits, ATMegaFamily.this);
            this.xTIFR_reg = ATMegaFamily.this.TIFR_reg;
            this.xTIMSK_reg = ATMegaFamily.this.TIMSK_reg;
        }
    }

    protected class Timer2
    extends Timer8Bit {
        protected Timer2() {
            super(ATMegaFamily.this, 2, 7, 6, 7, 6, periods2);
        }
    }

    protected class Timer0
    extends Timer8Bit {
        protected Timer0() {
            super(ATMegaFamily.this, 0, 1, 0, 1, 0, periods0);
            this.installIOReg("ASSR", new ASSRRegister());
        }

        protected class ASSRRegister
        extends RWRegister {
            static final int AS0 = 3;
            static final int TCN0UB = 2;
            static final int OCR0UB = 1;
            static final int TCR0UB = 0;

            protected ASSRRegister() {
            }

            public void write(byte val) {
                super.write((byte)(0xF & val));
                this.decode(val);
            }

            protected void decode(byte val) {
                Timer0.this.timerClock = Arithmetic.getBit(val, 3) ? Timer0.this.externalClock : Timer0.this.mainClock;
            }
        }
    }

    public static class PinRegister
    implements ActiveRegister {
        protected DefaultMCU.Pin[] pins;

        protected PinRegister(DefaultMCU.Pin[] p) {
            this.pins = p;
        }

        public byte read() {
            int value = 0;
            value |= this.pins[0].read() ? 1 : 0;
            value |= this.pins[1].read() ? 2 : 0;
            value |= this.pins[2].read() ? 4 : 0;
            value |= this.pins[3].read() ? 8 : 0;
            value |= this.pins[4].read() ? 16 : 0;
            value |= this.pins[5].read() ? 32 : 0;
            value |= this.pins[6].read() ? 64 : 0;
            return (byte)(value |= this.pins[7].read() ? 128 : 0);
        }

        public void write(byte val) {
        }
    }

    public static class PortRegister
    extends RWRegister {
        protected DefaultMCU.Pin[] pins;

        protected PortRegister(DefaultMCU.Pin[] p) {
            this.pins = p;
        }

        public void write(byte val) {
            for (int cntr = 0; cntr < 8; ++cntr) {
                this.pins[cntr].write(Arithmetic.getBit(val, cntr));
            }
            this.value = val;
        }
    }

    public static class DirectionRegister
    extends RWRegister {
        protected DefaultMCU.Pin[] pins;

        protected DirectionRegister(DefaultMCU.Pin[] p) {
            this.pins = p;
        }

        public void write(byte val) {
            for (int cntr = 0; cntr < 8; ++cntr) {
                this.pins[cntr].setOutputDir(Arithmetic.getBit(val, cntr));
            }
            this.value = val;
        }
    }

    public static class MaskRegister
    extends RWRegister {
        protected final int[] mapping;
        protected final AtmelInterpreter interpreter;

        public MaskRegister(AtmelInterpreter interp, int[] map) {
            this.mapping = map;
            this.interpreter = interp;
        }

        public void write(byte val) {
            this.value = val;
            for (int cntr = 0; cntr < 8; ++cntr) {
                this.setEnabled(cntr, Arithmetic.getBit(val, cntr));
            }
        }

        void setEnabled(int cntr, boolean e) {
            if (this.mapping[cntr] > 0) {
                this.interpreter.setEnabled(this.mapping[cntr], e);
            }
        }
    }

    public static class FlagRegister
    extends RWRegister {
        protected final int[] mapping;
        protected final AtmelInterpreter interpreter;

        public FlagRegister(AtmelInterpreter interp, int[] map) {
            this.mapping = map;
            this.interpreter = interp;
            InterruptTable it = this.interpreter.getInterruptTable();
            for (int cntr = 0; cntr < 8; ++cntr) {
                if (this.mapping[cntr] <= 0) continue;
                it.registerInternalNotification(new Notification(cntr), this.mapping[cntr]);
            }
        }

        public void write(byte val) {
            this.value = (byte)(this.value & ~val);
            for (int cntr = 0; cntr < 8; ++cntr) {
                if (!Arithmetic.getBit(val, cntr)) continue;
                this.setPosted(cntr, false);
            }
        }

        private void setPosted(int inum, boolean p) {
            if (this.mapping[inum] > 0) {
                this.interpreter.setPosted(this.mapping[inum], p);
            }
        }

        public void flagBit(int bit) {
            this.value = Arithmetic.setBit(this.value, bit);
            this.setPosted(bit, true);
        }

        public void unflagBit(int bit) {
            this.value = Arithmetic.clearBit(this.value, bit);
            this.setPosted(bit, false);
        }

        class Notification
        implements InterruptTable.Notification {
            final int bit;

            Notification(int bit) {
                this.bit = bit;
            }

            public void force(int inum) {
                FlagRegister.this.value = Arithmetic.setBit(FlagRegister.this.value, this.bit, true);
            }

            public void invoke(int inum) {
                FlagRegister.this.value = Arithmetic.setBit(FlagRegister.this.value, this.bit, false);
                FlagRegister.this.interpreter.setPosted(inum, false);
            }
        }
    }

    public static class FlagBit
    implements InterruptTable.Notification {
        final AtmelInterpreter interpreter;
        final boolean autoclear;
        final int inum;
        boolean val;

        public FlagBit(AtmelInterpreter i, boolean auto, int in2) {
            this.interpreter = i;
            this.autoclear = auto;
            this.inum = in2;
            this.interpreter.getInterruptTable().registerInternalNotification(this, this.inum);
        }

        public void flag() {
            this.val = true;
            this.interpreter.setPosted(this.inum, true);
        }

        public void unflag() {
            this.val = false;
            this.interpreter.setPosted(this.inum, false);
        }

        public boolean get() {
            return this.val;
        }

        public void force(int inum) {
            this.val = true;
            this.interpreter.setPosted(inum, true);
        }

        public void invoke(int inum) {
            if (this.autoclear) {
                this.val = false;
                this.interpreter.setPosted(inum, false);
            }
        }
    }
}

