/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.mcu;

import avrora.arch.avr.AVRProperties;
import avrora.sim.FiniteStateMachine;
import avrora.sim.RW16Register;
import avrora.sim.RWRegister;
import avrora.sim.clock.ClockDomain;
import avrora.sim.mcu.ATMegaFamilyNew;
import avrora.sim.mcu.ATMegaTimer;
import avrora.sim.mcu.AtmelMicrocontroller;
import avrora.sim.mcu.DefaultMCU;
import avrora.sim.mcu.RegisterSet;
import cck.util.Arithmetic;

public abstract class ATMegaClassic
extends ATMegaFamilyNew {
    protected static final int[] periods0 = new int[]{0, 1, 8, 32, 64, 128, 256, 1024};
    protected static final int[] periods2 = new int[]{0, 1, 8, 64, 256, 1024};
    protected static final int[] periods1 = new int[]{0, 1, 8, 64, 256, 1024};
    protected static final String[] cf1Names = new String[]{"TIMER1 CAPT", "TIMER1 COMPA", "TIMER1 COMPB", "TIMER1 COMPC"};
    protected static final int[] periods3 = new int[]{0, 1, 8, 64, 256, 1024};
    protected static final String[] cf3Names = new String[]{"TIMER3 CAPT", "TIMER3 COMPA", "TIMER3 COMPB", "TIMER3 COMPC"};

    protected ATMegaClassic(ClockDomain cd, AVRProperties p, FiniteStateMachine fsm) {
        super(cd, p, fsm);
    }

    protected class Timer3
    extends Timer16Bit {
        protected Timer3(int compareUnits) {
            super(3, ATMegaClassic.this, periods3, "TIMER3 OVF", cf3Names);
        }
    }

    protected class Timer1
    extends Timer16Bit {
        protected Timer1(int compareUnits) {
            super(1, ATMegaClassic.this, periods1, "TIMER1 OVF", cf1Names);
        }
    }

    protected class Timer2
    extends Timer8Bit {
        protected Timer2() {
            super(2, ATMegaClassic.this, periods2, "TIMER2 OVF", "TIMER2 COMP");
        }
    }

    protected class Timer0
    extends Timer8Bit {
        protected Timer0() {
            super(0, ATMegaClassic.this, periods0, "TIMER0 OVF", "TIMER0 COMP");
            this.installIOReg("ASSR", new ASSRRegister());
        }

        protected class ASSRRegister
        extends RWRegister {
            static final int AS0 = 3;
            static final int TCN0UB = 2;
            static final int OCR0UB = 1;
            static final int TCR0UB = 0;

            protected ASSRRegister() {
            }

            public void write(byte val) {
                super.write((byte)(0xF & val));
                this.decode(val);
            }

            protected void decode(byte val) {
                Timer0.this.timerClock = Arithmetic.getBit(val, 3) ? Timer0.this.externalClock : Timer0.this.mainClock;
            }
        }
    }

    protected abstract class Timer16Bit
    extends ATMegaTimer {
        final RW16Register TCNTn_reg;
        final ATMegaTimer.HighRegister TCNTnH_reg;
        final ATMegaTimer.TCNTnRegister TCNTnL_reg;
        final ATMegaTimer.Mode[] modes;

        protected Timer16Bit(int n, AtmelMicrocontroller m, int[] periods, String ovfName, String[] cfn) {
            super(n, m, periods, ovfName);
            this.TCNTn_reg = new RW16Register();
            this.TCNTnH_reg = (ATMegaTimer.HighRegister)m.installIOReg("TCNT" + n + "H", new ATMegaTimer.HighRegister(this));
            this.TCNTnL_reg = new ATMegaTimer.TCNTnRegister(this, "TCNT" + n + "L", new ATMegaTimer.LowRegister(this, this.TCNTn_reg));
            m.installIOReg("TCNT" + n + "L", this.TCNTnL_reg);
            this.addComparator("I", new InputCompareUnit(n, m, "", m.properties.getInterrupt(cfn[0]), (DefaultMCU.Pin)m.getPin("IC" + this.timerNumber)));
            this.addComparator("A", new OutputCompareUnit(n, m, "A", m.properties.getInterrupt(cfn[1]), (DefaultMCU.Pin)m.getPin("OC" + this.timerNumber + "A")));
            this.addComparator("B", new OutputCompareUnit(n, m, "B", m.properties.getInterrupt(cfn[2]), (DefaultMCU.Pin)m.getPin("OC" + this.timerNumber + "B")));
            this.addComparator("C", new OutputCompareUnit(n, m, "C", m.properties.getInterrupt(cfn[3]), (DefaultMCU.Pin)m.getPin("OC" + this.timerNumber + "C")));
            String ocfn = "OCF" + n + "A";
            String icfn = "ICF" + n;
            this.modes = new ATMegaTimer.Mode[]{new ATMegaTimer.Mode((ATMegaTimer)this, ATMegaTimer.Mode.NORMAL.class, null, ATMegaTimer.FixedTop.FFFF), new ATMegaTimer.Mode((ATMegaTimer)this, ATMegaTimer.Mode.PWM.class, null, ATMegaTimer.FixedTop.FF), new ATMegaTimer.Mode((ATMegaTimer)this, ATMegaTimer.Mode.PWM.class, null, ATMegaTimer.FixedTop._1FF), new ATMegaTimer.Mode((ATMegaTimer)this, ATMegaTimer.Mode.PWM.class, null, ATMegaTimer.FixedTop._3FF), new ATMegaTimer.Mode((ATMegaTimer)this, ATMegaTimer.Mode.CTC.class, this.getField(m, ocfn), this.gro("A")), new ATMegaTimer.Mode((ATMegaTimer)this, ATMegaTimer.Mode.FAST_PWM.class, null, ATMegaTimer.FixedTop.FF), new ATMegaTimer.Mode((ATMegaTimer)this, ATMegaTimer.Mode.FAST_PWM.class, null, ATMegaTimer.FixedTop._1FF), new ATMegaTimer.Mode((ATMegaTimer)this, ATMegaTimer.Mode.FAST_PWM.class, null, ATMegaTimer.FixedTop._3FF), new ATMegaTimer.Mode((ATMegaTimer)this, ATMegaTimer.Mode.FC_PWM.class, this.getField(m, icfn), this.gri("I")), new ATMegaTimer.Mode((ATMegaTimer)this, ATMegaTimer.Mode.FC_PWM.class, this.getField(m, ocfn), this.gro("A")), new ATMegaTimer.Mode((ATMegaTimer)this, ATMegaTimer.Mode.PWM.class, this.getField(m, icfn), this.gri("I")), new ATMegaTimer.Mode((ATMegaTimer)this, ATMegaTimer.Mode.PWM.class, this.getField(m, ocfn), this.gro("A")), new ATMegaTimer.Mode((ATMegaTimer)this, ATMegaTimer.Mode.CTC.class, this.getField(m, icfn), this.gri("I")), null, new ATMegaTimer.Mode((ATMegaTimer)this, ATMegaTimer.Mode.FAST_PWM.class, this.getField(m, icfn), this.gri("I")), new ATMegaTimer.Mode((ATMegaTimer)this, ATMegaTimer.Mode.FAST_PWM.class, this.getField(m, ocfn), this.gro("A"))};
            this.resetMode(0);
        }

        private RegisterSet.Field getField(AtmelMicrocontroller m, String name) {
            return m.getRegisterSet().getField(name);
        }

        private ATMegaTimer.TopValue gro(String n) {
            return ((OutputCompareUnit)this.getComparator((String)n)).OCRnX_reg;
        }

        private ATMegaTimer.TopValue gri(String n) {
            return ((InputCompareUnit)this.getComparator((String)n)).OCRnX_reg;
        }

        public int getCounter() {
            return this.TCNTn_reg.read16();
        }

        public void setCounter(int count) {
            this.TCNTn_reg.write(count);
        }

        public String getCounterName() {
            return "TCNT" + this.timerNumber;
        }

        public int getMax() {
            return 65535;
        }

        public void resetMode(int WGMn) {
            this.mode = this.modes[WGMn];
        }

        class InputCompareUnit
        extends ATMegaTimer.InputComparator {
            final ATMegaTimer.HighRegister OCRnXH_reg;
            final ATMegaTimer.LowRegister OCRnXL_reg;
            final ATMegaTimer.BufferedRegister OCRnX_reg;

            InputCompareUnit(int timerNumber, AtmelMicrocontroller m, String unit, int interruptNumber, DefaultMCU.Pin pin) {
                super(Timer16Bit.this, unit, m.getRegisterSet(), interruptNumber, pin);
                String name = "ICR" + timerNumber + unit;
                this.OCRnX_reg = new ATMegaTimer.BufferedRegister((ATMegaTimer)Timer16Bit.this, new RW16Register());
                this.OCRnXH_reg = (ATMegaTimer.HighRegister)m.installIOReg(name + "H", new ATMegaTimer.OCRnxHighRegister(Timer16Bit.this, this.OCRnX_reg));
                this.OCRnXL_reg = (ATMegaTimer.LowRegister)m.installIOReg(name + "L", new ATMegaTimer.LowRegister(Timer16Bit.this, this.OCRnX_reg));
            }

            int read() {
                return this.OCRnX_reg.read16();
            }

            int readBuffer() {
                return this.OCRnX_reg.readBuffer();
            }
        }

        class OutputCompareUnit
        extends ATMegaTimer.OutputComparator {
            final ATMegaTimer.HighRegister OCRnXH_reg;
            final ATMegaTimer.LowRegister OCRnXL_reg;
            final ATMegaTimer.BufferedRegister OCRnX_reg;

            OutputCompareUnit(int timerNumber, AtmelMicrocontroller m, String unit, int interruptNumber, DefaultMCU.Pin pin) {
                super(Timer16Bit.this, unit, m.getRegisterSet(), interruptNumber, pin);
                String name = "OCR" + timerNumber + unit;
                this.OCRnX_reg = new ATMegaTimer.BufferedRegister((ATMegaTimer)Timer16Bit.this, new RW16Register());
                this.OCRnXH_reg = (ATMegaTimer.HighRegister)m.installIOReg(name + "H", new ATMegaTimer.OCRnxHighRegister(Timer16Bit.this, this.OCRnX_reg));
                this.OCRnXL_reg = (ATMegaTimer.LowRegister)m.installIOReg(name + "L", new ATMegaTimer.LowRegister(Timer16Bit.this, this.OCRnX_reg));
            }

            int read() {
                return this.OCRnX_reg.read16();
            }

            int readBuffer() {
                return this.OCRnX_reg.readBuffer();
            }
        }
    }

    protected abstract class Timer8Bit
    extends ATMegaTimer {
        final ATMegaTimer.TCNTnRegister TCNTn_reg;
        final ATMegaTimer.Mode[] modes;

        protected Timer8Bit(int n, AtmelMicrocontroller m, int[] periods, String ovfName, String acfName) {
            super(n, m, periods, ovfName);
            this.TCNTn_reg = new ATMegaTimer.TCNTnRegister(this, "TCNT" + n, m.getIOReg("TCNT" + n));
            m.installIOReg(this.TCNTn_reg.name, this.TCNTn_reg);
            DefaultMCU.Pin pin = (DefaultMCU.Pin)m.getPin("OC" + this.timerNumber);
            int interrupt = m.properties.getInterrupt(acfName);
            this.addComparator("", new OutputCompareUnit(n, m, "", interrupt, pin));
            String ocfn = "OCF" + n;
            String ocrn = "OCR" + n;
            this.modes = new ATMegaTimer.Mode[]{new ATMegaTimer.Mode((ATMegaTimer)this, ATMegaTimer.Mode.NORMAL.class, null, ATMegaTimer.FixedTop.FF), new ATMegaTimer.Mode((ATMegaTimer)this, ATMegaTimer.Mode.FC_PWM.class, null, ATMegaTimer.FixedTop.FF), new ATMegaTimer.Mode((ATMegaTimer)this, ATMegaTimer.Mode.CTC.class, m.getRegisterSet().getField(ocfn), m.getIOReg(ocrn)), new ATMegaTimer.Mode((ATMegaTimer)this, ATMegaTimer.Mode.FAST_PWM.class, null, ATMegaTimer.FixedTop.FF)};
            this.resetMode(0);
        }

        public int getCounter() {
            return this.TCNTn_reg.read();
        }

        public void setCounter(int count) {
            this.TCNTn_reg.write((byte)count);
        }

        public String getCounterName() {
            return "TCNT" + this.timerNumber;
        }

        public int getMax() {
            return 255;
        }

        public void resetMode(int WGMn) {
            this.mode = this.modes[WGMn];
        }

        class OutputCompareUnit
        extends ATMegaTimer.OutputComparator {
            final ATMegaTimer.BufferedRegister OCRn_reg;

            OutputCompareUnit(int timerNumber, AtmelMicrocontroller m, String unit, int interruptNumber, DefaultMCU.Pin pin) {
                super(Timer8Bit.this, unit, m.getRegisterSet(), interruptNumber, pin);
                String name = "OCR" + timerNumber + unit;
                this.OCRn_reg = new ATMegaTimer.BufferedRegister((ATMegaTimer)Timer8Bit.this, m.getIOReg(name));
                m.installIOReg(name, this.OCRn_reg);
            }

            int read() {
                return this.OCRn_reg.read16();
            }

            int readBuffer() {
                return this.OCRn_reg.readBuffer();
            }
        }
    }
}

