/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.mcu;

import avrora.arch.avr.AVRProperties;
import avrora.arch.legacy.LegacyInterpreter;
import avrora.core.Program;
import avrora.sim.ActiveRegister;
import avrora.sim.AtmelInterpreter;
import avrora.sim.FiniteStateMachine;
import avrora.sim.Simulator;
import avrora.sim.clock.Clock;
import avrora.sim.clock.ClockDomain;
import avrora.sim.mcu.ADC;
import avrora.sim.mcu.ATMegaFamilyNew;
import avrora.sim.mcu.AtmelMicrocontroller;
import avrora.sim.mcu.DefaultMCU;
import avrora.sim.mcu.EEPROM;
import avrora.sim.mcu.Microcontroller;
import avrora.sim.mcu.MicrocontrollerFactory;
import avrora.sim.mcu.RegisterLayout;
import avrora.sim.mcu.ReprogrammableCodeSegment;
import avrora.sim.mcu.SPI;
import avrora.sim.mcu.USART;
import cck.util.Arithmetic;
import java.util.HashMap;

public class ATMega169
extends ATMegaFamilyNew {
    public static final int _1kb = 1024;
    public static final int _512b = 512;
    public static final int ATMEGA169_IOREG_SIZE = 224;
    public static final int ATMEGA169_SRAM_SIZE = 1024;
    public static final int ATMEGA169_FLASH_SIZE = 16384;
    public static final int ATMEGA169_EEPROM_SIZE = 512;
    public static final int ATMEGA169_NUM_PINS = 64;
    public static final int ATMEGA169_NUM_INTS = 22;
    public static final int MODE_IDLE = 1;
    public static final int MODE_ADCNRED = 2;
    public static final int MODE_POWERDOWN = 3;
    public static final int MODE_POWERSAVE = 4;
    public static final int MODE_RESERVED1 = 5;
    public static final int MODE_RESERVED2 = 6;
    public static final int MODE_STANDBY = 7;
    public static final int MODE_RESERVED3 = 8;
    protected static final String[] idleModeNames = new String[]{"Active", "Idle", "ADC Noise Reduction", "Power Down", "Power Save", "RESERVED 1", "RESERVED 2", "Standby", "RESERVED 3"};
    protected static final int[] wakeupTimes = new int[]{0, 0, 0, 1000, 1000, 0, 0, 1000, 6};
    protected final ActiveRegister MCUCR_reg;
    private static final int[][] transitionTimeMatrix = FiniteStateMachine.buildBimodalTTM(idleModeNames.length, 0, wakeupTimes, new int[wakeupTimes.length]);
    public static final AVRProperties props;
    protected ATMegaFamilyNew.FlagRegister TIFR0_reg;
    protected ATMegaFamilyNew.MaskRegister TIMSK0_reg;
    protected ATMegaFamilyNew.FlagRegister TIFR1_reg;
    protected ATMegaFamilyNew.MaskRegister TIMSK1_reg;
    protected ATMegaFamilyNew.FlagRegister TIFR2_reg;
    protected ATMegaFamilyNew.MaskRegister TIMSK2_reg;
    private static final int[] MCUCR_sm_perm;

    public ATMega169(int id, ClockDomain cd, Program p) {
        super(cd, props, new FiniteStateMachine((Clock)cd.getMainClock(), 0, idleModeNames, transitionTimeMatrix));
        this.simulator = new Simulator(id, LegacyInterpreter.FACTORY, this, p);
        this.interpreter = (AtmelInterpreter)this.simulator.getInterpreter();
        this.MCUCR_reg = this.getIOReg("MCUCR");
        this.installPins();
        this.installDevices();
    }

    protected void installPins() {
        for (int cntr = 0; cntr < this.properties.num_pins; ++cntr) {
            this.pins[cntr] = new DefaultMCU.Pin(this, cntr);
        }
    }

    protected void installDevices() {
        int[] EIFR_mapping = new int[]{2, -1, -1, -1, -1, -1, 4, 3};
        this.EIFR_reg = new ATMegaFamilyNew.FlagRegister(this.interpreter, EIFR_mapping);
        int[] TIFR0_mapping = new int[]{12, 11, -1, -1, -1, -1, -1, -1};
        int[] TIFR1_mapping = new int[]{10, 8, 9, -1, -1, 7, -1, -1};
        int[] TIFR2_mapping = new int[]{6, 5, -1, -1, -1, -1, -1, -1};
        this.TIFR0_reg = new ATMegaFamilyNew.FlagRegister(this.interpreter, TIFR0_mapping);
        this.TIMSK0_reg = new ATMegaFamilyNew.MaskRegister(this.interpreter, TIFR0_mapping);
        this.TIFR1_reg = new ATMegaFamilyNew.FlagRegister(this.interpreter, TIFR1_mapping);
        this.TIMSK1_reg = new ATMegaFamilyNew.MaskRegister(this.interpreter, TIFR1_mapping);
        this.TIFR2_reg = new ATMegaFamilyNew.FlagRegister(this.interpreter, TIFR2_mapping);
        this.TIMSK2_reg = new ATMegaFamilyNew.MaskRegister(this.interpreter, TIFR2_mapping);
        this.installIOReg("TIFR0", this.TIFR0_reg);
        this.installIOReg("TIFR1", this.TIFR1_reg);
        this.installIOReg("TIFR2", this.TIFR2_reg);
        this.installIOReg("TIMSK0", this.TIMSK0_reg);
        this.installIOReg("TIMSK1", this.TIMSK1_reg);
        this.installIOReg("TIMSK2", this.TIMSK2_reg);
        this.buildPort('A');
        this.buildPort('B');
        this.buildPort('C');
        this.buildPort('D');
        this.buildPort('E');
        this.buildPort('F');
        this.buildPort('G', 5);
        this.addDevice(new EEPROM(this.properties.eeprom_size, (AtmelMicrocontroller)this));
        this.addDevice(new USART("", this));
        this.addDevice(new SPI(this));
        this.addDevice(new ADC(this, 8));
    }

    protected int getSleepMode() {
        byte value = this.MCUCR_reg.read();
        boolean sleepEnable = Arithmetic.getBit(value, 5);
        if (sleepEnable) {
            return Arithmetic.getBitField(value, MCUCR_sm_perm) + 1;
        }
        return 1;
    }

    static {
        HashMap pinAssignments = new HashMap(150);
        RegisterLayout rl = new RegisterLayout(224, 8);
        HashMap interruptAssignments = new HashMap(30);
        ATMega169.addPin(pinAssignments, 1, "LCDCAP");
        ATMega169.addPin(pinAssignments, 2, "RXD", "PCINT0", "PE0");
        ATMega169.addPin(pinAssignments, 3, "TXD", "PCINT1", "PE1");
        ATMega169.addPin(pinAssignments, 4, "XCK", "AIN0", "PCINT2", "PE2");
        ATMega169.addPin(pinAssignments, 5, "AIN1", "PCINT3", "PE3");
        ATMega169.addPin(pinAssignments, 6, "USCK", "SCL", "PCINT4", "PE4");
        ATMega169.addPin(pinAssignments, 7, "DI", "SDA", "PCINT5", "PE5");
        ATMega169.addPin(pinAssignments, 8, "DO", "PCINT6", "PE6");
        ATMega169.addPin(pinAssignments, 9, "CLK0", "PCINT7", "PE7");
        ATMega169.addPin(pinAssignments, 10, "SS", "PCINT8", "PB0");
        ATMega169.addPin(pinAssignments, 11, "SCK", "PCINT9", "PB1");
        ATMega169.addPin(pinAssignments, 12, "MOSI", "PCINT10", "PB2");
        ATMega169.addPin(pinAssignments, 13, "MISO", "PCINT11", "PB3");
        ATMega169.addPin(pinAssignments, 14, "OC0A", "PCINT12", "PB4");
        ATMega169.addPin(pinAssignments, 15, "OC1A", "PCINT13", "PB5");
        ATMega169.addPin(pinAssignments, 16, "OC1B", "PCINT14", "PB6");
        ATMega169.addPin(pinAssignments, 17, "OC2A", "PCINT15", "PB7");
        ATMega169.addPin(pinAssignments, 18, "T1", "SEG24", "PG3");
        ATMega169.addPin(pinAssignments, 19, "T0", "SEG23", "PG4");
        ATMega169.addPin(pinAssignments, 20, "RESET");
        ATMega169.addPin(pinAssignments, 21, "VCC.1");
        ATMega169.addPin(pinAssignments, 22, "GND.1");
        ATMega169.addPin(pinAssignments, 23, "TOSC2", "XTAL2");
        ATMega169.addPin(pinAssignments, 24, "TOSC1", "XTAL1");
        ATMega169.addPin(pinAssignments, 25, "ICP1", "SEG22", "PD0");
        ATMega169.addPin(pinAssignments, 26, "INT0", "SEG21", "PD1");
        ATMega169.addPin(pinAssignments, 27, "SEG20", "PD2");
        ATMega169.addPin(pinAssignments, 28, "SEG19", "PD3");
        ATMega169.addPin(pinAssignments, 29, "SEG18", "PD4");
        ATMega169.addPin(pinAssignments, 30, "SEG17", "PD5");
        ATMega169.addPin(pinAssignments, 31, "SEG16", "PD6");
        ATMega169.addPin(pinAssignments, 32, "SEG15", "PD7");
        ATMega169.addPin(pinAssignments, 33, "SEG14", "PG0");
        ATMega169.addPin(pinAssignments, 34, "SEG13", "PG1");
        ATMega169.addPin(pinAssignments, 35, "SEG12", "PC0");
        ATMega169.addPin(pinAssignments, 36, "SEG11", "PC1");
        ATMega169.addPin(pinAssignments, 37, "SEG10", "PC2");
        ATMega169.addPin(pinAssignments, 38, "SEG9", "PC3");
        ATMega169.addPin(pinAssignments, 39, "SEG8", "PC4");
        ATMega169.addPin(pinAssignments, 40, "SEG7", "PC5");
        ATMega169.addPin(pinAssignments, 41, "SEG6", "PC6");
        ATMega169.addPin(pinAssignments, 42, "SEG5", "PC7");
        ATMega169.addPin(pinAssignments, 43, "SEG4", "PG2");
        ATMega169.addPin(pinAssignments, 44, "SEG3", "PA7");
        ATMega169.addPin(pinAssignments, 45, "SEG2", "PA6");
        ATMega169.addPin(pinAssignments, 46, "SEG1", "PA5");
        ATMega169.addPin(pinAssignments, 47, "SEG0", "PA4");
        ATMega169.addPin(pinAssignments, 48, "COM3", "PA3");
        ATMega169.addPin(pinAssignments, 49, "COM2", "PA2");
        ATMega169.addPin(pinAssignments, 50, "COM1", "PA1");
        ATMega169.addPin(pinAssignments, 51, "COM0", "PA0");
        ATMega169.addPin(pinAssignments, 52, "VCC.2");
        ATMega169.addPin(pinAssignments, 53, "GND.2");
        ATMega169.addPin(pinAssignments, 54, "ADC7", "TDI", "PF7");
        ATMega169.addPin(pinAssignments, 55, "ADC6", "TDO", "PF6");
        ATMega169.addPin(pinAssignments, 56, "ADC5", "TMS", "PF5");
        ATMega169.addPin(pinAssignments, 57, "ADC4", "TCK", "PF4");
        ATMega169.addPin(pinAssignments, 58, "ADC3", "PF3");
        ATMega169.addPin(pinAssignments, 59, "ADC2", "PF2");
        ATMega169.addPin(pinAssignments, 60, "ADC1", "PF1");
        ATMega169.addPin(pinAssignments, 61, "ADC0", "PF0");
        ATMega169.addPin(pinAssignments, 62, "AREF");
        ATMega169.addPin(pinAssignments, 63, "GND.3");
        ATMega169.addPin(pinAssignments, 64, "AVCC");
        rl.addIOReg("LCDDR18", 222, ".......,SEG324");
        rl.addIOReg("LCDDR17", 221, "SEG32[3:0],SEG31[9:6]");
        rl.addIOReg("LCDDR16", 220, "SEG31[5:0],SEG30[9:8]");
        rl.addIOReg("LCDDR15", 219, "SEG30[7:0]");
        rl.addIOReg("LCDDR13", 217, ".......,SEG224");
        rl.addIOReg("LCDDR12", 216, "SEG22[3:0],SEG21[9:6]");
        rl.addIOReg("LCDDR11", 215, "SEG21[5:0],SEG20[9:8]");
        rl.addIOReg("LCDDR10", 214, "SEG20[7:0]");
        rl.addIOReg("LCDDR8", 212, ".......,SEG114");
        rl.addIOReg("LCDDR7", 211, "SEG12[3:0],SEG11[9:6]");
        rl.addIOReg("LCDDR6", 210, "SEG11[5:0],SEG10[9:8]");
        rl.addIOReg("LCDDR5", 209, "SEG10[7:0]");
        rl.addIOReg("LCDDR3", 207, ".......,SEG014");
        rl.addIOReg("LCDDR2", 206, "SEG02[3:0],SEG01[9:6]");
        rl.addIOReg("LCDDR1", 205, "SEG01[5:0],SEG00[9:8]");
        rl.addIOReg("LCDDR0", 204, "SEG00[7:0]");
        rl.addIOReg("LCDCCR", 199, "LCDDC[2:0],.,LCDCC[3:0]");
        rl.addIOReg("LCDFRR", 198, ".,LCDPS[2:0],.,LCDCD[2:0]");
        rl.addIOReg("LCDCRB", 197, "LCDCS,LCD2B,LCDMUX[1:0],.,LCDPM[2:0]");
        rl.addIOReg("LCDCRA", 196, "LCDEN,LCDAB,.,LCDIF,LCDIE,..,LCDBL");
        rl.addIOReg("UDR", 166);
        rl.addIOReg("UBRRH", 165);
        rl.addIOReg("UBRRL", 164);
        rl.addIOReg("UCSRC", 162, ".,UMSEL,UPM[1:0],USBS,UCSZ[1:0],UCDPOL");
        rl.addIOReg("UCSRB", 161, "RXCIE,TXCIE,UDRIE,RXEN,TXEN,UCSZ2,RXB6,TXB6");
        rl.addIOReg("UCSRA", 160, "RXC,TXC,UDRE,FE,DOR,UPE,U2X,MPCM");
        rl.addIOReg("USIDR", 154);
        rl.addIOReg("USISR", 153, "USISIF,USIOIF,USIPF,USIDC,USICNT[3:0]");
        rl.addIOReg("USICR", 152, "USISIE,USIOIE,USIWM[1:0],USICS[1:0],USICLK,USITC");
        rl.addIOReg("ASSR", 150, "...,EXCLK,AS2,TCN2UB,OCR2UB,TCR2UB");
        rl.addIOReg("OCR2A", 147);
        rl.addIOReg("TCNT2", 146);
        rl.addIOReg("TCCR2A", 144, "FOC2A,WGM20,COM2A[1:0],WGM21,CS2[2:0]");
        rl.addIOReg("OCR1BH", 107);
        rl.addIOReg("OCR1BL", 106);
        rl.addIOReg("OCR1AH", 105);
        rl.addIOReg("OCR1AL", 104);
        rl.addIOReg("ICR1H", 103);
        rl.addIOReg("ICR1L", 102);
        rl.addIOReg("TCNT1H", 101);
        rl.addIOReg("TCNT1L", 100);
        rl.addIOReg("TCCR1C", 98, "FOC1A,FOC1B,......");
        rl.addIOReg("TCCR1B", 97, "ICNC1,ICES1,.,WGM1[3:2],CS1[2:0]");
        rl.addIOReg("TCCR1A", 96, "COM1A[1:0],COM1B[1:0],..,WGM1[1:0]");
        rl.addIOReg("DIDR1", 95, "......,AIN1D,AIN0D");
        rl.addIOReg("DIDR0", 94, "ADC7D,ADC6D,ADC5D,ADC4D,ADC3D,ADC2D,ADC1D,ADC0D");
        rl.addIOReg("ADMUX", 92, "REFS[1:0],ADLAR,MUX[4:0]");
        rl.addIOReg("ADCSRB", 91, ".,ACME,...,ADTS[2:0]");
        rl.addIOReg("ADCSRA", 90, "ADEN,ADSC,ADATE,ADIF,ADIE,ADPS[2:0]");
        rl.addIOReg("ADCH", 89);
        rl.addIOReg("ADCL", 88);
        rl.addIOReg("TIMSK2", 80, "......,OCIE2A,TOIE2");
        rl.addIOReg("TIMSK1", 79, "..,ICIE1,..,OCIE1B,OCIE1A,TOIE1");
        rl.addIOReg("TIMSK0", 78, "......,OCIE0A,TOIE0");
        rl.addIOReg("PCMSK1", 76, "PCINT[15:8]");
        rl.addIOReg("PCMSK0", 75, "PCINT[7:0]");
        rl.addIOReg("EICRA", 73, "......,ISC0[1:0]");
        rl.addIOReg("OSCCALC", 70);
        rl.addIOReg("PRR", 68, "...,PRLCD,PRTIM1,PRSPI,PRUSART0,PRADC");
        rl.addIOReg("CLKPR", 65, "CLKPCE,...,CLKPS[3:0]");
        rl.addIOReg("WDTCR", 64, "...,WDCE,WDE,WDP[2:0]");
        rl.addIOReg("SREG", 63);
        rl.addIOReg("SPH", 62);
        rl.addIOReg("SPL", 61);
        rl.addIOReg("SPMCSR", 55);
        rl.addIOReg("MCUCR", 53);
        rl.addIOReg("MCUSR", 52);
        rl.addIOReg("SMCR", 51);
        rl.addIOReg("OCDR", 49);
        rl.addIOReg("ACSR", 48);
        rl.addIOReg("SPDR", 46);
        rl.addIOReg("SPSR", 45);
        rl.addIOReg("SPCR", 44);
        rl.addIOReg("GPIOR2", 43);
        rl.addIOReg("GPIOR1", 42);
        rl.addIOReg("OCR0A", 39);
        rl.addIOReg("TCNT0", 38);
        rl.addIOReg("TCCR0A", 36, "FOC0A,WGM00,COM0A[1:0],WGM01,CS0[2:0]");
        rl.addIOReg("GTCCR", 35, "TSM,.....,PSR2,PSR10");
        rl.addIOReg("EEARH", 34);
        rl.addIOReg("EEARL", 33);
        rl.addIOReg("EEDR", 32);
        rl.addIOReg("EECR", 31);
        rl.addIOReg("GPIOR0", 30);
        rl.addIOReg("EIMSK", 29, "PCIE[1:0],.....,INT0");
        rl.addIOReg("EIFR", 28, "PCIF[1:0],.....,INTF0");
        rl.addIOReg("TIFR2", 23, "......,OCF2A,TOV2");
        rl.addIOReg("TIFR1", 22, "..,ICF1,..OCF1B,OCF1A,TOV1");
        rl.addIOReg("TIFR0", 21, "......,OCF0A,TOV0");
        rl.addIOReg("PORTG", 20);
        rl.addIOReg("DDRG", 19);
        rl.addIOReg("PING", 18);
        rl.addIOReg("PORTF", 17);
        rl.addIOReg("DDRF", 16);
        rl.addIOReg("PINF", 15);
        rl.addIOReg("PORTE", 14);
        rl.addIOReg("DDRE", 13);
        rl.addIOReg("PINE", 12);
        rl.addIOReg("PORTD", 11);
        rl.addIOReg("DDRD", 10);
        rl.addIOReg("PIND", 9);
        rl.addIOReg("PORTC", 8);
        rl.addIOReg("DDRC", 7);
        rl.addIOReg("PINC", 6);
        rl.addIOReg("PORTB", 5);
        rl.addIOReg("DDRB", 4);
        rl.addIOReg("PINB", 3);
        rl.addIOReg("PORTA", 2);
        rl.addIOReg("DDRA", 1);
        rl.addIOReg("PINA", 0);
        ATMega169.addInterrupt(interruptAssignments, "RESET", 1);
        ATMega169.addInterrupt(interruptAssignments, "INT0", 2);
        ATMega169.addInterrupt(interruptAssignments, "PCINT0", 3);
        ATMega169.addInterrupt(interruptAssignments, "PCINT1", 4);
        ATMega169.addInterrupt(interruptAssignments, "TIMER2 COMP", 5);
        ATMega169.addInterrupt(interruptAssignments, "TIMER2 OVF", 6);
        ATMega169.addInterrupt(interruptAssignments, "TIMER1 CAPT", 7);
        ATMega169.addInterrupt(interruptAssignments, "TIMER1 COMPA", 8);
        ATMega169.addInterrupt(interruptAssignments, "TIMER1 COMPB", 9);
        ATMega169.addInterrupt(interruptAssignments, "TIMER1 OVF", 10);
        ATMega169.addInterrupt(interruptAssignments, "TIMER0 COMP", 11);
        ATMega169.addInterrupt(interruptAssignments, "TIMER0 OVF", 12);
        ATMega169.addInterrupt(interruptAssignments, "SPI, STC", 13);
        ATMega169.addInterrupt(interruptAssignments, "USART, RX", 14);
        ATMega169.addInterrupt(interruptAssignments, "USART, UDRE", 15);
        ATMega169.addInterrupt(interruptAssignments, "USART, TX", 16);
        ATMega169.addInterrupt(interruptAssignments, "USI START", 17);
        ATMega169.addInterrupt(interruptAssignments, "USI OVERFLOW", 18);
        ATMega169.addInterrupt(interruptAssignments, "ANALOG COMP", 19);
        ATMega169.addInterrupt(interruptAssignments, "ADC", 20);
        ATMega169.addInterrupt(interruptAssignments, "EE READY", 21);
        ATMega169.addInterrupt(interruptAssignments, "SPM READY", 22);
        ATMega169.addInterrupt(interruptAssignments, "LCD", 23);
        props = new AVRProperties(224, 1024, 16384, 512, 64, 22, new ReprogrammableCodeSegment.Factory(16384, 6), pinAssignments, rl, interruptAssignments);
        MCUCR_sm_perm = new int[]{2, 4, 3};
    }

    public static class Factory
    implements MicrocontrollerFactory {
        public Microcontroller newMicrocontroller(int id, ClockDomain cd, Program p) {
            return new ATMega169(id, cd, p);
        }
    }
}

