/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.mcu;

import avrora.arch.avr.AVRProperties;
import avrora.arch.legacy.LegacyInterpreter;
import avrora.core.Program;
import avrora.sim.ActiveRegister;
import avrora.sim.AtmelInterpreter;
import avrora.sim.FiniteStateMachine;
import avrora.sim.Simulator;
import avrora.sim.clock.Clock;
import avrora.sim.clock.ClockDomain;
import avrora.sim.mcu.ADC;
import avrora.sim.mcu.ATMegaFamily;
import avrora.sim.mcu.AtmelMicrocontroller;
import avrora.sim.mcu.DefaultMCU;
import avrora.sim.mcu.EEPROM;
import avrora.sim.mcu.Microcontroller;
import avrora.sim.mcu.MicrocontrollerFactory;
import avrora.sim.mcu.RegisterLayout;
import avrora.sim.mcu.ReprogrammableCodeSegment;
import avrora.sim.mcu.SPI;
import avrora.sim.mcu.USART;
import cck.util.Arithmetic;
import java.util.HashMap;

public class ATMega16
extends ATMegaFamily {
    public static final int _1kb = 1024;
    public static final int _512b = 512;
    public static final int ATMEGA16_IOREG_SIZE = 64;
    public static final int ATMEGA16_SRAM_SIZE = 1024;
    public static final int ATMEGA16_FLASH_SIZE = 16384;
    public static final int ATMEGA16_EEPROM_SIZE = 512;
    public static final int ATMEGA16_NUM_PINS = 41;
    public static final int ATMEGA16_NUM_INTS = 22;
    public static final int MODE_IDLE = 1;
    public static final int MODE_RESERVED1 = 2;
    public static final int MODE_ADCNRED = 3;
    public static final int MODE_RESERVED2 = 4;
    public static final int MODE_POWERDOWN = 5;
    public static final int MODE_STANDBY = 6;
    public static final int MODE_POWERSAVE = 7;
    public static final int MODE_EXTSTANDBY = 8;
    protected static final String[] idleModeNames = new String[]{"Active", "Idle", "RESERVED 1", "ADC Noise Reduction", "RESERVED 2", "Power Down", "Standby", "Power Save", "Extended Standby"};
    protected static final int[] wakeupTimes = new int[]{0, 0, 0, 0, 0, 1000, 6, 1000, 6};
    protected final ActiveRegister MCUCR_reg;
    private static final int[][] transitionTimeMatrix = FiniteStateMachine.buildBimodalTTM(idleModeNames.length, 0, wakeupTimes, new int[wakeupTimes.length]);
    public static final AVRProperties props;
    private static final int[] MCUCR_sm_perm;

    public ATMega16(int id, ClockDomain cd, Program p) {
        super(cd, props, new FiniteStateMachine((Clock)cd.getMainClock(), 0, idleModeNames, transitionTimeMatrix));
        this.simulator = new Simulator(id, LegacyInterpreter.FACTORY, this, p);
        this.interpreter = (AtmelInterpreter)this.simulator.getInterpreter();
        this.MCUCR_reg = this.getIOReg("MCUCR");
        this.installPins();
        this.installDevices();
    }

    protected void installPins() {
        for (int cntr = 0; cntr < this.properties.num_pins; ++cntr) {
            this.pins[cntr] = new DefaultMCU.Pin(this, cntr);
        }
    }

    protected void installDevices() {
        int[] mapping = new int[]{-1, -1, -1, -1, -1, 4, 2, 3};
        ATMegaFamily.FlagRegister fr = new ATMegaFamily.FlagRegister(this.interpreter, mapping);
        ATMegaFamily.MaskRegister mr = new ATMegaFamily.MaskRegister(this.interpreter, mapping);
        this.installIOReg("GICR", mr);
        this.installIOReg("GIFR", fr);
        this.EIFR_reg = fr;
        this.TIFR_reg = this.buildInterruptRange(false, "TIMSK", "TIFR", 12, 8);
        this.TIMSK_reg = (ATMegaFamily.MaskRegister)this.getIOReg("TIMSK");
        this.addDevice(new ATMegaFamily.Timer0(this));
        this.addDevice(new ATMegaFamily.Timer1(this, 2));
        this.addDevice(new ATMegaFamily.Timer2(this));
        this.buildPort('A');
        this.buildPort('B');
        this.buildPort('C');
        this.buildPort('D');
        this.addDevice(new EEPROM(this.properties.eeprom_size, (AtmelMicrocontroller)this));
        this.addDevice(new USART("", this));
        this.addDevice(new SPI(this));
        this.addDevice(new ADC(this, 8));
    }

    protected int getSleepMode() {
        byte value = this.MCUCR_reg.read();
        boolean sleepEnable = Arithmetic.getBit(value, 5);
        if (sleepEnable) {
            return Arithmetic.getBitField(value, MCUCR_sm_perm) + 1;
        }
        return 1;
    }

    static {
        HashMap pinAssignments = new HashMap(150);
        RegisterLayout rl = new RegisterLayout(64, 8);
        HashMap interruptAssignments = new HashMap(30);
        ATMega16.addPin(pinAssignments, 1, "XCK", "T0", "PB0");
        ATMega16.addPin(pinAssignments, 2, "T1", "PB1");
        ATMega16.addPin(pinAssignments, 3, "AIN0", "INT2", "PB2");
        ATMega16.addPin(pinAssignments, 4, "AIN1", "OC0", "PB3");
        ATMega16.addPin(pinAssignments, 5, "SS", "PB4");
        ATMega16.addPin(pinAssignments, 6, "MOSI", "PB5");
        ATMega16.addPin(pinAssignments, 7, "MISO", "PB6");
        ATMega16.addPin(pinAssignments, 8, "SCK", "PB7");
        ATMega16.addPin(pinAssignments, 9, "RESET");
        ATMega16.addPin(pinAssignments, 10, "VCC.1");
        ATMega16.addPin(pinAssignments, 11, "GND.1");
        ATMega16.addPin(pinAssignments, 12, "XTAL2");
        ATMega16.addPin(pinAssignments, 13, "XTAL1");
        ATMega16.addPin(pinAssignments, 14, "RXD", "PD0");
        ATMega16.addPin(pinAssignments, 15, "TXD", "PD1");
        ATMega16.addPin(pinAssignments, 16, "INT0", "PD2");
        ATMega16.addPin(pinAssignments, 17, "INT1", "PD3");
        ATMega16.addPin(pinAssignments, 18, "OC1B", "PD4");
        ATMega16.addPin(pinAssignments, 19, "OC1A", "PD5");
        ATMega16.addPin(pinAssignments, 20, "ICP1", "PD6");
        ATMega16.addPin(pinAssignments, 21, "OC2", "PD7");
        ATMega16.addPin(pinAssignments, 22, "TOSC2", "PC7");
        ATMega16.addPin(pinAssignments, 23, "TOSC1", "PC6");
        ATMega16.addPin(pinAssignments, 24, "TDI", "PC5");
        ATMega16.addPin(pinAssignments, 25, "TDO", "PC4");
        ATMega16.addPin(pinAssignments, 26, "TMS", "PC3");
        ATMega16.addPin(pinAssignments, 27, "TCK", "PC2");
        ATMega16.addPin(pinAssignments, 28, "SDA", "PC1");
        ATMega16.addPin(pinAssignments, 29, "SCL", "PC0");
        ATMega16.addPin(pinAssignments, 30, "AVCC");
        ATMega16.addPin(pinAssignments, 31, "GND.2");
        ATMega16.addPin(pinAssignments, 32, "AREF");
        ATMega16.addPin(pinAssignments, 33, "ADC7", "PA7");
        ATMega16.addPin(pinAssignments, 34, "ADC6", "PA6");
        ATMega16.addPin(pinAssignments, 35, "ADC5", "PA5");
        ATMega16.addPin(pinAssignments, 36, "ADC4", "PA4");
        ATMega16.addPin(pinAssignments, 37, "ADC3", "PA3");
        ATMega16.addPin(pinAssignments, 38, "ADC2", "PA2");
        ATMega16.addPin(pinAssignments, 39, "ADC1", "PA1");
        ATMega16.addPin(pinAssignments, 40, "ADC0", "PA0");
        rl.addIOReg("SREG", 63);
        rl.addIOReg("SPH", 62);
        rl.addIOReg("SPL", 61);
        rl.addIOReg("OCR0", 60);
        rl.addIOReg("GICR", 59);
        rl.addIOReg("GIFR", 58);
        rl.addIOReg("TIMSK", 57);
        rl.addIOReg("TIFR", 56);
        rl.addIOReg("SPMCR", 55);
        rl.addIOReg("SPMCSR", 55);
        rl.addIOReg("TWCR", 54);
        rl.addIOReg("MCUCR", 53);
        rl.addIOReg("MCUCSR", 52);
        rl.addIOReg("TCCR0", 51);
        rl.addIOReg("TCNT0", 50);
        rl.addIOReg("OSCCAL", 49);
        rl.addIOReg("SFIOR", 48);
        rl.addIOReg("TCCR1A", 47, "COM1A[1:0],COM1B[1:0],FOC1A,FOC1B,WGM1[1:0]");
        rl.addIOReg("TCCR1B", 46, "...,WGM1[3:2],CS1[2:0]");
        rl.addIOReg("TCNT1H", 45);
        rl.addIOReg("TCNT1L", 44);
        rl.addIOReg("OCR1AH", 43);
        rl.addIOReg("OCR1AL", 42);
        rl.addIOReg("OCR1BH", 41);
        rl.addIOReg("OCR1BL", 40);
        rl.addIOReg("ICR1H", 39);
        rl.addIOReg("ICR1L", 38);
        rl.addIOReg("TCCR2", 37);
        rl.addIOReg("TCNT2", 36);
        rl.addIOReg("OCR2", 35);
        rl.addIOReg("ASSR", 34);
        rl.addIOReg("WDTCR", 33);
        rl.addIOReg("UBRRH", 32);
        rl.addIOReg("UCSRC", 32);
        rl.addIOReg("EEARH", 31);
        rl.addIOReg("EEARL", 30);
        rl.addIOReg("EEDR", 29);
        rl.addIOReg("EECR", 28);
        rl.addIOReg("PORTA", 27);
        rl.addIOReg("DDRA", 26);
        rl.addIOReg("PINA", 25);
        rl.addIOReg("PORTB", 24);
        rl.addIOReg("DDRB", 23);
        rl.addIOReg("PINB", 22);
        rl.addIOReg("PORTC", 21);
        rl.addIOReg("DDRC", 20);
        rl.addIOReg("PINC", 19);
        rl.addIOReg("PORTD", 18);
        rl.addIOReg("DDRD", 17);
        rl.addIOReg("PIND", 16);
        rl.addIOReg("SPDR", 15);
        rl.addIOReg("SPSR", 14);
        rl.addIOReg("SPCR", 13);
        rl.addIOReg("UDR", 12);
        rl.addIOReg("UCSRA", 11);
        rl.addIOReg("UCSRB", 10);
        rl.addIOReg("UBRRL", 9);
        rl.addIOReg("ACSR", 8);
        rl.addIOReg("ADMUX", 7);
        rl.addIOReg("ADCSRA", 6);
        rl.addIOReg("ADCH", 5);
        rl.addIOReg("ADCL", 4);
        rl.addIOReg("TWDR", 3);
        rl.addIOReg("TWAR", 2);
        rl.addIOReg("TWSR", 1);
        rl.addIOReg("TWBR", 0);
        ATMega16.addInterrupt(interruptAssignments, "RESET", 1);
        ATMega16.addInterrupt(interruptAssignments, "INT0", 2);
        ATMega16.addInterrupt(interruptAssignments, "INT1", 3);
        ATMega16.addInterrupt(interruptAssignments, "INT2", 19);
        ATMega16.addInterrupt(interruptAssignments, "TIMER2 COMP", 4);
        ATMega16.addInterrupt(interruptAssignments, "TIMER2 OVF", 5);
        ATMega16.addInterrupt(interruptAssignments, "TIMER1 CAPT", 6);
        ATMega16.addInterrupt(interruptAssignments, "TIMER1 COMPA", 7);
        ATMega16.addInterrupt(interruptAssignments, "TIMER1 COMPB", 8);
        ATMega16.addInterrupt(interruptAssignments, "TIMER1 OVF", 9);
        ATMega16.addInterrupt(interruptAssignments, "TIMER0 COMP", 20);
        ATMega16.addInterrupt(interruptAssignments, "TIMER0 OVF", 10);
        ATMega16.addInterrupt(interruptAssignments, "SPI, ST", 11);
        ATMega16.addInterrupt(interruptAssignments, "USART, RX", 12);
        ATMega16.addInterrupt(interruptAssignments, "USART, UDRE", 13);
        ATMega16.addInterrupt(interruptAssignments, "USART, TX", 14);
        ATMega16.addInterrupt(interruptAssignments, "ADC", 15);
        ATMega16.addInterrupt(interruptAssignments, "EE READY", 16);
        ATMega16.addInterrupt(interruptAssignments, "ANALOG COMP", 17);
        ATMega16.addInterrupt(interruptAssignments, "TWI", 18);
        ATMega16.addInterrupt(interruptAssignments, "SPM READY", 21);
        props = new AVRProperties(64, 1024, 16384, 512, 41, 22, new ReprogrammableCodeSegment.Factory(16384, 6), pinAssignments, rl, interruptAssignments);
        MCUCR_sm_perm = new int[]{2, 4, 3};
    }

    public static class Factory
    implements MicrocontrollerFactory {
        public Microcontroller newMicrocontroller(int id, ClockDomain cd, Program p) {
            return new ATMega16(id, cd, p);
        }
    }
}

