/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.mcu;

import avrora.arch.avr.AVRProperties;
import avrora.arch.legacy.LegacyInterpreter;
import avrora.core.Program;
import avrora.sim.ActiveRegister;
import avrora.sim.AtmelInterpreter;
import avrora.sim.FiniteStateMachine;
import avrora.sim.Simulator;
import avrora.sim.clock.Clock;
import avrora.sim.clock.ClockDomain;
import avrora.sim.energy.Energy;
import avrora.sim.mcu.ADC;
import avrora.sim.mcu.ATMegaFamily;
import avrora.sim.mcu.AtmelMicrocontroller;
import avrora.sim.mcu.DefaultMCU;
import avrora.sim.mcu.EEPROM;
import avrora.sim.mcu.Microcontroller;
import avrora.sim.mcu.MicrocontrollerFactory;
import avrora.sim.mcu.RegisterLayout;
import avrora.sim.mcu.ReprogrammableCodeSegment;
import avrora.sim.mcu.SPI;
import avrora.sim.mcu.USART;
import cck.util.Arithmetic;
import java.util.HashMap;

public class ATMega128
extends ATMegaFamily {
    public static final int _1kb = 1024;
    public static final int ATMEGA128_IOREG_SIZE = 224;
    public static final int ATMEGA128_SRAM_SIZE = 4096;
    public static final int ATMEGA128_FLASH_SIZE = 131072;
    public static final int ATMEGA128_EEPROM_SIZE = 4096;
    public static final int ATMEGA128_NUM_PINS = 65;
    public static final int ATMEGA128_NUM_INTS = 36;
    public static final int MODE_IDLE = 1;
    public static final int MODE_ADCNRED = 2;
    public static final int MODE_POWERDOWN = 3;
    public static final int MODE_POWERSAVE = 4;
    public static final int MODE_RESERVED1 = 5;
    public static final int MODE_RESERVED2 = 6;
    public static final int MODE_STANDBY = 7;
    public static final int MODE_EXTSTANDBY = 8;
    protected static final String[] idleModeNames = new String[]{"Active", "Idle", "ADC Noise Reduction", "Power Down", "Power Save", "RESERVED 1", "RESERVED 2", "Standby", "Extended Standby"};
    private static final double[] modeAmpere = new double[]{0.0075667, 0.0033433, 9.884E-4, 1.158E-4, 1.237E-4, 0.0, 0.0, 2.356E-4, 2.433E-4};
    protected static final int[] wakeupTimes = new int[]{0, 0, 0, 1000, 1000, 0, 0, 6, 6};
    protected final ActiveRegister MCUCR_reg;
    private static final int[][] transitionTimeMatrix = FiniteStateMachine.buildBimodalTTM(idleModeNames.length, 0, wakeupTimes, new int[wakeupTimes.length]);
    public static final AVRProperties props;
    private static final int[] MCUCR_sm_perm;

    public ATMega128(int id, ClockDomain cd, Program p) {
        super(cd, props, new FiniteStateMachine((Clock)cd.getMainClock(), 0, idleModeNames, transitionTimeMatrix));
        this.simulator = new Simulator(id, LegacyInterpreter.FACTORY, this, p);
        this.interpreter = (AtmelInterpreter)this.simulator.getInterpreter();
        this.MCUCR_reg = this.getIOReg("MCUCR");
        this.installPins();
        this.installDevices();
        new Energy("CPU", modeAmpere, this.sleepState);
    }

    protected void installPins() {
        for (int cntr = 0; cntr < this.properties.num_pins; ++cntr) {
            this.pins[cntr] = new DefaultMCU.Pin(this, cntr);
        }
    }

    protected void installDevices() {
        this.EIFR_reg = this.buildInterruptRange(true, "EIMSK", "EIFR", 2, 8);
        this.TIFR_reg = this.buildInterruptRange(false, "TIMSK", "TIFR", 17, 8);
        this.TIMSK_reg = (ATMegaFamily.MaskRegister)this.getIOReg("TIMSK");
        int[] ETIFR_mapping = new int[]{25, 29, 30, 28, 27, 26, -1, -1};
        this.ETIFR_reg = new ATMegaFamily.FlagRegister(this.interpreter, ETIFR_mapping);
        this.ETIMSK_reg = new ATMegaFamily.MaskRegister(this.interpreter, ETIFR_mapping);
        this.installIOReg("ETIMSK", this.ETIMSK_reg);
        this.installIOReg("ETIFR", this.ETIFR_reg);
        this.addDevice(new ATMegaFamily.Timer0(this));
        this.addDevice(new ATMegaFamily.Timer1(this, 3));
        this.addDevice(new ATMegaFamily.Timer2(this));
        this.addDevice(new ATMegaFamily.Timer3(this, 3));
        this.buildPort('A');
        this.buildPort('B');
        this.buildPort('C');
        this.buildPort('D');
        this.buildPort('E');
        this.buildPort('F');
        this.addDevice(new EEPROM(this.properties.eeprom_size, (AtmelMicrocontroller)this));
        this.addDevice(new USART("0", this));
        this.addDevice(new USART("1", this));
        this.addDevice(new SPI(this));
        this.addDevice(new ADC(this, 8));
    }

    protected int getSleepMode() {
        byte value = this.MCUCR_reg.read();
        boolean sleepEnable = Arithmetic.getBit(value, 5);
        if (sleepEnable) {
            return Arithmetic.getBitField(value, MCUCR_sm_perm) + 1;
        }
        return 1;
    }

    static {
        HashMap pinAssignments = new HashMap(150);
        HashMap interruptAssignments = new HashMap(50);
        ATMega128.addPin(pinAssignments, 1, "PEN");
        ATMega128.addPin(pinAssignments, 2, "PE0", "RXD0", "PDI");
        ATMega128.addPin(pinAssignments, 3, "PE1", "TXD0", "PDO");
        ATMega128.addPin(pinAssignments, 4, "PE2", "XCK0", "AIN0");
        ATMega128.addPin(pinAssignments, 5, "PE3", "OC3A", "AIN1");
        ATMega128.addPin(pinAssignments, 6, "PE4", "OC3B", "INT4");
        ATMega128.addPin(pinAssignments, 7, "PE5", "OC3C", "INT5");
        ATMega128.addPin(pinAssignments, 8, "PE6", "T3", "INT6");
        ATMega128.addPin(pinAssignments, 9, "PE7", "IC3", "INT7");
        ATMega128.addPin(pinAssignments, 10, "PB0", "SS");
        ATMega128.addPin(pinAssignments, 11, "PB1", "SCK");
        ATMega128.addPin(pinAssignments, 12, "PB2", "MOSI");
        ATMega128.addPin(pinAssignments, 13, "PB3", "MISO");
        ATMega128.addPin(pinAssignments, 14, "PB4", "OC0");
        ATMega128.addPin(pinAssignments, 15, "PB5", "OC1A");
        ATMega128.addPin(pinAssignments, 16, "PB6", "OC1B");
        ATMega128.addPin(pinAssignments, 17, "PB7", "OC2", "OC1C");
        ATMega128.addPin(pinAssignments, 18, "PG3", "TOSC2");
        ATMega128.addPin(pinAssignments, 19, "PG4", "TOSC1");
        ATMega128.addPin(pinAssignments, 20, "RESET");
        ATMega128.addPin(pinAssignments, 21, "VCC");
        ATMega128.addPin(pinAssignments, 22, "GND");
        ATMega128.addPin(pinAssignments, 23, "XTAL2");
        ATMega128.addPin(pinAssignments, 24, "XTAL1");
        ATMega128.addPin(pinAssignments, 25, "PD0", "SCL", "INT0");
        ATMega128.addPin(pinAssignments, 26, "PD1", "SDA", "INT1");
        ATMega128.addPin(pinAssignments, 27, "PD2", "RXD1", "INT2");
        ATMega128.addPin(pinAssignments, 28, "PD3", "TXD1", "INT3");
        ATMega128.addPin(pinAssignments, 29, "PD4", "IC1");
        ATMega128.addPin(pinAssignments, 30, "PD5", "XCK1");
        ATMega128.addPin(pinAssignments, 31, "PD6", "T1");
        ATMega128.addPin(pinAssignments, 32, "PD7", "T2");
        ATMega128.addPin(pinAssignments, 33, "PG0", "WR");
        ATMega128.addPin(pinAssignments, 34, "PG1", "RD");
        ATMega128.addPin(pinAssignments, 35, "PC0", "A8");
        ATMega128.addPin(pinAssignments, 36, "PC1", "A9");
        ATMega128.addPin(pinAssignments, 37, "PC2", "A10");
        ATMega128.addPin(pinAssignments, 38, "PC3", "A11");
        ATMega128.addPin(pinAssignments, 39, "PC4", "A12");
        ATMega128.addPin(pinAssignments, 40, "PC5", "A13");
        ATMega128.addPin(pinAssignments, 41, "PC6", "A14");
        ATMega128.addPin(pinAssignments, 42, "PC7", "A15");
        ATMega128.addPin(pinAssignments, 43, "PG2", "ALE");
        ATMega128.addPin(pinAssignments, 44, "PA7", "AD7");
        ATMega128.addPin(pinAssignments, 45, "PA6", "AD5");
        ATMega128.addPin(pinAssignments, 46, "PA5", "AD5");
        ATMega128.addPin(pinAssignments, 47, "PA4", "AD4");
        ATMega128.addPin(pinAssignments, 48, "PA3", "AD3");
        ATMega128.addPin(pinAssignments, 49, "PA2", "AD2");
        ATMega128.addPin(pinAssignments, 50, "PA1", "AD1");
        ATMega128.addPin(pinAssignments, 51, "PA0", "AD0");
        ATMega128.addPin(pinAssignments, 52, "VCC.b");
        ATMega128.addPin(pinAssignments, 53, "GND.b");
        ATMega128.addPin(pinAssignments, 54, "PF7", "ADC7", "TDI");
        ATMega128.addPin(pinAssignments, 55, "PF6", "ADC6", "TDO");
        ATMega128.addPin(pinAssignments, 56, "PF5", "ADC5", "TMS");
        ATMega128.addPin(pinAssignments, 57, "PF4", "ADC4", "TCK");
        ATMega128.addPin(pinAssignments, 58, "PF3", "ADC3");
        ATMega128.addPin(pinAssignments, 59, "PF2", "ADC2");
        ATMega128.addPin(pinAssignments, 60, "PF1", "ADC1");
        ATMega128.addPin(pinAssignments, 61, "PF0", "ADC0");
        ATMega128.addPin(pinAssignments, 62, "AREF");
        ATMega128.addPin(pinAssignments, 63, "GND.c");
        ATMega128.addPin(pinAssignments, 64, "AVCC");
        RegisterLayout rl = new RegisterLayout(224, 8);
        rl.addIOReg("UCSR1C", 125);
        rl.addIOReg("UDR1", 124);
        rl.addIOReg("UCSR1A", 123);
        rl.addIOReg("UCSR1B", 122);
        rl.addIOReg("UBRR1L", 121);
        rl.addIOReg("UBRR1H", 120);
        rl.addIOReg("UCSR0C", 117);
        rl.addIOReg("UBRR0H", 112);
        rl.addIOReg("TCCR3C", 108, "FOC3A,FOC3B,FOC3C,.....");
        rl.addIOReg("TCCR3A", 107, "COM3A[1:0],COM3B[1:0],COM3C[1:0],WGM3[1:0]");
        rl.addIOReg("TCCR3B", 106, "...,WGM3[3:2],CS3[2:0]");
        rl.addIOReg("TCNT3H", 105);
        rl.addIOReg("TCNT3L", 104);
        rl.addIOReg("OCR3AH", 103);
        rl.addIOReg("OCR3AL", 102);
        rl.addIOReg("OCR3BH", 101);
        rl.addIOReg("OCR3BL", 100);
        rl.addIOReg("OCR3CH", 99);
        rl.addIOReg("OCR3CL", 98);
        rl.addIOReg("ICR3H", 97);
        rl.addIOReg("ICR3L", 96);
        rl.addIOReg("ETIMSK", 93);
        rl.addIOReg("ETIFR", 92);
        rl.addIOReg("TCCR1C", 90, "FOC1A,FOC1B,FOC1C,.....");
        rl.addIOReg("OCR1CH", 89);
        rl.addIOReg("OCR1CL", 88);
        rl.addIOReg("TWCR", 84);
        rl.addIOReg("TWDR", 83);
        rl.addIOReg("TWAR", 82);
        rl.addIOReg("TWSR", 81);
        rl.addIOReg("TWBR", 80);
        rl.addIOReg("OSCCAL", 79);
        rl.addIOReg("XMCRA", 77);
        rl.addIOReg("XMCRB", 76);
        rl.addIOReg("EICRA", 74);
        rl.addIOReg("SPMCSR", 72);
        rl.addIOReg("PORTG", 69);
        rl.addIOReg("DDRG", 68);
        rl.addIOReg("PING", 67);
        rl.addIOReg("PORTF", 66);
        rl.addIOReg("DDRF", 65);
        rl.addIOReg("SREG", 63);
        rl.addIOReg("SPH", 62);
        rl.addIOReg("SPL", 61);
        rl.addIOReg("XDIV", 60);
        rl.addIOReg("RAMPZ", 59);
        rl.addIOReg("EICRB", 58);
        rl.addIOReg("EIMSK", 57);
        rl.addIOReg("EIFR", 56);
        rl.addIOReg("TIMSK", 55);
        rl.addIOReg("TIFR", 54);
        rl.addIOReg("MCUCR", 53);
        rl.addIOReg("MCUCSR", 52);
        rl.addIOReg("TCCR0", 51);
        rl.addIOReg("TCNT0", 50);
        rl.addIOReg("OCR0", 49);
        rl.addIOReg("ASSR", 48);
        rl.addIOReg("TCCR1A", 47, "COM1A[1:0],COM1B[1:0],COM1C[1:0],WGM1[1:0]");
        rl.addIOReg("TCCR1B", 46, "...,WGM1[3:2],CS1[2:0]");
        rl.addIOReg("TCNT1H", 45);
        rl.addIOReg("TCNT1L", 44);
        rl.addIOReg("OCR1AH", 43);
        rl.addIOReg("OCR1AL", 42);
        rl.addIOReg("OCR1BH", 41);
        rl.addIOReg("OCR1BL", 40);
        rl.addIOReg("ICR1H", 39);
        rl.addIOReg("ICR1L", 38);
        rl.addIOReg("TCCR2", 37);
        rl.addIOReg("TCNT2", 36);
        rl.addIOReg("OCR2", 35);
        rl.addIOReg("OCDR", 34);
        rl.addIOReg("WDTCR", 33);
        rl.addIOReg("SFIOR", 32);
        rl.addIOReg("EEARH", 31);
        rl.addIOReg("EEARL", 30);
        rl.addIOReg("EEDR", 29);
        rl.addIOReg("EECR", 28);
        rl.addIOReg("PORTA", 27);
        rl.addIOReg("DDRA", 26);
        rl.addIOReg("PINA", 25);
        rl.addIOReg("PORTB", 24);
        rl.addIOReg("DDRB", 23);
        rl.addIOReg("PINB", 22);
        rl.addIOReg("PORTC", 21);
        rl.addIOReg("DDRC", 20);
        rl.addIOReg("PINC", 19);
        rl.addIOReg("PORTD", 18);
        rl.addIOReg("DDRD", 17);
        rl.addIOReg("PIND", 16);
        rl.addIOReg("SPDR", 15);
        rl.addIOReg("SPSR", 14);
        rl.addIOReg("SPCR", 13);
        rl.addIOReg("UDR0", 12);
        rl.addIOReg("UCSR0A", 11);
        rl.addIOReg("UCSR0B", 10);
        rl.addIOReg("UBRR0L", 9);
        rl.addIOReg("ACSR", 8);
        rl.addIOReg("ADMUX", 7);
        rl.addIOReg("ADCSRA", 6);
        rl.addIOReg("ADCH", 5);
        rl.addIOReg("ADCL", 4);
        rl.addIOReg("PORTE", 3);
        rl.addIOReg("DDRE", 2);
        rl.addIOReg("PINE", 1);
        rl.addIOReg("PINF", 0);
        ATMega128.addInterrupt(interruptAssignments, "RESET", 1);
        ATMega128.addInterrupt(interruptAssignments, "INT0", 2);
        ATMega128.addInterrupt(interruptAssignments, "INT1", 3);
        ATMega128.addInterrupt(interruptAssignments, "INT2", 4);
        ATMega128.addInterrupt(interruptAssignments, "INT3", 5);
        ATMega128.addInterrupt(interruptAssignments, "INT4", 6);
        ATMega128.addInterrupt(interruptAssignments, "INT5", 7);
        ATMega128.addInterrupt(interruptAssignments, "INT6", 8);
        ATMega128.addInterrupt(interruptAssignments, "INT7", 9);
        ATMega128.addInterrupt(interruptAssignments, "TIMER2 COMP", 10);
        ATMega128.addInterrupt(interruptAssignments, "TIMER2 OVF", 11);
        ATMega128.addInterrupt(interruptAssignments, "TIMER1 CAPT", 12);
        ATMega128.addInterrupt(interruptAssignments, "TIMER1 COMPA", 13);
        ATMega128.addInterrupt(interruptAssignments, "TIMER1 COMPB", 14);
        ATMega128.addInterrupt(interruptAssignments, "TIMER1 OVF", 15);
        ATMega128.addInterrupt(interruptAssignments, "TIMER0 COMP", 16);
        ATMega128.addInterrupt(interruptAssignments, "TIMER0 OVF", 17);
        ATMega128.addInterrupt(interruptAssignments, "SPI, STC", 18);
        ATMega128.addInterrupt(interruptAssignments, "USART0, RX", 19);
        ATMega128.addInterrupt(interruptAssignments, "USART0, UDRE", 20);
        ATMega128.addInterrupt(interruptAssignments, "USART0, TX", 21);
        ATMega128.addInterrupt(interruptAssignments, "ADC", 22);
        ATMega128.addInterrupt(interruptAssignments, "EE READY", 23);
        ATMega128.addInterrupt(interruptAssignments, "ANALOG COMP", 24);
        ATMega128.addInterrupt(interruptAssignments, "TIMER1 COMPC", 25);
        ATMega128.addInterrupt(interruptAssignments, "TIMER3 CAPT", 26);
        ATMega128.addInterrupt(interruptAssignments, "TIMER3 COMPA", 27);
        ATMega128.addInterrupt(interruptAssignments, "TIMER3 COMPB", 28);
        ATMega128.addInterrupt(interruptAssignments, "TIMER3 COMPC", 29);
        ATMega128.addInterrupt(interruptAssignments, "TIMER3 OVF", 30);
        ATMega128.addInterrupt(interruptAssignments, "USART1, RX", 31);
        ATMega128.addInterrupt(interruptAssignments, "USART1, UDRE", 32);
        ATMega128.addInterrupt(interruptAssignments, "USART1, TX", 33);
        ATMega128.addInterrupt(interruptAssignments, "TWI", 34);
        ATMega128.addInterrupt(interruptAssignments, "SPM READY", 35);
        props = new AVRProperties(224, 4096, 131072, 4096, 65, 36, new ReprogrammableCodeSegment.Factory(131072, 7), pinAssignments, rl, interruptAssignments);
        MCUCR_sm_perm = new int[]{2, 4, 3};
    }

    public static class Factory
    implements MicrocontrollerFactory {
        public Microcontroller newMicrocontroller(int id, ClockDomain cd, Program p) {
            return new ATMega128(id, cd, p);
        }
    }
}

