/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.mcu;

import avrora.sim.InterruptTable;
import avrora.sim.RWRegister;
import avrora.sim.Simulator;
import avrora.sim.mcu.AtmelInternalDevice;
import avrora.sim.mcu.AtmelMicrocontroller;
import avrora.sim.state.BooleanView;
import avrora.sim.state.RegisterUtil;
import avrora.sim.state.RegisterView;

public class ADC
extends AtmelInternalDevice {
    public static final float VBG_LEVEL = 1.0f;
    public static final float GND_LEVEL = 0.0f;
    private final ADCInput VBG_INPUT = new ADCInput(){

        public float getVoltage() {
            return ADC.this.voltageRef;
        }
    };
    private static final ADCInput GND_INPUT = new ADCInput(){

        public float getVoltage() {
            return 0.0f;
        }
    };
    final MUXRegister ADMUX_reg = new MUXRegister();
    final ControlRegister ADCSRA_reg = new ControlRegister();
    final RWRegister ADCH_reg = new RWRegister();
    final RWRegister ADCL_reg = new RWRegister();
    final int channels;
    final int interruptNum;
    final ADCInput[] connectedDevices;
    float voltageRef = 1.0f;
    static final byte[] SINGLE_ENDED_INPUT = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8, 9};
    static final short[] GAIN = new short[]{-1, -1, -1, -1, -1, -1, -1, -1, 10, 10, 200, 200, 10, 10, 200, 200, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, -1};
    static final byte[] POS_INPUT = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 0, 1, 2, 3, 2, 3, 0, 1, 2, 3, 4, 5, 6, 7, 0, 1, 2, 3, 4, 5, -1, -1};
    static final byte[] NEG_INPUT = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, -1, -1};
    static final short[] PRESCALER = new short[]{2, 2, 4, 8, 16, 32, 64, 128};

    public ADC(AtmelMicrocontroller m, int channels) {
        super("adc", m);
        this.channels = channels;
        this.connectedDevices = new ADCInput[channels + 2];
        this.connectedDevices[channels] = this.VBG_INPUT;
        this.connectedDevices[channels + 1] = GND_INPUT;
        this.interruptNum = m.getProperties().getInterrupt("ADC");
        this.installIOReg("ADMUX", this.ADMUX_reg);
        this.installIOReg("ADCH", this.ADCH_reg);
        this.installIOReg("ADCL", this.ADCL_reg);
        this.installIOReg("ADCSRA", this.ADCSRA_reg);
        this.interpreter.getInterruptTable().registerInternalNotification(this.ADCSRA_reg, this.interruptNum);
    }

    public void setVoltageRef(float vref) {
        this.voltageRef = vref;
    }

    public float getVoltageRef() {
        return this.voltageRef;
    }

    public void connectADCInput(ADCInput input, int num) {
        this.connectedDevices[num] = input;
    }

    protected class ControlRegister
    extends RWRegister
    implements InterruptTable.Notification {
        final ConversionEvent conversion = new ConversionEvent();
        final BooleanView _aden = RegisterUtil.booleanView(this, 7);
        final BooleanView _adsc = RegisterUtil.booleanView(this, 6);
        final BooleanView _adfr = RegisterUtil.booleanView(this, 5);
        final BooleanView _adif = RegisterUtil.booleanView(this, 4);
        final BooleanView _adie = RegisterUtil.booleanView(this, 3);
        final RegisterView _prescaler = RegisterUtil.bitRangeView(this, 0, 2);
        int cycles = 25;
        boolean converting;

        protected ControlRegister() {
        }

        private void unpostADCInterrupt() {
            this._adif.setValue(false);
            ADC.this.interpreter.setPosted(ADC.this.interruptNum, false);
        }

        public void write(byte nval) {
            this.value = nval;
            if (this._aden.getValue()) {
                if (this._adsc.getValue()) {
                    this.startConversion();
                }
            } else {
                this.stopConversion();
            }
            if (this._adif.getValue()) {
                this.unpostADCInterrupt();
            }
            ADC.this.interpreter.setEnabled(ADC.this.interruptNum, this._adie.getValue());
        }

        private void startConversion() {
            if (!this.converting) {
                this.converting = true;
                this.insertConversion();
            }
        }

        private void insertConversion() {
            ADC.this.mainClock.insertEvent(this.conversion, this.getPrescaler() * this.cycles);
            if (ADC.this.ADMUX_reg.isSingleEnded()) {
                ADC.this.event.gen((Object)"ADC: beginning sample of channel %i", ADC.this.ADMUX_reg.getSingleIndex());
            } else {
                ADC.this.event.gen((Object)"ADC: beginning sample of channels %i - %i", ADC.this.ADMUX_reg.getPosIndex(), ADC.this.ADMUX_reg.getNegIndex());
            }
            this.cycles = 13;
        }

        private void stopConversion() {
            this._adsc.setValue(false);
            if (this.converting) {
                this.converting = false;
                ADC.this.mainClock.removeEvent(this.conversion);
            }
        }

        private int getPrescaler() {
            return PRESCALER[this._prescaler.getValue()];
        }

        private int convertVoltage() {
            if (ADC.this.ADMUX_reg.isSingleEnded()) {
                float vref;
                ADCInput dev = ADC.this.connectedDevices[ADC.this.ADMUX_reg.getSingleIndex()];
                float vin = dev != null ? dev.getVoltage() : 0.0f;
                if (vin >= (vref = ADC.this.voltageRef)) {
                    return 1023;
                }
                return 0x3FF & (int)(vin * 1024.0f / vref);
            }
            ADCInput pos = ADC.this.connectedDevices[ADC.this.ADMUX_reg.getPosIndex()];
            ADCInput neg = ADC.this.connectedDevices[ADC.this.ADMUX_reg.getNegIndex()];
            float vpos = pos != null ? pos.getVoltage() : 0.0f;
            float vneg = neg != null ? neg.getVoltage() : 0.0f;
            float vref = ADC.this.voltageRef;
            float val = (vpos - vneg) * (float)ADC.this.ADMUX_reg.getGain() * 512.0f / vref;
            if (val < -512.0f) {
                return 1023;
            }
            if (val > 511.0f) {
                return 511;
            }
            return 0x3FF & (int)val;
        }

        public void force(int inum) {
            this._adif.setValue(true);
        }

        public void invoke(int inum) {
            this.unpostADCInterrupt();
        }

        private class ConversionEvent
        implements Simulator.Event {
            private ConversionEvent() {
            }

            public void fire() {
                int val = ControlRegister.this.convertVoltage();
                AtmelInternalDevice.write16(val, ADC.this.ADCH_reg, ADC.this.ADCL_reg);
                ADC.this.event.gen((Object)"ADC: conversion completed -> %i", val);
                ControlRegister.this._adif.setValue(true);
                ADC.this.interpreter.setPosted(ADC.this.interruptNum, true);
                if (ControlRegister.this._adfr.getValue()) {
                    ControlRegister.this.insertConversion();
                } else {
                    ControlRegister.this.stopConversion();
                }
            }
        }
    }

    protected class MUXRegister
    extends RWRegister {
        final RegisterView _mux = RegisterUtil.bitRangeView(this, 0, 4);

        protected MUXRegister() {
        }

        boolean isSingleEnded() {
            return this.getSingleIndex() >= 0;
        }

        int getSingleIndex() {
            return SINGLE_ENDED_INPUT[this._mux.getValue()];
        }

        int getPosIndex() {
            return POS_INPUT[this._mux.getValue()];
        }

        int getNegIndex() {
            return NEG_INPUT[this._mux.getValue()];
        }

        int getGain() {
            return GAIN[this._mux.getValue()];
        }
    }

    public static interface ADCInput {
        public float getVoltage();
    }
}

