/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.energy;

import avrora.sim.energy.Energy;
import avrora.sim.energy.EnergyObserver;
import java.util.Iterator;
import java.util.LinkedList;

public class EnergyControl {
    private static Instance currentInstance;
    private static boolean active;

    public static void addConsumer(Energy energy) {
        EnergyControl.currentInstance.consumer.add(energy);
        if (active) {
            energy.activate();
        }
    }

    public static void activate() {
        if (!active) {
            active = true;
            Iterator it = EnergyControl.currentInstance.consumer.iterator();
            while (it.hasNext()) {
                ((Energy)it.next()).activate();
            }
        }
    }

    public static Instance getCurrentInstance() {
        return currentInstance;
    }

    public static void nextInstance() {
        currentInstance = new Instance();
    }

    static {
        active = false;
        currentInstance = new Instance();
    }

    public static class Instance {
        public final LinkedList consumer = new LinkedList();
        private final LinkedList subscriber = new LinkedList();

        Instance() {
        }

        public void subscribe(EnergyObserver energyMonitor) {
            this.subscriber.add(energyMonitor);
        }

        public LinkedList getConsumers() {
            return this.consumer;
        }

        public void stateChange(Energy energy) {
            Iterator it = this.subscriber.iterator();
            while (it.hasNext()) {
                ((EnergyObserver)it.next()).stateChange(energy);
            }
        }
    }
}

