/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.energy;

import avrora.sim.FiniteStateMachine;
import avrora.sim.clock.Clock;
import avrora.sim.energy.EnergyControl;

public class Energy
implements FiniteStateMachine.Probe {
    private String deviceName;
    private double[] ampere;
    private long[] cycles;
    private int currentMode;
    private int oldMode;
    private long lastChange;
    private static final double voltage = 3.0;
    private double cycleTime;
    private FiniteStateMachine stateMachine;
    private Clock clock;
    private EnergyControl.Instance instance;

    public Energy(String deviceName, double[] modeAmpere, FiniteStateMachine fsm) {
        this.deviceName = deviceName;
        this.clock = fsm.getClock();
        this.ampere = modeAmpere;
        this.stateMachine = fsm;
        this.currentMode = fsm.getStartState();
        int freq = (int)this.clock.getHZ();
        this.cycleTime = 1.0 / (double)freq;
        this.instance = EnergyControl.getCurrentInstance();
        EnergyControl.addConsumer(this);
    }

    public void fireBeforeTransition(int beforeState, int afterState) {
    }

    public void fireAfterTransition(int beforeState, int afterState) {
        if (afterState != this.currentMode) {
            int n = this.currentMode;
            this.cycles[n] = this.cycles[n] + (this.clock.getCount() - this.lastChange);
            this.oldMode = this.currentMode;
            this.currentMode = afterState;
            this.lastChange = this.clock.getCount();
            this.instance.stateChange(this);
        }
    }

    public double getTotalConsumedEnergy() {
        double total = 0.0;
        for (int i = 0; i < this.ampere.length; ++i) {
            total += this.getConsumedEnergy(i);
        }
        return total;
    }

    public double getConsumedEnergy(int mode) {
        return 3.0 * (double)this.getCycles(mode) * this.ampere[mode] * this.cycleTime;
    }

    public int getModeNumber() {
        return this.ampere.length;
    }

    public int getCurrentMode() {
        return this.currentMode;
    }

    public String getModeName(int mode) {
        return this.stateMachine.getStateName(mode);
    }

    public double getModeAmpere(int mode) {
        return this.ampere[mode];
    }

    public long getCycles(int mode) {
        if (this.cycles == null) {
            return 0L;
        }
        long ret = this.cycles[mode];
        if (mode == this.currentMode) {
            ret += this.clock.getCount() - this.lastChange;
        }
        return ret;
    }

    public String getName() {
        return this.deviceName;
    }

    public int getOldMode() {
        return this.oldMode;
    }

    public double getCurrentAmpere() {
        return this.ampere[this.currentMode];
    }

    public double getOldAmpere() {
        return this.ampere[this.oldMode];
    }

    public void activate() {
        this.stateMachine.insertProbe(this);
        this.cycles = new long[this.ampere.length];
        for (int i = 0; i < this.cycles.length; ++i) {
            this.cycles[i] = 0L;
        }
    }
}

