/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.clock;

import avrora.sim.Simulation;
import avrora.sim.SimulatorThread;
import cck.util.Util;

public abstract class Synchronizer {
    public abstract void addNode(Simulation.Node var1);

    public abstract void removeNode(Simulation.Node var1);

    public abstract void waitForNeighbors(long var1);

    public abstract void start();

    public abstract void join() throws InterruptedException;

    public abstract void pause();

    public abstract void stop();

    public abstract void synch(long var1);

    public static class Single
    extends Synchronizer {
        public Simulation.Node node;
        public SimulatorThread thread;

        public void addNode(Simulation.Node n) {
            if (this.node != null) {
                throw Util.failure("Only one node supported at a time");
            }
            this.node = n;
        }

        public void removeNode(Simulation.Node n) {
            if (this.node == n) {
                this.node = null;
            }
        }

        public void waitForNeighbors(long time) {
        }

        public void start() {
            if (this.node == null) {
                throw Util.failure("No nodes in simulation");
            }
            this.thread = new SimulatorThread(this.node);
            this.thread.start();
        }

        public void join() throws InterruptedException {
            this.thread.join();
        }

        public void pause() {
            throw Util.unimplemented();
        }

        public void stop() {
            throw Util.unimplemented();
        }

        public void synch(long globalTime) {
            throw Util.unimplemented();
        }
    }
}

