/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.clock;

import avrora.sim.Simulation;
import avrora.sim.Simulator;
import avrora.sim.clock.Synchronizer;
import cck.util.Util;

public class StepSynchronizer
extends Synchronizer {
    protected final Simulator.Event action;
    protected Simulator[] threads;
    protected int numThreads;
    protected boolean shouldRun;
    protected boolean innerLoop;
    protected RunThread thread;

    public StepSynchronizer(Simulator.Event e) {
        this.action = e;
        this.threads = new Simulator[8];
    }

    public void addNode(Simulation.Node n) {
        int nn;
        if ((nn = this.numThreads++) >= this.threads.length) {
            Simulator[] nthreads = new Simulator[this.threads.length * 2];
            System.arraycopy(this.threads, 0, nthreads, 0, this.threads.length);
            this.threads = nthreads;
        }
        this.threads[nn] = n.getSimulator();
    }

    public void removeNode(Simulation.Node n) {
        this.removeSimulator(n.getSimulator());
    }

    public void waitForNeighbors(long time) {
        throw Util.unimplemented();
    }

    public void start() {
        this.thread = new RunThread();
        this.thread.start();
    }

    public void join() throws InterruptedException {
        if (this.thread != null) {
            this.thread.join();
        }
    }

    public void pause() {
        if (this.thread != null) {
            this.thread.pause();
        }
    }

    public void stop() {
        if (this.thread == null) {
            return;
        }
        this.shouldRun = false;
        this.innerLoop = false;
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void reportExit(Simulator s, Throwable t) {
        throw Util.unimplemented();
    }

    void removeSimulator(Simulator s) {
        throw Util.unimplemented();
    }

    public void synch(long globalTime) {
        throw Util.unimplemented();
    }

    protected class RunThread
    extends Thread {
        protected RunThread() {
        }

        public void run() {
            StepSynchronizer.this.shouldRun = true;
            this.runLoop();
        }

        protected void runLoop() {
            int[] cycles = new int[StepSynchronizer.this.numThreads];
            while (StepSynchronizer.this.shouldRun) {
                this.fastLoop(cycles);
            }
        }

        private void fastLoop(int[] cycles) {
            StepSynchronizer.this.innerLoop = true;
            while (StepSynchronizer.this.innerLoop) {
                this.step(cycles, StepSynchronizer.this.threads);
            }
        }

        protected void step(int[] cycles, Simulator[] threads) {
            for (int cntr = 0; cntr < StepSynchronizer.this.numThreads; ++cntr) {
                int n = cntr;
                cycles[n] = cycles[n] - 1;
                int left = cycles[n];
                if (left > 0) continue;
                Simulator sim = threads[cntr];
                try {
                    cycles[cntr] = sim.step();
                    continue;
                }
                catch (Throwable t) {
                    StepSynchronizer.this.reportExit(sim, t);
                    StepSynchronizer.this.removeSimulator(threads[cntr]);
                }
            }
            if (StepSynchronizer.this.action != null) {
                StepSynchronizer.this.action.fire();
            }
        }

        public void pause() {
            throw Util.unimplemented();
        }
    }
}

