/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.clock;

import avrora.sim.Simulation;
import avrora.sim.Simulator;
import avrora.sim.SimulatorThread;
import avrora.sim.clock.MainClock;
import avrora.sim.clock.Synchronizer;
import cck.util.Util;
import java.util.HashMap;

public class RippleSynchronizer
extends Synchronizer {
    protected long notifyPeriod;
    protected final HashMap threadMap;
    protected final Simulator.Event action;
    protected int goal;
    protected long wallTime;
    protected int meet_count;
    protected int wait_count;
    protected WaitLink waitListHead;

    public RippleSynchronizer(long p, Simulator.Event a) {
        this.notifyPeriod = p;
        this.action = a;
        this.threadMap = new HashMap();
        WaitLink end = new WaitLink(Long.MAX_VALUE);
        WaitLink start = new WaitLink(-1L);
        start.numPassed = this.goal;
        start.next = end;
        this.waitListHead = start;
    }

    private WaitLink advance(long time, WaitLink link) {
        assert (time >= link.time);
        if (time == link.time) {
            return link;
        }
        WaitLink prev = link;
        link = link.next;
        while (true) {
            assert (link != null);
            if (time < link.time) {
                WaitLink nlink = new WaitLink(time);
                nlink.numPassed = link.numPassed;
                nlink.next = link;
                if (prev != null) {
                    assert (prev.next == link);
                    prev.next = nlink;
                }
                this.notifyLink(nlink);
                return nlink;
            }
            if (time == link.time) {
                this.notifyLink(link);
                return link;
            }
            this.notifyLink(link);
            prev = link;
            link = link.next;
        }
    }

    private void waitFor(long time, WaitLink link) throws InterruptedException {
        if (time <= link.time) {
            this.waitForLink(link);
            return;
        }
        WaitLink prev = link;
        link = link.next;
        while (true) {
            assert (link != null);
            if (time < link.time) {
                WaitLink nlink = this.insertLink(time, prev, link);
                this.waitForLink(nlink);
                return;
            }
            if (time == link.time) {
                this.waitForLink(link);
                return;
            }
            prev = link;
            link = link.next;
        }
    }

    private void waitForLink(WaitLink nlink) throws InterruptedException {
        assert (nlink.numPassed >= 1);
        while (nlink.numPassed < this.goal) {
            this.wait();
        }
    }

    private WaitLink insertLink(long time, WaitLink prev, WaitLink next) {
        WaitLink nlink = new WaitLink(time);
        nlink.numPassed = next.numPassed;
        nlink.next = next;
        assert (prev != null);
        assert (prev.next == next);
        prev.next = nlink;
        return nlink;
    }

    private void notifyLink(WaitLink link) {
        if (++link.numPassed >= this.goal) {
            this.notifyAll();
            this.waitListHead = link;
        }
    }

    public synchronized void start() {
        for (SimulatorThread thread : this.threadMap.keySet()) {
            thread.start();
        }
    }

    public void join() throws InterruptedException {
        for (SimulatorThread thread : this.threadMap.keySet()) {
            thread.join();
        }
    }

    public synchronized void stop() {
        for (SimulatorThread thread : this.threadMap.keySet()) {
            thread.getSimulator().stop();
        }
    }

    public synchronized void pause() {
        throw Util.unimplemented();
    }

    public synchronized void synch(long globalTime) {
        throw Util.unimplemented();
    }

    public synchronized void addNode(Simulation.Node t) {
        SimulatorThread st = t.getThread();
        if (this.threadMap.containsKey(st)) {
            return;
        }
        st.setSynchronizer(this);
        NotifyEvent event = new NotifyEvent(st);
        this.threadMap.put(st, event);
        event.clock.insertEvent(event, this.notifyPeriod);
        ++this.goal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeNode(Simulation.Node t) {
        SimulatorThread st = t.getThread();
        if (!this.threadMap.containsKey(st)) {
            return;
        }
        RippleSynchronizer rippleSynchronizer = this;
        synchronized (rippleSynchronizer) {
            --this.goal;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForNeighbors(long time) {
        SimulatorThread thread = (SimulatorThread)Thread.currentThread();
        NotifyEvent event = (NotifyEvent)this.threadMap.get(thread);
        try {
            long now = thread.getSimulator().getClock().getCount();
            assert (time <= now);
            RippleSynchronizer rippleSynchronizer = this;
            synchronized (rippleSynchronizer) {
                WaitLink link = event.currentWaitLink();
                event.lastLink = this.advance(now, link);
                this.waitFor(time, link);
            }
        }
        catch (InterruptedException e) {
            throw Util.unimplemented();
        }
    }

    private static class WaitLink {
        protected final long time;
        protected int numPassed;
        protected WaitLink next;

        WaitLink(long t) {
            this.time = t;
        }
    }

    protected class NotifyEvent
    implements Simulator.Event {
        protected final SimulatorThread thread;
        protected final MainClock clock;
        protected boolean removed;
        protected WaitLink lastLink;

        protected NotifyEvent(SimulatorThread t) {
            this.thread = t;
            this.clock = t.getSimulator().getClock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fire() {
            if (!this.removed) {
                long delta;
                long now = this.clock.getCount();
                RippleSynchronizer rippleSynchronizer = RippleSynchronizer.this;
                synchronized (rippleSynchronizer) {
                    this.lastLink = RippleSynchronizer.this.advance(now, this.currentWaitLink());
                    delta = this.lastLink.next.time - now;
                }
                if (delta < RippleSynchronizer.this.notifyPeriod) {
                    this.clock.insertEvent(this, delta);
                } else {
                    this.clock.insertEvent(this, RippleSynchronizer.this.notifyPeriod);
                }
            }
        }

        private WaitLink currentWaitLink() {
            if (this.lastLink == null) {
                return RippleSynchronizer.this.waitListHead;
            }
            return this.lastLink;
        }
    }
}

