/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.clock;

import avrora.sim.Simulator;
import avrora.sim.clock.Clock;
import cck.util.Util;

public class DerivedClock
extends Clock {
    protected final Clock driveClock;
    protected final double divider;

    public DerivedClock(String n, Clock driver, long hz) {
        super(n, hz);
        this.driveClock = driver;
        if (driver.getHZ() < hz) {
            throw Util.failure("cannot derive faster clock from slower clock");
        }
        this.divider = driver.getHZ() / hz;
    }

    public long getCount() {
        return (long)((double)this.driveClock.getCount() / this.divider);
    }

    public void insertEvent(Simulator.Event e, long delta) {
        long driverCount = this.driveClock.getCount();
        long nextTick = (long)((double)((long)((double)driverCount / this.divider) + delta) * this.divider);
        this.driveClock.insertEvent(e, nextTick - driverCount);
    }

    public void removeEvent(Simulator.Event e) {
        this.driveClock.removeEvent(e);
    }
}

