/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.clock;

import avrora.sim.Simulator;

public class DeltaQueue {
    protected Link head;
    protected Link freeLinks;
    protected EventList freeEventLists;
    protected long count;

    public void insertEvent(Simulator.Event t, long cycles) {
        if (this.head == null) {
            this.head = this.newLink(t, cycles, null);
            return;
        }
        Link prev = null;
        Link pos = this.head;
        while (pos != null && cycles > pos.delta) {
            cycles -= pos.delta;
            prev = pos;
            pos = pos.next;
        }
        if (pos == null) {
            this.insertAfter(prev, t, cycles, null);
        } else if (cycles == pos.delta) {
            pos.add(t);
        } else {
            this.insertAfter(prev, t, cycles, pos);
        }
    }

    private void insertAfter(Link prev, Simulator.Event t, long cycles, Link next) {
        if (prev != null) {
            prev.next = this.newLink(t, cycles, next);
        } else {
            this.head = this.newLink(t, cycles, next);
        }
    }

    public void removeEvent(Simulator.Event e) {
        if (this.head == null) {
            return;
        }
        Link prev = null;
        Link pos = this.head;
        while (pos != null) {
            Link next = pos.next;
            pos.remove(e);
            if (pos.events == null) {
                if (prev == null) {
                    this.head = pos.next;
                } else {
                    prev.next = pos.next;
                }
                if (pos.next != null) {
                    pos.next.delta += pos.delta;
                }
                this.free(pos);
            } else {
                prev = pos;
            }
            pos = next;
        }
    }

    public void advance(long cycles) {
        if (this.head == null) {
            this.count += cycles;
            return;
        }
        if (this.head.delta > cycles) {
            this.count += cycles;
            this.head.delta -= cycles;
            return;
        }
        this.advanceSlow(cycles);
    }

    public void skipAhead() {
        if (this.head == null) {
            ++this.count;
            return;
        }
        Link h = this.head;
        this.count += h.delta;
        this.head = h.next;
        h.fire();
        this.free(h);
    }

    private void advanceSlow(long cycles) {
        while (this.head != null && cycles > 0L) {
            Link pos = this.head;
            Link next = pos.next;
            long delta = pos.delta;
            long leftover = cycles - delta;
            if (leftover < 0L) {
                this.count += cycles;
                pos.delta = -leftover;
                return;
            }
            this.count += delta;
            this.head = next;
            pos.fire();
            this.free(pos);
            cycles = leftover;
        }
        this.count += cycles;
    }

    public long getFirstEventTime() {
        if (this.head != null) {
            return this.head.delta;
        }
        return -1L;
    }

    public long getCount() {
        return this.count;
    }

    private void free(Link l) {
        l.next = this.freeLinks;
        this.freeLinks = l;
        this.freeEventLists = l.events;
        l.events = null;
    }

    private void free(EventList l) {
        l.event = null;
        l.next = this.freeEventLists;
        this.freeEventLists = l;
    }

    private Link newLink(Simulator.Event t, long cycles, Link next) {
        Link l;
        if (this.freeLinks == null) {
            l = new Link(t, cycles);
        } else {
            l = this.freeLinks;
            this.freeLinks = this.freeLinks.next;
            l.delta = cycles;
            l.add(t);
        }
        if (next != null) {
            next.delta -= cycles;
        }
        l.next = next;
        return l;
    }

    private EventList newEventList(Simulator.Event t, EventList next) {
        EventList l;
        if (this.freeEventLists == null) {
            l = new EventList(t, next);
        } else {
            l = this.freeEventLists;
            this.freeEventLists = this.freeEventLists.next;
            l.next = next;
            l.event = t;
        }
        return l;
    }

    private class Link {
        EventList events;
        Link next;
        long delta;

        Link(Simulator.Event t, long d) {
            this.events = DeltaQueue.this.newEventList(t, null);
            this.delta = d;
        }

        void add(Simulator.Event t) {
            this.events = DeltaQueue.this.newEventList(t, this.events);
        }

        void remove(Simulator.Event t) {
            EventList prev = null;
            EventList pos = this.events;
            while (pos != null) {
                EventList next = pos.next;
                if (pos.event == t) {
                    if (prev == null) {
                        this.events = pos.next;
                    } else {
                        prev.next = pos.next;
                    }
                    DeltaQueue.this.free(pos);
                } else {
                    prev = pos;
                }
                pos = next;
            }
        }

        void fire() {
            EventList pos = this.events;
            while (pos != null) {
                pos.event.fire();
                pos = pos.next;
            }
        }
    }

    private static class EventList {
        Simulator.Event event;
        EventList next;

        EventList(Simulator.Event t, EventList n) {
            this.event = t;
            this.next = n;
        }
    }
}

