/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.clock;

import avrora.sim.Simulator;
import avrora.sim.clock.Clock;

public class ClockPrescaler
extends Clock {
    protected final Clock driveClock;
    protected final int divider;
    protected long base;
    protected long ticksBeforeBase;

    public ClockPrescaler(String n, Clock drive, int divider) {
        super(n, drive.getHZ() / (long)divider);
        this.driveClock = drive;
        this.divider = divider;
    }

    public long getCount() {
        return (this.driveClock.getCount() - this.base) / (long)this.divider;
    }

    public long getTotalCount() {
        return this.getCount() + this.ticksBeforeBase;
    }

    public void insertEvent(Simulator.Event e, long delta) {
        long driverCount = this.driveClock.getCount() - this.base;
        long nextTick = (driverCount / (long)this.divider + 1L) * (long)this.divider;
        this.driveClock.insertEvent(e, nextTick - driverCount);
    }

    public void removeEvent(Simulator.Event e) {
        this.driveClock.removeEvent(e);
    }

    public void reset() {
        long newbase = this.driveClock.getCount();
        long diff = newbase - this.base;
        this.ticksBeforeBase += diff / (long)this.divider;
        this.base = newbase;
    }
}

