/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.clock;

import avrora.sim.clock.Clock;
import avrora.sim.clock.DerivedClock;
import avrora.sim.clock.MainClock;
import cck.text.StringUtil;
import java.util.HashMap;
import java.util.NoSuchElementException;

public class ClockDomain {
    protected final HashMap clockMap = new HashMap();
    protected final MainClock mainClock;

    public ClockDomain(long mainHz) {
        this.mainClock = new MainClock("main", mainHz);
        this.clockMap.put("main", this.mainClock);
    }

    public MainClock getMainClock() {
        return this.mainClock;
    }

    public Clock getClock(String name) {
        Clock clock = (Clock)this.clockMap.get(name);
        if (clock == null) {
            throw new NoSuchElementException(StringUtil.quote(name) + " clock not found");
        }
        return clock;
    }

    public void addClock(Clock c) {
        this.clockMap.put(c.getName(), c);
    }

    public Clock newClock(String name, long hz) {
        if (hz == this.mainClock.getHZ()) {
            this.clockMap.put(name, this.mainClock);
            return this.mainClock;
        }
        DerivedClock c = new DerivedClock(name, this.mainClock, hz);
        this.addClock(c);
        return c;
    }

    public boolean hasClock(String name) {
        return this.clockMap.get(name) != null;
    }
}

