/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.clock;

import avrora.sim.Simulator;

public abstract class Clock {
    protected final long hz;
    protected final String name;

    protected Clock(String n, long hz) {
        this.hz = hz;
        this.name = n;
    }

    public long getHZ() {
        return this.hz;
    }

    public String getName() {
        return this.name;
    }

    public abstract long getCount();

    public abstract void insertEvent(Simulator.Event var1, long var2);

    public abstract void removeEvent(Simulator.Event var1);

    public long millisToCycles(double ms) {
        return (long)(ms * (double)this.hz / 1000.0);
    }

    public double cyclesToMillis(long cycles) {
        return 1000.0 * (double)cycles / (double)this.hz;
    }
}

