/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim.clock;

import avrora.sim.Simulation;
import avrora.sim.Simulator;
import avrora.sim.SimulatorThread;
import avrora.sim.clock.MainClock;
import avrora.sim.clock.Synchronizer;
import cck.util.Util;
import java.util.HashMap;

public class BarrierSynchronizer
extends Synchronizer {
    protected long period;
    protected final HashMap threadMap;
    protected final Simulator.Event action;
    protected final Object condition;
    protected int goal;
    protected int meet_count;
    protected int wait_count;
    protected WaitSlot waitSlotList;

    public BarrierSynchronizer(long p, Simulator.Event a) {
        this.period = p;
        this.action = a;
        this.threadMap = new HashMap();
        this.condition = new Object();
    }

    protected boolean signalOthers() {
        this.checkWaiters();
        if (this.meet_count < this.goal) {
            return false;
        }
        this.meet_count = 0;
        this.wait_count = 0;
        this.action.fire();
        this.condition.notifyAll();
        return true;
    }

    public synchronized void start() {
        for (SimulatorThread thread : this.threadMap.keySet()) {
            thread.start();
        }
    }

    public void join() throws InterruptedException {
        for (SimulatorThread thread : this.threadMap.keySet()) {
            thread.join();
        }
    }

    public synchronized void stop() {
        for (SimulatorThread thread : this.threadMap.keySet()) {
            thread.getSimulator().stop();
        }
    }

    public synchronized void pause() {
        throw Util.unimplemented();
    }

    public synchronized void synch(long globalTime) {
        throw Util.unimplemented();
    }

    public synchronized void addNode(Simulation.Node t) {
        SimulatorThread st = t.getThread();
        if (this.threadMap.containsKey(st)) {
            return;
        }
        st.setSynchronizer(this);
        SynchEvent event = new SynchEvent(st);
        this.threadMap.put(st, event);
        event.clock.insertEvent(event, this.period);
        ++this.goal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeNode(Simulation.Node t) {
        SimulatorThread st = t.getThread();
        if (!this.threadMap.containsKey(st)) {
            return;
        }
        Object object = this.condition;
        synchronized (object) {
            SynchEvent e = (SynchEvent)this.threadMap.get(st);
            e.removed = true;
            if (e.met) {
                --this.meet_count;
            }
            if (this.stillWaiting(e.waitSlot)) {
                --e.waitSlot.numWaiters;
                --this.wait_count;
            }
            this.threadMap.remove(e);
            --this.goal;
            this.signalOthers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForNeighbors(long time) {
        WaitSlot w;
        SimulatorThread thread = (SimulatorThread)Thread.currentThread();
        SynchEvent event = (SynchEvent)this.threadMap.get(thread);
        if (event == null) {
            return;
        }
        Object object = this.condition;
        synchronized (object) {
            w = this.insertWaiter(event, time);
            WaitSlot h = this.checkWaiters();
            if (w == h) {
                return;
            }
        }
        try {
            object = w;
            synchronized (object) {
                if (w.shouldWait) {
                    w.wait();
                }
            }
        }
        catch (InterruptedException e) {
            throw Util.unexpected(e);
        }
    }

    protected WaitSlot insertWaiter(SynchEvent event, long time) {
        WaitSlot w = this.getWaitSlot(time);
        ++this.wait_count;
        event.waitSlot = w;
        ++w.numWaiters;
        return w;
    }

    private WaitSlot getWaitSlot(long time) {
        WaitSlot prev = this.waitSlotList;
        WaitSlot slot = this.waitSlotList;
        while (slot != null && slot.time <= time) {
            if (slot.time == time) {
                return slot;
            }
            prev = slot;
            slot = slot.next;
        }
        return this.insertAfter(prev, new WaitSlot(time));
    }

    private WaitSlot insertAfter(WaitSlot prev, WaitSlot w) {
        if (prev != null) {
            w.next = prev.next;
            prev.next = w;
        } else {
            this.waitSlotList = w;
        }
        return w;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WaitSlot checkWaiters() {
        if (this.wait_count + this.meet_count < this.goal) {
            return null;
        }
        if (this.waitSlotList == null) {
            return null;
        }
        WaitSlot h = this.waitSlotList;
        this.waitSlotList = h.next;
        WaitSlot waitSlot = h;
        synchronized (waitSlot) {
            h.shouldWait = false;
            h.notifyAll();
        }
        this.wait_count -= h.numWaiters;
        return h;
    }

    protected boolean stillWaiting(WaitSlot w) {
        if (w == null) {
            return false;
        }
        WaitSlot h = this.waitSlotList;
        while (h != null) {
            if (h == w) {
                return true;
            }
            h = h.next;
        }
        return false;
    }

    static class WaitSlot {
        final long time;
        int numWaiters;
        WaitSlot next;
        boolean shouldWait = true;

        WaitSlot(long t) {
            this.time = t;
        }
    }

    protected class SynchEvent
    implements Simulator.Event {
        protected final SimulatorThread thread;
        protected final MainClock clock;
        protected boolean removed;
        protected boolean met;
        protected WaitSlot waitSlot;

        protected SynchEvent(SimulatorThread t) {
            this.thread = t;
            this.clock = t.getSimulator().getClock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fire() {
            try {
                Object object = BarrierSynchronizer.this.condition;
                synchronized (object) {
                    if (this.removed) {
                        return;
                    }
                    this.met = true;
                    ++BarrierSynchronizer.this.meet_count;
                    if (!BarrierSynchronizer.this.signalOthers()) {
                        BarrierSynchronizer.this.condition.wait();
                    }
                    this.met = false;
                }
                if (this.removed) {
                    return;
                }
                this.clock.insertEvent(this, BarrierSynchronizer.this.period);
            }
            catch (InterruptedException e) {
                throw Util.unexpected(e);
            }
        }
    }
}

