/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim;

import avrora.actions.SimAction;
import avrora.sim.Simulation;
import avrora.sim.Simulator;
import avrora.sim.clock.Synchronizer;
import cck.text.StringUtil;
import cck.text.Terminal;
import cck.util.Util;

public class SimulatorThread
extends Thread {
    protected final Simulation.Node node;
    protected Synchronizer synchronizer;

    public SimulatorThread(Simulation.Node n) {
        super("node-" + n.id);
        this.node = n;
    }

    public Simulation.Node getNode() {
        return this.node;
    }

    public Simulator getSimulator() {
        return this.node.getSimulator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Simulator simulator = this.node.getSimulator();
            simulator.start();
        }
        catch (SimAction.TimeoutException te) {
        }
        catch (SimAction.BreakPointException e) {
            Terminal.printYellow("Simulation terminated");
            Terminal.println(": breakpoint at " + StringUtil.addrToString(e.address) + " reached.");
        }
        catch (Util.Error e) {
            e.report();
        }
        finally {
            if (this.synchronizer != null) {
                this.synchronizer.removeNode(this.node);
            }
        }
    }

    public void setSynchronizer(Synchronizer s) {
        this.synchronizer = s;
    }
}

