/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim;

import avrora.core.Program;
import avrora.sim.Interpreter;
import avrora.sim.InterpreterFactory;
import avrora.sim.State;
import avrora.sim.clock.MainClock;
import avrora.sim.mcu.Microcontroller;
import avrora.sim.output.EventBuffer;

public class Simulator {
    protected final Program program;
    protected final Microcontroller microcontroller;
    protected Interpreter interpreter;
    protected MainClock clock;
    protected final int id;
    protected EventBuffer events;

    public Simulator(int i, InterpreterFactory f, Microcontroller mcu, Program p) {
        this.id = i;
        this.microcontroller = mcu;
        this.program = p;
        this.clock = mcu.getClockDomain().getMainClock();
        this.interpreter = f.newInterpreter(this, this.program, this.microcontroller.getProperties());
        this.events = new EventBuffer(this, 16, EventBuffer.WRAPAROUND);
    }

    public Microcontroller getMicrocontroller() {
        return this.microcontroller;
    }

    public Program getProgram() {
        return this.program;
    }

    public MainClock getClock() {
        return this.clock;
    }

    public EventBuffer getEventBuffer() {
        return this.events;
    }

    public int getID() {
        return this.id;
    }

    public Interpreter getInterpreter() {
        return this.interpreter;
    }

    public State getState() {
        return this.interpreter.getState();
    }

    public void start() {
        this.interpreter.start();
    }

    public int step() {
        return this.interpreter.step();
    }

    public void stop() {
        this.interpreter.stop();
    }

    public void insertProbe(Probe p) {
        this.interpreter.insertProbe(p);
    }

    public void insertProbe(Probe p, int addr) {
        this.interpreter.insertProbe(p, addr);
    }

    public void removeProbe(Probe b) {
        this.interpreter.removeProbe(b);
    }

    public void removeProbe(Probe p, int addr) {
        this.interpreter.removeProbe(p, addr);
    }

    public void insertWatch(Watch p, int data_addr) {
        this.interpreter.insertWatch(p, data_addr);
    }

    public void removeWatch(Watch p, int data_addr) {
        this.interpreter.removeWatch(p, data_addr);
    }

    public void forceInterrupt(int num) {
        this.interpreter.getInterruptTable().force(num);
    }

    public void insertEvent(Event e, long cycles) {
        this.clock.insertEvent(e, cycles);
    }

    public void removeEvent(Event e) {
        this.clock.removeEvent(e);
    }

    public void insertErrorWatch(Watch watch) {
        this.interpreter.insertErrorWatch(watch);
    }

    public void delay(long cycles) {
        this.interpreter.delay(cycles);
    }

    public static interface Watch {
        public void fireBeforeRead(State var1, int var2);

        public void fireBeforeWrite(State var1, int var2, byte var3);

        public void fireAfterRead(State var1, int var2, byte var3);

        public void fireAfterWrite(State var1, int var2, byte var3);

        public static class Empty
        implements Watch {
            public void fireBeforeRead(State state, int data_addr) {
            }

            public void fireBeforeWrite(State state, int data_addr, byte value) {
            }

            public void fireAfterRead(State state, int data_addr, byte value) {
            }

            public void fireAfterWrite(State state, int data_addr, byte value) {
            }
        }
    }

    public static interface Event {
        public void fire();
    }

    public static interface InterruptProbe {
        public void fireBeforeInvoke(State var1, int var2);

        public void fireAfterInvoke(State var1, int var2);

        public void fireWhenDisabled(State var1, int var2);

        public void fireWhenEnabled(State var1, int var2);

        public void fireWhenPosted(State var1, int var2);

        public void fireWhenUnposted(State var1, int var2);

        public static class Empty
        implements InterruptProbe {
            public void fireBeforeInvoke(State s, int inum) {
            }

            public void fireAfterInvoke(State s, int inum) {
            }

            public void fireWhenDisabled(State s, int inum) {
            }

            public void fireWhenEnabled(State s, int inum) {
            }

            public void fireWhenPosted(State s, int inum) {
            }

            public void fireWhenUnposted(State s, int inum) {
            }
        }
    }

    public static interface Probe {
        public void fireBefore(State var1, int var2);

        public void fireAfter(State var1, int var2);

        public static class Empty
        implements Probe {
            public void fireBefore(State state, int pc) {
            }

            public void fireAfter(State state, int pc) {
            }
        }
    }
}

