/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim;

import avrora.Defaults;
import avrora.core.LoadableProgram;
import avrora.monitors.MonitorFactory;
import avrora.sim.Simulator;
import avrora.sim.SimulatorThread;
import avrora.sim.clock.Synchronizer;
import avrora.sim.mcu.AtmelMicrocontroller;
import avrora.sim.mcu.EEPROM;
import avrora.sim.mcu.MicrocontrollerFactory;
import avrora.sim.platform.DefaultPlatform;
import avrora.sim.platform.Platform;
import avrora.sim.platform.PlatformFactory;
import avrora.sim.util.ClockCycleTimeout;
import avrora.sim.util.InterruptScheduler;
import cck.help.HelpCategory;
import cck.util.Option;
import cck.util.Options;
import cck.util.Util;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;

public abstract class Simulation
extends HelpCategory {
    public final Option.Str PLATFORM = this.newOption("platform", "", "This option selects the platform on which the microcontroller is built, including the external devices such as LEDs and radio. If the platform option is not set, the default platform is the microcontroller specified in the \"mcu\" option, with no external devices.");
    public final Option.Long CLOCKSPEED = this.newOption("clockspeed", 8000000L, "This option specifies the clockspeed of the microcontroller when the platform is not specified. The speed is given in cycles per second, i.e. hertz.");
    public final Option.Long EXTCLOCKSPEED = this.newOption("external-clockspeed", 0L, "This option specifies the clockspeed of the external clock supplied to the microcontroller when the platform is not specified. The speed is given in cycles per second, i.e. hertz. When this option is set to zero, the external clock is the same speed as the main clock.");
    public final Option.Str MCU = this.newOption("mcu", "atmega128", "This option selects the microcontroller from a library of supported microcontroller models.");
    public final Option.Long RANDOMSEED = this.newOption("random-seed", 0L, "This option is used to seed a pseudo-random number generator used in the simulation. If this option is set to non-zero, then its value is used as the seed for reproducible simulation results. If this option is not set, those parts of simulation that rely on random numbers will have seeds chosen based on system parameters that vary from run to run.");
    public final Option.Double SECONDS = this.newOption("seconds", 0.0, "This option is used to terminate the simulation after the specified number of simulated seconds have passed.");
    public final Option.List MONITORS = this.newOptionList("monitors", "", "This option specifies a list of monitors to be attached to the program. Monitors collect information about the execution of the program while it is running such as profiling data or timing information.");
    public final Option.Str SCHEDULE = this.newOption("interrupt-schedule", "", "This option, when specified, contains the name of a file that contains an interrupt schedule that describes when to post interrupts (especially external interrupts) to the program. This is useful for testing programs under different interrupt loads. For multi-node simulations, the interrupt schedule is only applied to node 0.");
    public final Option.Str EELOADIMAGE = this.newOption("eeprom-load-image", "", "This option specifies a (binary) image file to load into EEPROM before starting the simulation.");
    protected int num_nodes;
    protected Node[] nodes = new Node[16];
    protected boolean running;
    protected boolean paused;
    protected Random random;
    protected LinkedList monitorFactoryList;
    protected Synchronizer synchronizer;

    protected Simulation(String str, String h, Synchronizer s) {
        super(str, h);
        this.synchronizer = s;
        this.monitorFactoryList = new LinkedList();
    }

    public abstract void process(Options var1, String[] var2) throws Exception;

    public synchronized Node createNode(PlatformFactory pf, LoadableProgram pp) {
        if (this.running) {
            return null;
        }
        int id = this.num_nodes++;
        Node n = this.newNode(id, pf, pp);
        if (id >= this.nodes.length) {
            this.grow();
        }
        this.nodes[id] = n;
        return n;
    }

    protected Node newNode(int id, PlatformFactory pf, LoadableProgram pp) {
        return new Node(id, pf, pp);
    }

    public int getNumberOfNodes() {
        return this.num_nodes;
    }

    public Random getRandom() {
        if (this.random == null) {
            long seed = this.RANDOMSEED.get();
            this.random = seed != 0L ? new Random(seed) : new Random();
        }
        return this.random;
    }

    private void grow() {
        Node[] nnodes = new Node[this.nodes.length * 2];
        System.arraycopy(this.nodes, 0, nnodes, 0, this.nodes.length);
        this.nodes = nnodes;
    }

    public synchronized Node getNode(int node_id) {
        if (node_id >= this.nodes.length) {
            return null;
        }
        return this.nodes[node_id];
    }

    public synchronized void removeNode(int node_id) {
        if (this.running) {
            return;
        }
        if (this.nodes[node_id] != null) {
            Node node = this.nodes[node_id];
            this.nodes[node_id] = null;
            --this.num_nodes;
            this.synchronizer.removeNode(node);
            node.remove();
        }
    }

    public synchronized void start() {
        if (this.running) {
            return;
        }
        this.instantiateNodes();
        this.synchronizer.start();
        this.running = true;
    }

    protected void instantiateNodes() {
        for (int cntr = 0; cntr < this.nodes.length; ++cntr) {
            Node n = this.nodes[cntr];
            if (n == null) continue;
            n.instantiate();
            n.addMonitors();
        }
    }

    public synchronized void pause() {
        if (!this.running) {
            return;
        }
        this.synchronizer.pause();
        this.paused = true;
    }

    public synchronized void resume() {
        if (!this.running) {
            return;
        }
        throw Util.unimplemented();
    }

    public synchronized void stop() {
        if (!this.running) {
            return;
        }
        this.synchronizer.stop();
        this.paused = false;
        this.running = false;
    }

    public synchronized void join() throws InterruptedException {
        this.synchronizer.join();
    }

    public synchronized void stopNode(int id) {
        if (!this.running) {
            return;
        }
        throw Util.unimplemented();
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isRunning() {
        return this.running;
    }

    public Iterator getNodeIterator() {
        return new Iter();
    }

    protected PlatformFactory getPlatform() {
        if (this.PLATFORM.isBlank()) {
            long hz = this.CLOCKSPEED.get();
            long exthz = this.EXTCLOCKSPEED.get();
            if (exthz == 0L) {
                exthz = hz;
            }
            if (exthz > hz) {
                Util.userError("External clock is greater than main clock speed", exthz + "hz");
            }
            MicrocontrollerFactory mcf = Defaults.getMicrocontroller(this.MCU.get());
            return new DefaultPlatform.Factory(hz, exthz, mcf);
        }
        String pfs = this.PLATFORM.get();
        return Defaults.getPlatform(pfs);
    }

    protected void processMonitorList() {
        List l = this.MONITORS.get();
        for (String clname : l) {
            MonitorFactory mf = Defaults.getMonitor(clname);
            mf.processOptions(this.options);
            this.monitorFactoryList.addLast(mf);
        }
    }

    class Iter
    implements Iterator {
        int cursor;

        Iter() {
            this.scan();
        }

        public boolean hasNext() {
            return this.cursor < Simulation.this.nodes.length;
        }

        public Object next() {
            if (this.cursor >= Simulation.this.nodes.length) {
                throw new NoSuchElementException();
            }
            Node o = Simulation.this.nodes[this.cursor];
            ++this.cursor;
            this.scan();
            return o;
        }

        private void scan() {
            while (this.cursor < Simulation.this.nodes.length) {
                if (Simulation.this.nodes[this.cursor] != null) {
                    return;
                }
                ++this.cursor;
            }
        }

        public void remove() {
            throw Util.unimplemented();
        }
    }

    public class Node {
        public final int id;
        protected final LoadableProgram path;
        protected final PlatformFactory platformFactory;
        protected final LinkedList monitors;
        protected Platform platform;
        protected Simulator simulator;
        protected SimulatorThread thread;

        protected Node(int id, PlatformFactory pf, LoadableProgram p) {
            this.id = id;
            this.platformFactory = pf;
            this.path = p;
            this.monitors = new LinkedList();
        }

        protected void instantiate() {
            this.platform = this.platformFactory.newPlatform(this.id, this.path.getProgram());
            this.simulator = this.platform.getMicrocontroller().getSimulator();
            this.processTimeout();
            this.processInterruptSched();
            this.processEepromLoad();
            Simulation.this.synchronizer.addNode(this);
        }

        protected void addMonitors() {
            for (MonitorFactory f : Simulation.this.monitorFactoryList) {
                avrora.monitors.Monitor m = f.newMonitor(this.simulator);
                if (m == null) continue;
                this.monitors.add(m);
            }
            for (Object o : this.monitors) {
                if (!(o instanceof Monitor)) continue;
                Monitor mon = (Monitor)o;
                mon.construct(Simulation.this, this, this.simulator);
            }
        }

        private void processTimeout() {
            double secs = Simulation.this.SECONDS.get();
            if (secs > 0.0) {
                long cycles = (long)(secs * (double)this.simulator.getClock().getHZ());
                this.simulator.insertEvent(new ClockCycleTimeout(this.simulator, cycles), cycles);
            }
        }

        private void processInterruptSched() {
            if (this.id != 0) {
                return;
            }
            if (!Simulation.this.SCHEDULE.isBlank()) {
                InterruptScheduler interruptScheduler = new InterruptScheduler(Simulation.this.SCHEDULE.get(), this.simulator);
            }
        }

        private void processEepromLoad() {
            if (!Simulation.this.EELOADIMAGE.isBlank()) {
                byte[] image;
                AtmelMicrocontroller mcu = (AtmelMicrocontroller)this.platform.getMicrocontroller();
                EEPROM eeprom = (EEPROM)mcu.getDevice("eeprom");
                try {
                    FileInputStream f = new FileInputStream(Simulation.this.EELOADIMAGE.get());
                    if (f.available() > eeprom.getSize()) {
                        f.close();
                        Util.userError("EEPROM image too large", Simulation.this.EELOADIMAGE.get());
                    }
                    image = new byte[f.available()];
                    f.read(image);
                    f.close();
                }
                catch (IOException e) {
                    throw Util.unexpected(e);
                }
                eeprom.setContent(image);
            }
        }

        public Simulator getSimulator() {
            return this.simulator;
        }

        public Simulation getSimulation() {
            return Simulation.this;
        }

        public void addMonitor(Monitor f) {
            this.monitors.add(f);
        }

        public void removeMonitor(Monitor f) {
            this.monitors.remove(f);
        }

        public List getMonitors() {
            return this.monitors;
        }

        public LoadableProgram getProgram() {
            return this.path;
        }

        protected void remove() {
            for (Monitor f : this.monitors) {
                f.destruct(Simulation.this, this, this.simulator);
            }
        }

        public SimulatorThread getThread() {
            return this.thread;
        }
    }

    public static interface Monitor {
        public void attach(Simulation var1, List var2);

        public void construct(Simulation var1, Node var2, Simulator var3);

        public void destruct(Simulation var1, Node var2, Simulator var3);

        public void remove(Simulation var1, List var2);
    }
}

