/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim;

import avrora.sim.Simulator;
import avrora.sim.State;
import avrora.sim.util.MulticastWatch;
import cck.text.StringUtil;
import cck.util.Util;
import java.util.Arrays;

public class Segment {
    public final int length;
    protected final State state;
    public final String name;
    public final byte value;
    protected byte[] segment_data;
    protected MulticastWatch[] segment_watches;
    protected MulticastWatch error_watch;
    protected Sharer sharer;

    public Segment(String name, int size, byte defvalue, State st) {
        this.name = name;
        this.length = size;
        this.value = defvalue;
        this.segment_data = new byte[size];
        this.state = st;
        if (defvalue != 0) {
            Arrays.fill(this.segment_data, defvalue);
        }
    }

    public byte[] share(Sharer s) {
        this.sharer = s;
        return this.segment_data;
    }

    public byte read(int address) {
        if (this.segment_watches == null) {
            return this.checked_read(address);
        }
        MulticastWatch p = this.segment_watches[address];
        if (p == null) {
            return this.checked_read(address);
        }
        p.fireBeforeRead(this.state, address);
        byte val = this.checked_read(address);
        p.fireAfterRead(this.state, address, val);
        return val;
    }

    private byte checked_read(int address) {
        try {
            return this.direct_read(address);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (this.error_watch != null) {
                this.error_watch.fireBeforeRead(this.state, address);
            }
            return this.value;
        }
    }

    protected byte direct_read(int address) {
        return this.segment_data[address];
    }

    public byte get(int address) {
        try {
            return this.direct_read(address);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new AddressOutOfBoundsException(address);
        }
    }

    public void write(int address, byte val) {
        if (this.segment_watches == null) {
            this.checked_write(address, val);
            return;
        }
        MulticastWatch p = this.segment_watches[address];
        if (p == null) {
            this.checked_write(address, val);
            return;
        }
        p.fireBeforeWrite(this.state, address, val);
        this.checked_write(address, val);
        p.fireAfterWrite(this.state, address, val);
    }

    private void checked_write(int address, byte val) {
        block2: {
            try {
                this.direct_write(address, val);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (this.error_watch == null) break block2;
                this.error_watch.fireBeforeWrite(this.state, address, val);
            }
        }
    }

    protected void direct_write(int address, byte val) {
        this.segment_data[address] = val;
    }

    public void set(int address, byte val) {
        try {
            this.direct_write(address, val);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new AddressOutOfBoundsException(address);
        }
    }

    public void insertWatch(int data_addr, Simulator.Watch p) {
        MulticastWatch mcw;
        if (this.segment_watches == null) {
            this.segment_watches = new MulticastWatch[this.length];
        }
        if ((mcw = this.segment_watches[data_addr]) == null) {
            mcw = this.segment_watches[data_addr] = new MulticastWatch();
        }
        mcw.add(p);
    }

    public void insertErrorWatch(Simulator.Watch p) {
        if (this.error_watch == null) {
            this.error_watch = new MulticastWatch();
        }
        this.error_watch.add(p);
    }

    public void removeWatch(int data_addr, Simulator.Watch p) {
        if (this.segment_watches == null) {
            return;
        }
        MulticastWatch w = this.segment_watches[data_addr];
        if (w == null) {
            return;
        }
        w.remove(p);
    }

    public class AddressOutOfBoundsException
    extends Util.Error {
        public final int data_addr;

        protected AddressOutOfBoundsException(int da) {
            super("Segment access error", "illegal access of " + StringUtil.quote(Segment.this.name) + " at " + StringUtil.addrToString(da));
            this.data_addr = da;
        }
    }

    public static interface Sharer {
        public void update(byte[] var1);
    }
}

