/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim;

import avrora.sim.Interpreter;
import avrora.sim.Simulator;
import avrora.sim.State;
import avrora.sim.util.MulticastInterruptProbe;
import cck.util.Arithmetic;

public class InterruptTable {
    protected final int numInterrupts;
    protected long posted;
    protected long pending;
    protected long enabled;
    protected MulticastInterruptProbe globalProbe;
    protected final MulticastInterruptProbe[] probes;
    protected final Notification[] notify;
    protected final Interpreter interpreter;
    protected final State state;

    public InterruptTable(Interpreter interp, int numInterrupts) {
        this.interpreter = interp;
        this.probes = new MulticastInterruptProbe[numInterrupts];
        this.notify = new Notification[numInterrupts];
        this.state = this.interpreter.getState();
        this.numInterrupts = numInterrupts;
    }

    public void post(int inum) {
        this.interpreter.innerLoop = false;
        this.posted = Arithmetic.setBit(this.posted, inum, true);
        this.pending = this.posted & this.enabled;
        MulticastInterruptProbe probe = this.probes[inum];
        if (this.globalProbe != null) {
            this.globalProbe.fireWhenPosted(this.state, inum);
        }
        if (probe != null) {
            probe.fireWhenPosted(this.state, inum);
        }
    }

    void force(int inum) {
        this.post(inum);
        Notification n = this.notify[inum];
        if (n != null) {
            n.force(inum);
        }
    }

    public void unpost(int inum) {
        this.posted = Arithmetic.setBit(this.posted, inum, false);
        this.pending = this.posted & this.enabled;
        MulticastInterruptProbe probe = this.probes[inum];
        if (this.globalProbe != null) {
            this.globalProbe.fireWhenUnposted(this.state, inum);
        }
        if (probe != null) {
            probe.fireWhenUnposted(this.state, inum);
        }
    }

    void enable(int inum) {
        this.enabled = Arithmetic.setBit(this.enabled, inum, true);
        this.pending = this.posted & this.enabled;
        MulticastInterruptProbe probe = this.probes[inum];
        if (this.globalProbe != null) {
            this.globalProbe.fireWhenEnabled(this.state, inum);
        }
        if (probe != null) {
            probe.fireWhenEnabled(this.state, inum);
        }
    }

    public void disable(int inum) {
        this.enabled = Arithmetic.setBit(this.enabled, inum, false);
        this.pending = this.posted & this.enabled;
        MulticastInterruptProbe probe = this.probes[inum];
        if (this.globalProbe != null) {
            this.globalProbe.fireWhenDisabled(this.state, inum);
        }
        if (probe != null) {
            probe.fireWhenDisabled(this.state, inum);
        }
    }

    public void enableAll() {
        if (this.globalProbe != null) {
            this.globalProbe.fireWhenEnabled(this.state, 0);
        }
    }

    public void disableAll() {
        if (this.globalProbe != null) {
            this.globalProbe.fireWhenDisabled(this.state, 0);
        }
    }

    public void beforeInvoke(int inum) {
        Notification n;
        MulticastInterruptProbe probe = this.probes[inum];
        if (this.globalProbe != null) {
            this.globalProbe.fireBeforeInvoke(this.state, inum);
        }
        if (probe != null) {
            probe.fireBeforeInvoke(this.state, inum);
        }
        if ((n = this.notify[inum]) != null) {
            n.invoke(inum);
        }
    }

    public void afterInvoke(int inum) {
        MulticastInterruptProbe probe = this.probes[inum];
        if (this.globalProbe != null) {
            this.globalProbe.fireAfterInvoke(this.state, inum);
        }
        if (probe != null) {
            probe.fireAfterInvoke(this.state, inum);
        }
    }

    public void registerInternalNotification(Notification n, int inum) {
        this.notify[inum] = n;
    }

    public long getPostedInterrupts() {
        return this.posted;
    }

    public long getPendingInterrupts() {
        return this.pending;
    }

    public long getEnabledInterrupts() {
        return this.enabled;
    }

    public boolean isPosted(int inum) {
        return Arithmetic.getBit(this.posted, inum);
    }

    public boolean isPending(int inum) {
        return Arithmetic.getBit(this.pending, inum);
    }

    public boolean isEnabled(int inum) {
        return Arithmetic.getBit(this.enabled, inum);
    }

    public void insertProbe(Simulator.InterruptProbe p, int inum) {
        MulticastInterruptProbe mp = this.probes[inum];
        if (mp == null) {
            this.probes[inum] = mp = new MulticastInterruptProbe();
        }
        mp.add(p);
    }

    public void removeProbe(Simulator.InterruptProbe p, int inum) {
        MulticastInterruptProbe mp = this.probes[inum];
        if (mp != null) {
            mp.remove(p);
        }
    }

    public void insertProbe(Simulator.InterruptProbe p) {
        if (this.globalProbe == null) {
            this.globalProbe = new MulticastInterruptProbe();
        }
        this.globalProbe.add(p);
    }

    public void removeProbe(Simulator.InterruptProbe p) {
        if (this.globalProbe != null) {
            this.globalProbe.remove(p);
        }
    }

    public int getNumberOfInterrupts() {
        return this.numInterrupts;
    }

    public static interface Notification {
        public void force(int var1);

        public void invoke(int var1);
    }
}

