/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim;

import cck.text.StringUtil;
import cck.util.Util;

public class InterpreterError {

    public static class AddressOutOfBoundsException
    extends Util.Error {
        public final String segment;
        public final int data_addr;
        public final int badPc;

        protected AddressOutOfBoundsException(String s, int pc, int da) {
            super("Program error", "at pc = " + StringUtil.addrToString(pc) + ", illegal access of " + StringUtil.quote(s) + " at " + StringUtil.addrToString(da));
            this.data_addr = da;
            this.segment = s;
            this.badPc = pc;
        }
    }

    public static class PCAlignmentException
    extends Util.Error {
        public final int badPc;

        protected PCAlignmentException(int pc) {
            super("Program error", "PC misaligned at " + StringUtil.addrToString(pc));
            this.badPc = pc;
        }
    }

    public static class PCOutOfBoundsException
    extends Util.Error {
        public final int badPc;

        protected PCOutOfBoundsException(int pc) {
            super("Program error", "PC out of bounds at " + StringUtil.addrToString(pc));
            this.badPc = pc;
        }
    }

    public static class NoSuchInstructionException
    extends Util.Error {
        public final int badPc;

        protected NoSuchInstructionException(int pc) {
            super("Program error", "attempt to execute non-existant instruction at " + StringUtil.addrToString(pc));
            this.badPc = pc;
        }
    }
}

