/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim;

import avrora.sim.InterruptTable;
import avrora.sim.Simulator;
import avrora.sim.State;
import avrora.sim.clock.MainClock;

public abstract class Interpreter {
    protected boolean innerLoop;
    protected final Simulator simulator;
    protected final MainClock clock;
    protected InterruptTable interrupts;

    public abstract void start();

    public abstract int step();

    public abstract void stop();

    public Simulator getSimulator() {
        return this.simulator;
    }

    public MainClock getMainClock() {
        return this.clock;
    }

    public abstract State getState();

    protected Interpreter(Simulator sim) {
        this.simulator = sim;
        this.clock = sim.clock;
    }

    public InterruptTable getInterruptTable() {
        return this.interrupts;
    }

    protected abstract void insertProbe(Simulator.Probe var1, int var2);

    protected abstract void insertErrorWatch(Simulator.Watch var1);

    protected abstract void insertProbe(Simulator.Probe var1);

    protected abstract void removeProbe(Simulator.Probe var1, int var2);

    public abstract void removeProbe(Simulator.Probe var1);

    protected abstract void insertWatch(Simulator.Watch var1, int var2);

    protected abstract void removeWatch(Simulator.Watch var1, int var2);

    protected abstract void delay(long var1);
}

