/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim;

import avrora.sim.Simulator;
import avrora.sim.clock.Clock;
import avrora.sim.util.MulticastFSMProbe;
import cck.util.Util;

public class FiniteStateMachine {
    public static final int IN_TRANSITION = -1;
    protected final int numStates;
    protected final int startState;
    protected final Clock clock;
    protected final TransitionEvent transEvent = new TransitionEvent();
    protected final MulticastFSMProbe globalProbe = new MulticastFSMProbe();
    protected State[] states;
    protected int curState;

    private static void fireBefore(MulticastFSMProbe p, int oldState, int newState) {
        if (!p.isEmpty()) {
            p.fireBeforeTransition(oldState, newState);
        }
    }

    private static void fireAfter(MulticastFSMProbe p, int oldState, int newState) {
        if (!p.isEmpty()) {
            p.fireAfterTransition(oldState, newState);
        }
    }

    public FiniteStateMachine(Clock c, int ss, String[] nm, int tt) {
        this.clock = c;
        this.startState = ss;
        this.curState = ss;
        this.numStates = nm.length;
        this.states = new State[this.numStates];
        int[][] ttm = FiniteStateMachine.buildUniformTTM(this.numStates, tt);
        this.buildStates(nm, ttm);
    }

    public FiniteStateMachine(Clock c, int ss, String[] nm, int[][] ttm) {
        this.clock = c;
        this.startState = ss;
        this.curState = ss;
        this.numStates = nm.length;
        this.states = new State[this.numStates];
        this.buildStates(nm, ttm);
    }

    private void buildStates(String[] nm, int[][] ttm) {
        for (int cntr = 0; cntr < this.numStates; ++cntr) {
            this.states[cntr] = new State(nm[cntr], ttm[cntr]);
        }
    }

    public void insertProbe(Probe p) {
        this.globalProbe.add(p);
    }

    public void removeProbe(Probe p) {
        this.globalProbe.remove(p);
    }

    public void insertProbe(Probe p, int state) {
        this.states[state].probes.add(p);
    }

    public void removeProbe(Probe p, int state) {
        this.states[state].probes.remove(p);
    }

    public int getNumberOfStates() {
        return this.numStates;
    }

    public int getStartState() {
        return this.startState;
    }

    public int getCurrentState() {
        return this.curState;
    }

    public void transition(int newState) {
        if (this.curState == -1) {
            throw Util.failure("cannot transition to state " + newState + " while in transition: " + this.transEvent.oldState + " -> " + this.transEvent.newState);
        }
        int ttime = this.states[this.curState].transition_time[newState];
        if (ttime < 0) {
            throw Util.failure("cannot transition from state " + this.curState + " -> " + newState);
        }
        FiniteStateMachine.fireBefore(this.globalProbe, this.curState, newState);
        FiniteStateMachine.fireBefore(this.states[this.curState].probes, this.curState, newState);
        FiniteStateMachine.fireBefore(this.states[newState].probes, this.curState, newState);
        if (ttime == 0) {
            int oldState = this.curState;
            this.curState = newState;
            FiniteStateMachine.fireAfter(this.states[oldState].probes, oldState, newState);
            FiniteStateMachine.fireAfter(this.states[newState].probes, oldState, newState);
            FiniteStateMachine.fireAfter(this.globalProbe, oldState, newState);
        } else {
            this.transEvent.oldState = this.curState;
            this.transEvent.newState = newState;
            this.clock.insertEvent(this.transEvent, ttime);
        }
    }

    public int getTransitionTime(int beforeState, int afterState) {
        return this.states[beforeState].transition_time[afterState];
    }

    public String getStateName(int state) {
        return this.states[state].name;
    }

    public String getCurrentStateName() {
        return this.states[this.curState].name;
    }

    public Clock getClock() {
        return this.clock;
    }

    public static int[][] buildUniformTTM(int size, int tt) {
        int[][] ttm = new int[size][size];
        if (tt != 0) {
            for (int cntr = 0; cntr < size; ++cntr) {
                for (int loop = 0; loop < size; ++loop) {
                    ttm[cntr][loop] = tt;
                }
            }
        }
        return ttm;
    }

    public static int[][] buildSparseTTM(int size, int tt) {
        int[][] ttm = new int[size][];
        int[] row = new int[size];
        for (int cntr = 0; cntr < size; ++cntr) {
            ttm[cntr] = row;
            row[cntr] = tt;
        }
        return ttm;
    }

    public static int[][] buildBimodalTTM(int size, int ds, int[] tf, int[] tt) {
        int[][] ttm = FiniteStateMachine.newTTM(size);
        for (int cntr = 0; cntr < size; ++cntr) {
            for (int loop = 0; loop < size; ++loop) {
                ttm[cntr][ds] = tf[cntr];
                ttm[ds][cntr] = tt[cntr];
            }
        }
        return ttm;
    }

    public static int[][] setCircularTTM(int[][] ttm, int[] perm, int[] tt) {
        int size = ttm.length;
        for (int cntr = 0; cntr < size - 1; ++cntr) {
            ttm[perm[cntr]][perm[cntr + 1]] = tt[perm[cntr + 1]];
        }
        ttm[perm[size - 1]][perm[0]] = tt[perm[0]];
        return ttm;
    }

    public static int[][] newTTM(int size) {
        int[][] ttm = new int[size][size];
        for (int cntr = 0; cntr < size; ++cntr) {
            for (int loop = 0; loop < size; ++loop) {
                ttm[cntr][loop] = -1;
            }
        }
        return ttm;
    }

    public static int[][] setDiagonal(int[][] ttm, int diag) {
        for (int cntr = 0; cntr < ttm.length; ++cntr) {
            ttm[cntr][cntr] = diag;
        }
        return ttm;
    }

    protected class TransitionEvent
    implements Simulator.Event {
        protected int oldState;
        protected int newState;

        protected TransitionEvent() {
        }

        public void fire() {
            FiniteStateMachine.this.curState = this.newState;
            FiniteStateMachine.fireAfter(FiniteStateMachine.this.states[this.oldState].probes, this.oldState, this.newState);
            FiniteStateMachine.fireAfter(FiniteStateMachine.this.states[this.newState].probes, this.oldState, this.newState);
            FiniteStateMachine.fireAfter(FiniteStateMachine.this.globalProbe, this.oldState, this.newState);
        }
    }

    protected class State {
        final String name;
        final int[] transition_time;
        final MulticastFSMProbe probes;

        State(String n, int[] tt) {
            this.name = n;
            this.transition_time = tt;
            this.probes = new MulticastFSMProbe();
        }
    }

    public static interface Probe {
        public void fireBeforeTransition(int var1, int var2);

        public void fireAfterTransition(int var1, int var2);
    }
}

