/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim;

import avrora.arch.legacy.LegacyInstr;
import avrora.arch.legacy.LegacyInstrProperties;
import avrora.arch.legacy.LegacyInstrVisitor;
import avrora.arch.legacy.LegacyOperand;
import avrora.core.Program;
import avrora.sim.AtmelInterpreter;
import avrora.sim.InterpreterError;
import avrora.sim.Segment;
import avrora.sim.Simulator;
import avrora.sim.util.MulticastProbe;
import cck.util.Util;
import java.util.Arrays;

public class CodeSegment
extends Segment {
    protected final AtmelInterpreter interpreter;
    public static final byte DEFAULT_VALUE = -1;
    protected LegacyInstr[] segment_instr;
    protected final NoLegacyInstr NO_INSTR = new NoLegacyInstr();
    protected CodeSharer codeSharer;
    static LegacyInstrProperties NO_INSTR_PROPS = new LegacyInstrProperties("<none>", "<none>", 2, 1);

    protected void replaceInstr(int address, LegacyInstr i) {
        LegacyInstr instr = this.getInstr(address);
        if (instr == null || !(instr instanceof ProbedLegacyInstr)) {
            this.writeInstr(address, i);
        } else {
            ProbedLegacyInstr pi = new ProbedLegacyInstr(i, (ProbedLegacyInstr)instr);
            this.writeInstr(address, pi);
        }
    }

    public CodeSegment(String name, int size, AtmelInterpreter bi) {
        super(name, size, (byte)-1, bi.state);
        this.interpreter = bi;
        this.segment_instr = new LegacyInstr[size];
    }

    public void update() {
        throw Util.failure("Update of flash memory not supported for this segment");
    }

    public LegacyInstr[] shareCode(CodeSharer s) {
        this.codeSharer = s;
        return this.segment_instr;
    }

    public void load(Program p) {
        Arrays.fill(this.segment_instr, this.NO_INSTR);
        int cntr = p.program_start;
        while (cntr < p.program_end) {
            LegacyInstr i = (LegacyInstr)p.readInstr(cntr);
            if (i != null) {
                this.segment_instr[cntr] = i;
                cntr += i.getSize();
                continue;
            }
            cntr += 2;
        }
        for (cntr = p.program_start; cntr < p.program_end; ++cntr) {
            this.segment_data[cntr] = p.readProgramByte(cntr);
        }
    }

    public LegacyInstr readInstr(int address) {
        try {
            return this.segment_instr[address].asInstr();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new Segment.AddressOutOfBoundsException(this, address);
        }
    }

    public LegacyInstr getInstr(int address) {
        try {
            return this.segment_instr[address];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new Segment.AddressOutOfBoundsException(this, address);
        }
    }

    public void insertProbe(int address, Simulator.Probe p) {
        LegacyInstr instr = this.getInstr(address);
        if (instr instanceof ProbedLegacyInstr) {
            ProbedLegacyInstr pri = (ProbedLegacyInstr)instr;
            pri.add(p);
        } else {
            ProbedLegacyInstr pri = new ProbedLegacyInstr(instr, address);
            pri.add(p);
            this.writeInstr(address, pri);
        }
    }

    public void removeProbe(int address, Simulator.Probe p) {
        LegacyInstr instr = this.getInstr(address);
        if (instr instanceof ProbedLegacyInstr) {
            ProbedLegacyInstr pri = (ProbedLegacyInstr)instr;
            pri.remove(p);
        }
    }

    protected void writeInstr(int address, LegacyInstr i) {
        this.segment_instr[address] = i;
    }

    private class NoLegacyInstr
    extends LegacyInstr {
        NoLegacyInstr() {
            super(NO_INSTR_PROPS);
        }

        public String getOperands() {
            throw Util.failure("no instruction here");
        }

        public void accept(LegacyInstrVisitor v) {
            throw new InterpreterError.NoSuchInstructionException(CodeSegment.this.interpreter.getState().getPC());
        }

        public LegacyInstr build(int pc, LegacyOperand[] ops) {
            throw Util.failure("no instruction here");
        }

        public LegacyInstr asInstr() {
            return null;
        }
    }

    protected class ProbedLegacyInstr
    extends LegacyInstr {
        protected final int address;
        protected final LegacyInstr instr;
        protected final MulticastProbe probe;

        public ProbedLegacyInstr(LegacyInstr i, int a) {
            super(new LegacyInstrProperties(i.properties.name, i.properties.variant, i.properties.size, 0));
            this.instr = i;
            this.address = a;
            this.probe = new MulticastProbe();
        }

        public ProbedLegacyInstr(LegacyInstr i, ProbedLegacyInstr prev) {
            super(new LegacyInstrProperties(i.properties.name, i.properties.variant, i.properties.size, 0));
            this.instr = i;
            this.address = prev.address;
            this.probe = prev.probe;
        }

        void add(Simulator.Probe p) {
            this.probe.add(p);
        }

        void remove(Simulator.Probe p) {
            this.probe.remove(p);
        }

        boolean isEmpty() {
            return this.probe.isEmpty();
        }

        public void accept(LegacyInstrVisitor v) {
            this.probe.fireBefore(CodeSegment.this.interpreter.state, this.address);
            this.instr.accept(CodeSegment.this.interpreter);
            CodeSegment.this.interpreter.commit();
            this.probe.fireAfter(CodeSegment.this.interpreter.state, this.address);
            if (this.probe.isEmpty()) {
                CodeSegment.this.writeInstr(this.address, this.instr);
            }
        }

        public LegacyInstr build(int address, LegacyOperand[] ops) {
            throw Util.failure("ProbedLegacyInstr should be confined to BaseInterpreter");
        }

        public String getOperands() {
            return this.instr.getOperands();
        }

        public LegacyInstr asInstr() {
            return this.instr;
        }
    }

    public static interface CodeSharer {
        public void update(LegacyInstr[] var1);
    }

    public static class DefaultFactory
    implements Factory {
        final int size;

        public DefaultFactory(int s) {
            this.size = s;
        }

        public CodeSegment newCodeSegment(String name, AtmelInterpreter bi, Program p) {
            return new CodeSegment(name, this.size, bi);
        }
    }

    public static interface Factory {
        public CodeSegment newCodeSegment(String var1, AtmelInterpreter var2, Program var3);
    }
}

