/*
 * Decompiled with CFR 0.152.
 */
package avrora.sim;

import avrora.arch.AbstractInstr;
import avrora.arch.avr.AVRProperties;
import avrora.arch.legacy.LegacyInstr;
import avrora.arch.legacy.LegacyInstrVisitor;
import avrora.arch.legacy.LegacyRegister;
import avrora.arch.legacy.LegacyState;
import avrora.core.Program;
import avrora.sim.ActiveRegister;
import avrora.sim.CodeSegment;
import avrora.sim.Interpreter;
import avrora.sim.InterruptTable;
import avrora.sim.RWRegister;
import avrora.sim.Simulator;
import avrora.sim.State;
import avrora.sim.mcu.RegisterSet;
import avrora.sim.state.VolatileBehavior;
import avrora.sim.util.MulticastProbe;
import avrora.sim.util.MulticastWatch;
import cck.util.Arithmetic;
import cck.util.Util;

public abstract class AtmelInterpreter
extends Interpreter
implements LegacyInstrVisitor {
    public static final boolean INSTRUMENTED = true;
    public static final boolean UNINSTRUMENTED = false;
    public static final int NUM_REGS = 32;
    protected LegacyInstr[] shared_instr;
    protected int pc;
    protected int nextPC;
    protected int cyclesConsumed;
    protected boolean I;
    protected boolean T;
    protected boolean H;
    protected boolean S;
    protected boolean V;
    protected boolean N;
    protected boolean Z;
    protected boolean C;
    protected byte[] sram;
    protected final int sram_start;
    protected final int sram_max;
    protected MulticastWatch[] sram_watches;
    protected final VolatileBehavior[] sram_volatile;
    protected final ActiveRegister[] ioregs;
    protected final CodeSegment flash;
    protected final RWRegister SPL_reg;
    protected final RWRegister SPH_reg;
    public final int RAMPZ;
    public final int SREG;
    protected final RegisterSet registers;
    protected final StateImpl state;
    protected int bootPC;
    protected int interruptBase;
    protected MulticastWatch error_watch;
    protected final MulticastProbe globalProbe;
    protected long delayCycles;
    protected boolean shouldRun;
    protected boolean sleeping;
    protected boolean justReturnedFromInterrupt;

    protected AtmelInterpreter(Simulator simulator, Program p, AVRProperties pr) {
        super(simulator);
        int i;
        Compiler.compileClass(this.getClass());
        this.state = new StateImpl();
        this.globalProbe = new MulticastProbe();
        this.SREG = pr.getIOReg("SREG");
        this.RAMPZ = pr.hasIOReg("RAMPZ") ? pr.getIOReg("RAMPZ") : -1;
        if (p.program_end > pr.flash_size) {
            throw Util.failure("program will not fit into " + pr.flash_size + " bytes");
        }
        this.sram_start = AtmelInterpreter.toSRAM(pr.ioreg_size);
        this.sram_max = 32 + pr.ioreg_size + pr.sram_size;
        this.sram = new byte[this.sram_max];
        this.registers = simulator.getMicrocontroller().getRegisterSet();
        this.sram_volatile = new VolatileBehavior[this.sram_start];
        VolatileBehavior b = new VolatileBehavior();
        for (i = 0; i < this.sram_volatile.length; ++i) {
            this.sram_volatile[i] = b;
        }
        this.ioregs = this.registers.share();
        for (i = 0; i < this.ioregs.length; ++i) {
            this.sram_volatile[AtmelInterpreter.toSRAM((int)i)] = new IORegBehavior(this.ioregs[i]);
        }
        this.sram_volatile[AtmelInterpreter.toSRAM((int)this.SREG)] = new SREGBehavior();
        this.flash = pr.codeSegmentFactory.newCodeSegment("flash", this, p);
        this.shared_instr = this.flash.shareCode(null);
        this.interrupts = new InterruptTable(this, pr.num_interrupts);
        this.SPL_reg = (RWRegister)this.ioregs[pr.getIOReg("SPL")];
        this.SPH_reg = (RWRegister)this.ioregs[pr.getIOReg("SPH")];
    }

    public void start() {
        this.shouldRun = true;
        this.runLoop();
    }

    public void stop() {
        this.shouldRun = false;
        this.innerLoop = false;
    }

    public State getState() {
        return this.state;
    }

    protected abstract void runLoop();

    protected int getInterruptVectorAddress(int inum) {
        return this.interruptBase + (inum - 1) * 4;
    }

    public void setPosted(int inum, boolean post) {
        if (post) {
            this.interrupts.post(inum);
        } else {
            this.interrupts.unpost(inum);
        }
    }

    public void setEnabled(int inum, boolean enabled) {
        if (enabled) {
            this.innerLoop = false;
            this.interrupts.enable(inum);
        } else {
            this.interrupts.disable(inum);
        }
    }

    protected void insertProbe(Simulator.Probe p, int addr) {
        this.flash.insertProbe(addr, p);
    }

    protected void insertErrorWatch(Simulator.Watch watch) {
        if (this.error_watch == null) {
            this.error_watch = new MulticastWatch();
        }
        this.error_watch.add(watch);
    }

    protected void insertProbe(Simulator.Probe p) {
        this.innerLoop = false;
        this.globalProbe.add(p);
    }

    protected void removeProbe(Simulator.Probe p, int addr) {
        this.flash.removeProbe(addr, p);
    }

    public void removeProbe(Simulator.Probe b) {
        this.innerLoop = false;
        this.globalProbe.remove(b);
    }

    protected void insertWatch(Simulator.Watch p, int data_addr) {
        MulticastWatch w;
        if (this.sram_watches == null) {
            this.sram_watches = new MulticastWatch[this.sram.length];
        }
        if ((w = this.sram_watches[data_addr]) == null) {
            w = this.sram_watches[data_addr] = new MulticastWatch();
        }
        w.add(p);
    }

    protected void removeWatch(Simulator.Watch p, int data_addr) {
        if (this.sram_watches == null) {
            return;
        }
        MulticastWatch w = this.sram_watches[data_addr];
        if (w == null) {
            return;
        }
        w.remove(p);
    }

    protected void advanceClock(long delta) {
        this.clock.advance(delta);
        this.cyclesConsumed = 0;
    }

    protected void delay(long cycles) {
        this.innerLoop = false;
        this.delayCycles += cycles;
    }

    protected void storeProgramMemory() {
        this.flash.update();
    }

    public byte getRegisterByte(LegacyRegister reg) {
        return this.sram[reg.getNumber()];
    }

    public byte getRegisterByte(int reg) {
        return this.sram[reg];
    }

    public int getRegisterUnsigned(LegacyRegister reg) {
        return this.sram[reg.getNumber()] & 0xFF;
    }

    public int getRegisterUnsigned(int reg) {
        return this.sram[reg] & 0xFF;
    }

    public int getRegisterWord(LegacyRegister reg) {
        byte low = this.getRegisterByte(reg);
        byte high = this.getRegisterByte(reg.nextRegister());
        return Arithmetic.uword(low, high);
    }

    public int getRegisterWord(int reg) {
        byte low = this.getRegisterByte(reg);
        byte high = this.getRegisterByte(reg + 1);
        return Arithmetic.uword(low, high);
    }

    public boolean getFlag(int bit) {
        switch (bit) {
            case 7: {
                return this.I;
            }
            case 6: {
                return this.T;
            }
            case 5: {
                return this.H;
            }
            case 4: {
                return this.S;
            }
            case 3: {
                return this.V;
            }
            case 2: {
                return this.N;
            }
            case 1: {
                return this.Z;
            }
            case 0: {
                return this.C;
            }
        }
        return false;
    }

    public void setFlag(int bit, boolean on) {
        switch (bit) {
            case 7: {
                if (on) {
                    this.enableInterrupts();
                    break;
                }
                this.disableInterrupts();
                break;
            }
            case 6: {
                this.T = on;
                break;
            }
            case 5: {
                this.H = on;
                break;
            }
            case 4: {
                this.S = on;
                break;
            }
            case 3: {
                this.V = on;
                break;
            }
            case 2: {
                this.N = on;
                break;
            }
            case 1: {
                this.Z = on;
                break;
            }
            case 0: {
                this.C = on;
            }
        }
    }

    protected void setIORegBit(int ior, int bit, boolean on) {
        byte curv = this.readSRAM(true, AtmelInterpreter.toSRAM(ior));
        curv = Arithmetic.setBit(curv, bit, on);
        this.writeSRAM(true, AtmelInterpreter.toSRAM(ior), curv);
    }

    protected boolean getIORegBit(int ior, int bit) {
        return Arithmetic.getBit(this.readSRAM(true, AtmelInterpreter.toSRAM(ior)), bit);
    }

    public byte getDataByte(int address) {
        return this.readSRAM(true, address);
    }

    private byte readSRAM(boolean w, int addr) {
        if (addr < 0) {
            return this.fireReadError(w, addr);
        }
        if (addr < this.sram.length) {
            this.fireBeforeRead(w, addr);
            byte val = addr < this.sram_start ? (this.sram[addr] = this.readVolatile(addr)) : this.sram[addr];
            this.fireAfterRead(w, addr, val);
            return val;
        }
        return this.fireReadError(w, addr);
    }

    private void writeSRAM(boolean w, int addr, byte val) {
        if (addr < 0) {
            this.fireWriteError(w, addr, val);
        } else if (addr < this.sram.length) {
            this.fireBeforeWrite(w, addr, val);
            this.sram[addr] = addr < this.sram_start ? this.writeVolatile(addr, val) : val;
            this.fireAfterWrite(w, addr, val);
        } else {
            this.fireWriteError(w, addr, val);
        }
    }

    private void fireWriteError(boolean w, int addr, byte val) {
        if (w && this.error_watch != null) {
            this.error_watch.fireBeforeWrite(this.state, addr, val);
        }
    }

    private byte fireReadError(boolean w, int addr) {
        if (w && this.error_watch != null) {
            this.error_watch.fireBeforeRead(this.state, addr);
        }
        return 0;
    }

    private byte readVolatile(int addr) {
        VolatileBehavior behavior = this.sram_volatile[addr];
        return (byte)behavior.read(this.sram[addr] & 0xFF);
    }

    private byte writeVolatile(int addr, byte val) {
        VolatileBehavior behavior = this.sram_volatile[addr];
        return (byte)behavior.write(this.sram[addr] & 0xFF, val & 0xFF);
    }

    private void fireBeforeRead(boolean w, int addr) {
        MulticastWatch p;
        if (w && this.sram_watches != null && (p = this.sram_watches[addr]) != null) {
            p.fireBeforeRead(this.state, addr);
        }
    }

    private void fireAfterRead(boolean w, int addr, byte val) {
        MulticastWatch p;
        if (w && this.sram_watches != null && (p = this.sram_watches[addr]) != null) {
            p.fireAfterRead(this.state, addr, val);
        }
    }

    private void fireBeforeWrite(boolean w, int addr, byte val) {
        MulticastWatch p;
        if (w && this.sram_watches != null && (p = this.sram_watches[addr]) != null) {
            p.fireBeforeWrite(this.state, addr, val);
        }
    }

    private void fireAfterWrite(boolean w, int addr, byte val) {
        MulticastWatch p;
        if (w && this.sram_watches != null && (p = this.sram_watches[addr]) != null) {
            p.fireAfterWrite(this.state, addr, val);
        }
    }

    public int getInstrSize(int npc) {
        return this.getInstr(npc).getSize();
    }

    public byte getIORegisterByte(int ioreg) {
        return this.readSRAM(true, AtmelInterpreter.toSRAM(ioreg));
    }

    public byte getFlashByte(int address) {
        return this.flash.read(address);
    }

    protected void writeRegisterByte(LegacyRegister reg, byte val) {
        this.sram[reg.getNumber()] = val;
    }

    protected void writeRegisterWord(LegacyRegister reg, int val) {
        byte low = Arithmetic.low(val);
        byte high = Arithmetic.high(val);
        this.writeRegisterByte(reg, low);
        this.writeRegisterByte(reg.nextRegister(), high);
    }

    public void writeRegisterByte(int reg, byte val) {
        this.sram[reg] = val;
    }

    public void writeRegisterWord(int reg, int val) {
        byte low = Arithmetic.low(val);
        byte high = Arithmetic.high(val);
        this.writeRegisterByte(reg, low);
        this.writeRegisterByte(reg + 1, high);
    }

    public void writeDataByte(int address, byte val) {
        this.writeSRAM(true, address, val);
    }

    public void writeFlashByte(int address, byte val) {
        this.flash.set(address, val);
    }

    public void installIOReg(int ioreg, ActiveRegister reg) {
        this.sram_volatile[AtmelInterpreter.toSRAM((int)ioreg)] = new IORegBehavior(reg);
        this.ioregs[ioreg] = reg;
    }

    public ActiveRegister getIOReg(int ioreg) {
        return this.ioregs[ioreg];
    }

    private static int toSRAM(int ioreg) {
        return ioreg + 32;
    }

    public void installVolatileBehavior(int addr, VolatileBehavior b) {
        this.sram_volatile[addr] = b;
    }

    public void writeIORegisterByte(int ioreg, byte val) {
        this.writeSRAM(true, AtmelInterpreter.toSRAM(ioreg), val);
    }

    public byte popByte() {
        int address = this.getSP() + 1;
        this.setSP(address);
        return this.getDataByte(address);
    }

    public void pushByte(byte val) {
        int address = this.getSP();
        this.setSP(address - 1);
        this.writeDataByte(address, val);
    }

    public void setSP(int val) {
        this.SPL_reg.value = Arithmetic.low(val);
        this.SPH_reg.value = Arithmetic.high(val);
    }

    public void setBootPC(int npc) {
        this.bootPC = npc;
    }

    public int getInterruptBase() {
        return this.interruptBase;
    }

    public void setInterruptBase(int npc) {
        this.interruptBase = npc;
    }

    public LegacyInstr getInstr(int address) {
        return this.flash.readInstr(address);
    }

    public int getSP() {
        byte low = this.SPL_reg.value;
        byte high = this.SPH_reg.value;
        return Arithmetic.uword(low, high);
    }

    public void enableInterrupts() {
        this.I = true;
        this.innerLoop = false;
        this.interrupts.enableAll();
    }

    public void disableInterrupts() {
        this.I = false;
        this.interrupts.disableAll();
    }

    protected void commit() {
        this.pc = this.nextPC;
        this.clock.advance(this.cyclesConsumed);
        this.cyclesConsumed = 0;
    }

    private class SREGBehavior
    extends VolatileBehavior {
        private SREGBehavior() {
        }

        public int read(int cur) {
            int val = 0;
            if (AtmelInterpreter.this.I) {
                val |= 0x80;
            }
            if (AtmelInterpreter.this.T) {
                val |= 0x40;
            }
            if (AtmelInterpreter.this.H) {
                val |= 0x20;
            }
            if (AtmelInterpreter.this.S) {
                val |= 0x10;
            }
            if (AtmelInterpreter.this.V) {
                val |= 8;
            }
            if (AtmelInterpreter.this.N) {
                val |= 4;
            }
            if (AtmelInterpreter.this.Z) {
                val |= 2;
            }
            if (AtmelInterpreter.this.C) {
                val |= 1;
            }
            return (byte)val;
        }

        public int write(int cur, int nv) {
            boolean enabled;
            boolean bl = enabled = (nv & 0x80) != 0;
            if (enabled) {
                AtmelInterpreter.this.enableInterrupts();
            } else {
                AtmelInterpreter.this.disableInterrupts();
            }
            AtmelInterpreter.this.T = (nv & 0x40) != 0;
            AtmelInterpreter.this.H = (nv & 0x20) != 0;
            AtmelInterpreter.this.S = (nv & 0x10) != 0;
            AtmelInterpreter.this.V = (nv & 8) != 0;
            AtmelInterpreter.this.N = (nv & 4) != 0;
            AtmelInterpreter.this.Z = (nv & 2) != 0;
            AtmelInterpreter.this.C = (nv & 1) != 0;
            return nv;
        }
    }

    private static class IORegBehavior
    extends VolatileBehavior {
        final ActiveRegister reg;

        IORegBehavior(ActiveRegister r) {
            this.reg = r;
        }

        public int read(int cur) {
            return this.reg.read();
        }

        public int write(int cur, int nv) {
            this.reg.write((byte)nv);
            return nv;
        }
    }

    public class StateImpl
    implements LegacyState {
        public Simulator getSimulator() {
            return AtmelInterpreter.this.simulator;
        }

        public InterruptTable getInterruptTable() {
            return AtmelInterpreter.this.interrupts;
        }

        public byte getRegisterByte(LegacyRegister reg) {
            return AtmelInterpreter.this.sram[reg.getNumber()];
        }

        public int getRegisterUnsigned(LegacyRegister reg) {
            return AtmelInterpreter.this.sram[reg.getNumber()] & 0xFF;
        }

        public int getRegisterWord(LegacyRegister reg) {
            int number = reg.getNumber();
            return Arithmetic.uword(AtmelInterpreter.this.sram[number], AtmelInterpreter.this.sram[number + 1]);
        }

        public byte getSREG() {
            int value = 0;
            if (AtmelInterpreter.this.I) {
                value |= 0x80;
            }
            if (AtmelInterpreter.this.T) {
                value |= 0x40;
            }
            if (AtmelInterpreter.this.H) {
                value |= 0x20;
            }
            if (AtmelInterpreter.this.S) {
                value |= 0x10;
            }
            if (AtmelInterpreter.this.V) {
                value |= 8;
            }
            if (AtmelInterpreter.this.N) {
                value |= 4;
            }
            if (AtmelInterpreter.this.Z) {
                value |= 2;
            }
            if (AtmelInterpreter.this.C) {
                value |= 1;
            }
            return (byte)value;
        }

        public boolean getFlag(int bit) {
            return AtmelInterpreter.this.getFlag(bit);
        }

        public byte getStackByte() {
            int address = this.getSP();
            return this.getDataByte(address);
        }

        public int getSP() {
            byte low = AtmelInterpreter.this.SPL_reg.value;
            byte high = AtmelInterpreter.this.SPH_reg.value;
            return Arithmetic.uword(low, high);
        }

        public int getPC() {
            return AtmelInterpreter.this.pc;
        }

        public AbstractInstr getInstr(int address) {
            return AtmelInterpreter.this.flash.readInstr(address);
        }

        public byte getDataByte(int address) {
            return AtmelInterpreter.this.readSRAM(false, address);
        }

        public byte getProgramByte(int address) {
            return AtmelInterpreter.this.flash.get(address);
        }

        public byte getIORegisterByte(int ioreg) {
            return this.getAR(ioreg).read();
        }

        public ActiveRegister getIOReg(int ioreg) {
            return this.getAR(ioreg);
        }

        private ActiveRegister getAR(int ioreg) {
            return AtmelInterpreter.this.ioregs[ioreg];
        }

        public long getCycles() {
            return AtmelInterpreter.this.clock.getCount();
        }

        public int getSleepMode() {
            throw Util.unimplemented();
        }
    }
}

