/*
 * Decompiled with CFR 0.152.
 */
package avrora.monitors;

import avrora.arch.AbstractInstr;
import avrora.arch.legacy.LegacyInstr;
import avrora.arch.legacy.LegacyState;
import avrora.core.Program;
import avrora.core.SourceMapping;
import avrora.monitors.CallStack;
import avrora.monitors.CallTrace;
import avrora.monitors.Monitor;
import avrora.monitors.MonitorFactory;
import avrora.sim.Simulator;
import avrora.sim.State;
import avrora.sim.util.SimUtil;
import cck.text.StringUtil;
import cck.text.Terminal;
import cck.util.Option;

public class VirgilMonitor
extends MonitorFactory {
    public static final int ABORT_TYPE_CODE = 127;
    public static final int ABORT_NULL_CODE = 126;
    public static final int ABORT_BOUNDS_CODE = 125;
    public static final int ABORT_DIV_CODE = 124;
    public static final int ABORT_ALLOC_CODE = 123;
    public static final int ABORT_UNIMP_CODE = 122;
    public final Option.Long STATUS_ADDR = this.newOption("status-addr", 145L, "This option specifies the address in memory where the status register lies. The status register is used to diagnose the cause of a program abort.");

    public VirgilMonitor() {
        super("The \"virgil\" monitor watches for execution of an AVR break instruction, which is used by the Virgil compiler to signal fatal exceptions.");
    }

    public Monitor newMonitor(Simulator s) {
        return new Mon(s);
    }

    public class Mon
    implements Monitor {
        public final Simulator simulator;
        public final CallTrace trace;
        public final CallStack stack;
        private final SourceMapping sourceMap;

        Mon(Simulator s) {
            this.simulator = s;
            this.trace = new CallTrace(s);
            this.stack = new CallStack();
            this.trace.attachMonitor(this.stack);
            Program p = s.getProgram();
            this.sourceMap = p.getSourceMapping();
            int pc = 0;
            while (pc < p.program_end) {
                AbstractInstr i = p.readInstr(pc);
                if (i != null && i instanceof LegacyInstr.BREAK) {
                    s.insertProbe(new BreakProbe(), pc);
                }
                pc = p.getNextPC(pc);
            }
        }

        private void printStack(String idstr) {
            int depth = this.stack.getDepth();
            for (int cntr = depth - 1; cntr >= 0; --cntr) {
                Terminal.print(idstr);
                Terminal.print("      in ");
                byte inum = this.stack.getInterrupt(cntr);
                if (inum >= 0) {
                    Terminal.printRed("#" + inum + " ");
                }
                Terminal.printGreen(this.sourceMap.getName(this.stack.getTarget(cntr)));
                Terminal.nextln();
            }
        }

        public void report() {
        }

        public class BreakProbe
        extends Simulator.Probe.Empty {
            public void fireBefore(State state, int pc) {
                String idstr = SimUtil.getIDTimeString(Mon.this.simulator);
                LegacyState s = (LegacyState)Mon.this.simulator.getState();
                byte code = s.getDataByte((int)VirgilMonitor.this.STATUS_ADDR.get());
                String name = "UnknownException";
                String msg = "an unknown exception occurred";
                switch (code) {
                    case 0: {
                        return;
                    }
                    case 127: {
                        name = "TypeCheckException";
                        msg = "type check exception in explicit cast";
                        break;
                    }
                    case 126: {
                        name = "NullCheckException";
                        msg = "null check exception";
                        break;
                    }
                    case 125: {
                        name = "BoundsCheckException";
                        msg = "array bounds check exception";
                        break;
                    }
                    case 124: {
                        name = "DivideByZeroException";
                        msg = "division by zero";
                        break;
                    }
                    case 123: {
                        name = "AllocationException";
                        msg = "dynamic memory allocation failed";
                        break;
                    }
                    case 122: {
                        name = "UnimplementedException";
                        msg = "method not implemented";
                    }
                }
                Terminal.print(idstr);
                Terminal.printRed(name);
                Terminal.print(": " + msg + " @ ");
                Terminal.printBrightCyan(StringUtil.addrToString(pc));
                Terminal.nextln();
                Mon.this.printStack(idstr);
            }
        }
    }
}

