/*
 * Decompiled with CFR 0.152.
 */
package avrora.monitors;

import avrora.core.Program;
import avrora.core.SourceMapping;
import avrora.monitors.Monitor;
import avrora.monitors.MonitorFactory;
import avrora.sim.Simulator;
import avrora.sim.State;
import cck.stat.Distribution;
import cck.text.Printer;
import cck.text.StringUtil;
import cck.text.TermUtil;
import cck.text.Terminal;
import cck.util.Option;
import cck.util.Util;
import java.util.Iterator;

public class TripTimeMonitor
extends MonitorFactory {
    final Option.List PAIRS = this.newOptionList("pairs", "", "The \"pairs\" option specifies the list of program point pairs for which to measure the point-to-point trip time. ");
    final Option.List FROM = this.newOptionList("from", "", "The \"from\" option specifies the list of program points for which to measure to every other instruction in the program. ");
    final Option.List TO = this.newOptionList("to", "", "The \"from\" option specifies the list of program points for which to measure from every other instruction in the program. ");
    final Option.Bool DISTRIBUTION = this.newOption("distribution", false, "This option, when specified, causes the trip time monitor to print a complete distribution of the trip times for each pair of program points. WARNING: this option can consume large amounts of memory and generate a large amount of output.");

    public TripTimeMonitor() {
        super("The \"trip-time\" monitor records profiling information about the program that consists of the time it takes (on average) to reach one point from another point in the program.");
    }

    public Monitor newMonitor(Simulator s) {
        return new PointToPointMon(s);
    }

    protected class PointToPointMon
    implements Monitor {
        final Pair[] startArray;
        final Pair[] endArray;
        final long[] lastEnter;
        final Simulator simulator;
        final Program program;
        final PTPProbe PROBE;

        PointToPointMon(Simulator s) {
            this.simulator = s;
            this.program = s.getProgram();
            int psize = this.program.program_end;
            this.startArray = new Pair[psize];
            this.endArray = new Pair[psize];
            this.lastEnter = new long[psize];
            this.PROBE = new PTPProbe();
            this.addPairs();
            this.addFrom();
            this.addTo();
        }

        private void addPairs() {
            for (String str : TripTimeMonitor.this.PAIRS.get()) {
                int ind = str.indexOf(58);
                if (ind <= 0) {
                    throw Util.failure("invalid address format: " + StringUtil.quote(str));
                }
                String src = str.substring(0, ind);
                String dst = str.substring(ind + 1);
                SourceMapping.Location loc = this.getLocation(src);
                SourceMapping.Location tar = this.getLocation(dst);
                this.addPair(loc.lma_addr, tar.lma_addr);
            }
        }

        private SourceMapping.Location getLocation(String src) {
            SourceMapping lm = this.program.getSourceMapping();
            SourceMapping.Location loc = lm.getLocation(src);
            if (loc == null) {
                Util.userError("Invalid program address: ", src);
            }
            if (this.program.readInstr(loc.lma_addr) == null) {
                Util.userError("Invalid program address: ", src);
            }
            return loc;
        }

        private void addFrom() {
            Iterator i = TripTimeMonitor.this.FROM.get().iterator();
            SourceMapping sm = this.program.getSourceMapping();
            while (i.hasNext()) {
                String str = (String)i.next();
                SourceMapping.Location loc = sm.getLocation(str);
                int cntr = 0;
                while (cntr < this.program.program_end) {
                    this.addPair(loc.lma_addr, cntr);
                    cntr = this.program.getNextPC(cntr);
                }
            }
        }

        private void addTo() {
            Iterator i = TripTimeMonitor.this.TO.get().iterator();
            SourceMapping sm = this.program.getSourceMapping();
            while (i.hasNext()) {
                String str = (String)i.next();
                SourceMapping.Location loc = sm.getLocation(str);
                int cntr = 0;
                while (cntr < this.program.program_end) {
                    this.addPair(cntr, loc.lma_addr);
                    cntr = this.program.getNextPC(cntr);
                }
            }
        }

        void addPair(int start, int end) {
            if (this.program.readInstr(start) == null) {
                return;
            }
            if (this.program.readInstr(end) == null) {
                return;
            }
            Pair p = new Pair(start, end);
            if (this.startArray[p.start] == null && this.endArray[p.start] == null) {
                this.simulator.insertProbe(this.PROBE, p.start);
            }
            p.startLink = this.startArray[p.start];
            this.startArray[p.start] = p;
            if (this.startArray[p.end] == null && this.endArray[p.end] == null) {
                this.simulator.insertProbe(this.PROBE, p.end);
            }
            p.endLink = this.endArray[p.end];
            this.endArray[p.end] = p;
        }

        public void report() {
            TermUtil.printSeparator("Trip time results for node " + this.simulator.getID());
            Terminal.printGreen("  start      end     count         avg         std        max        min");
            Terminal.nextln();
            TermUtil.printThinSeparator(78);
            for (int cntr = 0; cntr < this.lastEnter.length; ++cntr) {
                Pair p = this.startArray[cntr];
                while (p != null) {
                    if (p.count > 0) {
                        p.report(Printer.STDOUT);
                    }
                    p = p.startLink;
                }
            }
            Terminal.nextln();
        }

        protected class PTPProbe
        extends Simulator.Probe.Empty {
            protected PTPProbe() {
            }

            public void fireBefore(State state, int pc) {
                long time = state.getCycles();
                Pair p = PointToPointMon.this.endArray[pc];
                while (p != null) {
                    if (PointToPointMon.this.lastEnter[p.start] >= 0L) {
                        p.record(time - PointToPointMon.this.lastEnter[p.start]);
                    }
                    p = p.startLink;
                }
                PointToPointMon.this.lastEnter[pc] = time;
            }
        }

        class Pair {
            final int start;
            final int end;
            long cumul;
            long cumul_sqr;
            int count;
            long max;
            long min;
            Pair startLink;
            Pair endLink;
            Distribution distrib;

            Pair(int start, int end) {
                this.start = start;
                this.end = end;
                this.cumul = 0L;
                this.cumul_sqr = 0L;
                this.max = 0L;
                this.min = Long.MAX_VALUE;
                if (TripTimeMonitor.this.DISTRIBUTION.get()) {
                    this.distrib = new Distribution("trip time " + StringUtil.addrToString(start) + " -to- " + StringUtil.addrToString(end), "Trips", "Total Time", "Distribution");
                }
            }

            void record(long time) {
                if (this.distrib != null) {
                    this.distrib.record((int)time);
                } else {
                    this.cumul += time;
                    this.cumul_sqr += time * time;
                    this.max = Math.max(this.max, time);
                    this.min = Math.min(this.min, time);
                }
                ++this.count;
            }

            void report(Printer printer) {
                if (this.distrib == null) {
                    float avg = (float)this.cumul / (float)this.count;
                    double std2 = Math.sqrt((double)this.cumul_sqr / (double)this.count - (double)(avg * avg));
                    Terminal.println("  " + StringUtil.addrToString(this.start) + "  " + StringUtil.addrToString(this.end) + "  " + StringUtil.rightJustify(this.count, 8) + "  " + StringUtil.rightJustify(avg, 10) + "  " + StringUtil.rightJustify((float)std2, 10) + "  " + StringUtil.rightJustify((float)this.max, 9) + "  " + StringUtil.rightJustify((float)this.min, 9));
                } else {
                    this.distrib.process();
                    this.distrib.print(printer);
                }
            }
        }
    }
}

