/*
 * Decompiled with CFR 0.152.
 */
package avrora.monitors;

import avrora.arch.AbstractInstr;
import avrora.core.Program;
import avrora.core.SourceMapping;
import avrora.monitors.Monitor;
import avrora.monitors.MonitorFactory;
import avrora.sim.Simulator;
import avrora.sim.State;
import avrora.sim.util.SimUtil;
import cck.text.StringUtil;
import cck.text.TermUtil;
import cck.text.Terminal;
import cck.util.Option;
import cck.util.Util;

public class TraceMonitor
extends MonitorFactory {
    final Option.List FROMTO = this.newOptionList("trace-from", "", "The \"trace-from\" option specifies the list of program point pairs for which to enable the tracing. The tracing will be enabled when the first point is entered and be disabled when the second point is reached. Nesting of multiple point pairs is handled correctly.");
    final Option.Long TIME = this.newOption("trace-start", 0L, "The \"trace-start\" option specifies the time to start the instruction trace, in clock cycles. This option can be useful for diagnosing problems in long simulations that happens after a given time is reached.");

    public TraceMonitor() {
        super("The \"trace\" monitor traces the execution of the entire program by printing every instruction as it executes. ");
    }

    public Monitor newMonitor(Simulator s) {
        return new Mon(s);
    }

    public class Mon
    implements Monitor {
        public final Simulator simulator;
        public final Program program;
        public final GlobalProbe PROBE;
        public int count;
        int nesting;
        int nextpc;

        private void print(State s, AbstractInstr i) {
            StringBuffer buf = new StringBuffer(100);
            SimUtil.getIDTimeString(buf, this.simulator);
            int pc = s.getPC();
            int color = pc == this.nextpc ? 4 : 6;
            Terminal.append(color, buf, StringUtil.to0xHex(pc, 4));
            buf.append(": ");
            buf.append(i.toString());
            Terminal.println(buf.toString());
            this.nextpc = pc + i.getSize();
        }

        private void print(String s) {
            String idstr = SimUtil.getIDTimeString(this.simulator);
            Terminal.println(idstr + s);
        }

        Mon(Simulator s) {
            this.simulator = s;
            this.program = s.getProgram();
            this.PROBE = new GlobalProbe();
            long time = TraceMonitor.this.TIME.get();
            if (time > 0L) {
                s.insertEvent(new StartEvent(), time);
            } else if (TraceMonitor.this.FROMTO.get().isEmpty()) {
                s.insertProbe(this.PROBE);
            } else {
                this.addPairs();
            }
        }

        private void addPairs() {
            for (String str : TraceMonitor.this.FROMTO.get()) {
                int ind = str.indexOf(58);
                if (ind <= 0) {
                    throw Util.failure("invalid address format: " + StringUtil.quote(str));
                }
                String src = str.substring(0, ind);
                String dst = str.substring(ind + 1);
                SourceMapping.Location loc = this.getLocation(src);
                SourceMapping.Location tar = this.getLocation(dst);
                this.addPair(loc.lma_addr, tar.lma_addr);
            }
        }

        private SourceMapping.Location getLocation(String src) {
            SourceMapping lm = this.program.getSourceMapping();
            SourceMapping.Location loc = lm.getLocation(src);
            if (loc == null) {
                Util.userError("Invalid program address: ", src);
            }
            if (this.program.readInstr(loc.lma_addr) == null) {
                Util.userError("Invalid program address: ", src);
            }
            return loc;
        }

        private void addPair(int start, int end) {
            if (this.program.readInstr(start) == null) {
                return;
            }
            if (this.program.readInstr(end) == null) {
                return;
            }
            this.simulator.insertProbe(new StartProbe(start, end), start);
            this.simulator.insertProbe(new EndProbe(start, end), end);
        }

        public void report() {
            TermUtil.printSeparator("Trace results for node " + this.simulator.getID());
            long cycles = this.simulator.getClock().getCount();
            float ipc = (float)this.count / (float)cycles;
            TermUtil.reportQuantity("Instructions executed", this.count, "");
            TermUtil.reportQuantity("Program throughput", ipc, "instrs/cycle");
            TermUtil.reportQuantity("Program throughput", ipc * (float)this.simulator.getClock().getHZ() / 1000000.0f, "mips");
            Terminal.nextln();
        }

        public class EndProbe
        extends Simulator.Probe.Empty {
            int start;
            int end;
            String pair;

            EndProbe(int s, int e) {
                this.start = s;
                this.end = e;
                this.pair = StringUtil.addrToString(s) + ":" + StringUtil.addrToString(e);
            }

            public void fireAfter(State s, int addr) {
                --Mon.this.nesting;
                if (Mon.this.nesting == 0) {
                    Mon.this.print("trace (" + this.pair + ") end --------------------------");
                    Mon.this.simulator.removeProbe(Mon.this.PROBE);
                } else {
                    Mon.this.print("nested (" + this.pair + ") end --------------------------");
                }
            }
        }

        public class StartEvent
        implements Simulator.Event {
            public void fire() {
                Mon.this.simulator.insertProbe(Mon.this.PROBE);
            }
        }

        public class StartProbe
        extends Simulator.Probe.Empty {
            int start;
            int end;
            int traceNum;
            String pair;

            StartProbe(int s, int e) {
                this.start = s;
                this.end = e;
                this.pair = StringUtil.addrToString(s) + ":" + StringUtil.addrToString(e);
            }

            public void fireBefore(State s, int addr) {
                ++this.traceNum;
                if (Mon.this.nesting == 0) {
                    Mon.this.print("trace (" + this.pair + ") begin: " + this.traceNum + " --------------------------");
                    Mon.this.print(s, s.getInstr(addr));
                    Mon.this.simulator.insertProbe(Mon.this.PROBE);
                } else {
                    Mon.this.print("nested (" + this.pair + ") begin: " + this.traceNum + " --------------------------");
                }
                ++Mon.this.nesting;
            }
        }

        public class GlobalProbe
        implements Simulator.Probe {
            public void fireBefore(State s, int addr) {
                Mon.this.print(s, s.getInstr(addr));
            }

            public void fireAfter(State s, int addr) {
                ++Mon.this.count;
            }
        }
    }
}

