/*
 * Decompiled with CFR 0.152.
 */
package avrora.monitors;

import avrora.arch.legacy.LegacyInstr;
import avrora.core.Program;
import avrora.monitors.Monitor;
import avrora.monitors.MonitorFactory;
import avrora.sim.Simulator;
import avrora.sim.State;
import avrora.sim.mcu.MCUProperties;
import cck.text.StringUtil;
import cck.text.TermUtil;
import cck.text.Terminal;

public class StackMonitor
extends MonitorFactory {
    public StackMonitor() {
        super("The \"stack\" monitor tracks the height of the stack while the program executes, reporting the maximum stack height seen.");
    }

    public Monitor newMonitor(Simulator s) {
        return new Mon(s);
    }

    public class Mon
    implements Monitor {
        private final SPWatch SPH_watch = new SPWatch();
        private final SPWatch SPL_watch = new SPWatch();
        private boolean SPinit;
        private int minSP = 0;
        private int maxSP = 0;
        protected final Simulator simulator;

        Mon(Simulator sim) {
            SPProbe probe = new SPProbe();
            MCUProperties props = sim.getMicrocontroller().getProperties();
            this.simulator = sim;
            this.simulator.insertWatch(this.SPH_watch, props.getIOReg("SPH"));
            sim.insertWatch(this.SPL_watch, props.getIOReg("SPL"));
            sim.getInterpreter().getInterruptTable().insertProbe(new IntProbe());
            Program program = sim.getProgram();
            int pc = 0;
            while (pc < program.program_end) {
                LegacyInstr i = (LegacyInstr)program.readInstr(pc);
                if (i != null) {
                    if (i instanceof LegacyInstr.CALL) {
                        sim.insertProbe(probe, pc);
                    } else if (i instanceof LegacyInstr.ICALL) {
                        sim.insertProbe(probe, pc);
                    } else if (i instanceof LegacyInstr.RCALL) {
                        sim.insertProbe(probe, pc);
                    } else if (i instanceof LegacyInstr.RET) {
                        sim.insertProbe(probe, pc);
                    } else if (i instanceof LegacyInstr.RETI) {
                        sim.insertProbe(probe, pc);
                    } else if (i instanceof LegacyInstr.PUSH) {
                        sim.insertProbe(probe, pc);
                    } else if (i instanceof LegacyInstr.POP) {
                        sim.insertProbe(probe, pc);
                    }
                }
                pc = program.getNextPC(pc);
            }
        }

        public void report() {
            if (this.SPinit) {
                TermUtil.printSeparator("Stack results for node " + this.simulator.getID());
                TermUtil.reportQuantity("Maximum stack pointer", StringUtil.addrToString(this.maxSP), "");
                TermUtil.reportQuantity("Minimum stack pointer", StringUtil.addrToString(this.minSP), "");
                TermUtil.reportQuantity("Maximum stack size", this.maxSP - this.minSP, "bytes");
                Terminal.nextln();
            } else {
                Terminal.println("No stack pointer information for node " + this.simulator.getID() + ".");
                Terminal.nextln();
            }
        }

        void checkSPWrite(State state) {
            if (this.SPH_watch.written && this.SPL_watch.written) {
                this.newSP(state.getSP());
                this.SPH_watch.written = false;
                this.SPL_watch.written = false;
            }
        }

        void newSP(int sp) {
            if (!this.SPinit) {
                this.maxSP = sp;
                this.minSP = sp;
                this.SPinit = true;
            } else if (sp > this.maxSP) {
                this.maxSP = sp;
            } else if (sp < this.minSP) {
                this.minSP = sp;
            }
        }

        class SPProbe
        extends Simulator.Probe.Empty {
            SPProbe() {
            }

            public void fireAfter(State state, int pc) {
                Mon.this.newSP(state.getSP());
            }
        }

        class IntProbe
        extends Simulator.InterruptProbe.Empty {
            IntProbe() {
            }

            public void fireAfterInvoke(State s, int inum) {
                Mon.this.newSP(s.getSP());
            }
        }

        class SPWatch
        extends Simulator.Watch.Empty {
            boolean written;

            SPWatch() {
            }

            public void fireAfterWrite(State state, int data_addr, byte value) {
                this.written = true;
                Mon.this.checkSPWrite(state);
            }
        }
    }
}

