/*
 * Decompiled with CFR 0.152.
 */
package avrora.monitors;

import avrora.monitors.Monitor;
import avrora.monitors.MonitorFactory;
import avrora.sim.Simulator;
import avrora.sim.clock.Clock;
import avrora.sim.clock.MainClock;
import avrora.sim.output.SimPrinter;
import avrora.sim.platform.Platform;
import avrora.sim.radio.Medium;
import avrora.sim.radio.Radio;
import avrora.sim.util.SimUtil;
import cck.text.StringUtil;
import cck.text.Terminal;
import cck.util.Option;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SnifferMonitor
extends MonitorFactory {
    protected Option.Bool TRANSMITTED = this.newOption("Transmitted", false, "This option enables/disables the printing of packets as they are transmitted.");
    protected Option.Bool RECEIVED = this.newOption("Received", false, "This option enables/disables the printing of packets as they are received.");
    protected Option.Bool PRINT = this.newOption("Print", false, "This option enables/disables the printing of the output.");
    protected Option.Str FILENAME = this.newOption("FileName", "out.dcf", "This option is used to give a name to the output file. Name of output is out.dcf as default");
    protected List monitors = new LinkedList();
    protected static int packetsTotal;

    public SnifferMonitor() {
        super("The \"sniffer\" monitor logs packets in the format accepted by the Daintree Networks\u2019 Sensor Network Analyzer (SNA) software.");
    }

    public Monitor newMonitor(Simulator s) {
        return new Mon(s);
    }

    class Mon
    implements Monitor,
    Medium.Probe {
        LinkedList bytes;
        final Simulator simulator;
        final SimPrinter printer;
        final boolean showReceived;
        final boolean showTransmitted;
        final boolean Print;
        int bytesTransmitted;
        int packetsTransmitted;
        int bytesReceived;
        int packetsReceived;
        int bytesCorrupted;
        boolean matchStart;
        byte startSymbol;
        long startCycle;
        String fileName = new String("");
        Date now = new Date();
        double DateTime;

        Mon(Simulator s) {
            this.simulator = s;
            Platform platform = this.simulator.getMicrocontroller().getPlatform();
            Radio radio = (Radio)platform.getDevice("radio");
            radio.getTransmitter().insertProbe(this);
            radio.getReceiver().insertProbe(this);
            this.printer = SimUtil.getPrinter(this.simulator, "monitor.sniffer");
            this.printer.enabled = true;
            this.showReceived = SnifferMonitor.this.RECEIVED.get();
            this.showTransmitted = SnifferMonitor.this.TRANSMITTED.get();
            this.Print = SnifferMonitor.this.PRINT.get();
            this.fileName = SnifferMonitor.this.FILENAME.get();
            this.bytes = new LinkedList();
            this.DateTime = this.now.getTime() / 1000L;
            SnifferMonitor.this.monitors.add(this);
        }

        public void fireBeforeTransmit(Medium.Transmitter t, byte val) {
            if (this.showTransmitted) {
                if (this.bytes.size() == 0) {
                    this.startCycle = this.simulator.getClock().getCount();
                }
                this.bytes.addLast(new Character((char)(0xFF & val)));
                ++this.bytesTransmitted;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void fireBeforeTransmitEnd(Medium.Transmitter t) {
            if (!this.showTransmitted) return;
            ++this.packetsTransmitted;
            Class<Terminal> clazz = Terminal.class;
            synchronized (Terminal.class) {
                StringBuffer buf = this.renderTxPacket();
                if (this.Print) {
                    Terminal.println(buf.toString());
                }
                if (this.showTransmitted) {
                    this.logfile(buf);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                this.bytes = new LinkedList();
                return;
            }
        }

        public void fireAfterReceive(Medium.Receiver r, char val) {
            if (this.showReceived) {
                if (this.bytes.size() == 0) {
                    this.startCycle = this.simulator.getClock().getCount();
                }
                if (Medium.isCorruptedByte(val)) {
                    ++this.bytesCorrupted;
                }
                this.bytes.addLast(new Character(val));
                ++this.bytesReceived;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void fireAfterReceiveEnd(Medium.Receiver r) {
            if (!this.showReceived) return;
            ++this.packetsReceived;
            Class<Terminal> clazz = Terminal.class;
            synchronized (Terminal.class) {
                StringBuffer buf = this.renderRxPacket();
                if (this.Print) {
                    Terminal.println(buf.toString());
                }
                if (this.showReceived) {
                    this.logfile(buf);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                this.bytes = new LinkedList();
                return;
            }
        }

        private StringBuffer renderRxPacket() {
            StringBuffer buf = new StringBuffer(3 * this.bytes.size() + 45);
            buf.append(String.valueOf(++packetsTotal) + " ");
            MainClock clk = this.simulator.getClock();
            double seconds = (double)((Clock)clk).getCount() / (double)clk.getHZ();
            DecimalFormat SixDecimals = new DecimalFormat("0.000000");
            buf.append(String.valueOf(SixDecimals.format(seconds + this.DateTime)) + " ");
            Iterator i = this.bytes.iterator();
            int cntr = 0;
            char len = '\u0000';
            int power_received = 0;
            int lqi = 0;
            int fcs = 0;
            while (i.hasNext()) {
                char t = ((Character)i.next()).charValue();
                if (++cntr == 6) {
                    len = t;
                    buf.append(StringUtil.toDecimal(t, 0));
                    buf.append(" ");
                }
                if (cntr > 6 && cntr - 6 <= len) {
                    buf.append(StringUtil.toHex((byte)t, 2));
                }
                if (cntr == 7 + len - 2) {
                    power_received = t - 255 - 45;
                }
                if (cntr != 7 + len - 1) continue;
                lqi = 0x7F & t;
                fcs = (0x80 & t) >>> 7;
            }
            buf.append(" " + StringUtil.toDecimal((byte)lqi, 0) + " " + StringUtil.toHex((byte)fcs, 1) + " " + StringUtil.toDecimal((byte)power_received, 0) + " 26 " + String.valueOf(packetsTotal) + " 0 1 32767");
            return buf;
        }

        private StringBuffer renderTxPacket() {
            StringBuffer buf = new StringBuffer(3 * this.bytes.size() + 45);
            Terminal.append(16, buf, String.valueOf(++packetsTotal) + " ");
            MainClock clk = this.simulator.getClock();
            double seconds = (double)((Clock)clk).getCount() / (double)clk.getHZ();
            DecimalFormat SixDecimals = new DecimalFormat("0.000000");
            buf.append(String.valueOf(SixDecimals.format(seconds + this.DateTime)) + " ");
            Iterator i = this.bytes.iterator();
            int cntr = 0;
            char len = '\u0000';
            while (i.hasNext()) {
                char t = ((Character)i.next()).charValue();
                if (++cntr == 6) {
                    len = t;
                    buf.append(StringUtil.toDecimal(t, 0) + " ");
                }
                if (cntr <= 6 || cntr - 6 > len) continue;
                buf.append(StringUtil.toHex((byte)t, 2));
            }
            buf.append(" 0 1 32767 26 " + String.valueOf(packetsTotal) + " 0 1 32767");
            return buf;
        }

        private void logfile(StringBuffer buf) {
            if (this.showReceived || this.showTransmitted) {
                try {
                    if (packetsTotal == 1) {
                        BufferedWriter out2 = new BufferedWriter(new FileWriter(this.fileName));
                        out2.write("#Format=4");
                        out2.write(10);
                        out2.write(buf.toString());
                        out2.write(10);
                        out2.close();
                    } else {
                        BufferedWriter out3 = new BufferedWriter(new FileWriter(this.fileName, true));
                        out3.write(buf.toString());
                        out3.write(10);
                        out3.close();
                    }
                }
                catch (Exception e) {
                    System.err.println("Error: " + e.getMessage());
                }
            }
        }

        public void report() {
            if (SnifferMonitor.this.monitors != null) {
                SnifferMonitor.this.monitors = null;
            }
            Terminal.nextln();
        }
    }
}

