/*
 * Decompiled with CFR 0.152.
 */
package avrora.monitors;

import avrora.core.Program;
import avrora.monitors.Monitor;
import avrora.monitors.MonitorFactory;
import avrora.sim.FiniteStateMachine;
import avrora.sim.Simulator;
import avrora.sim.clock.Clock;
import avrora.sim.mcu.DefaultMCU;
import cck.text.StringUtil;
import cck.text.TermUtil;
import cck.text.Terminal;

public class SleepMonitor
extends MonitorFactory {
    public SleepMonitor() {
        super("The \"sleep\" is a monitor that tracks statistics about the sleeping patterns of programs, including the total number of cycles awake and the total number of cycles asleep during the simulation.");
    }

    public Monitor newMonitor(Simulator s) {
        return new Mon(s);
    }

    public static class Mon
    implements Monitor,
    FiniteStateMachine.Probe {
        public final Simulator simulator;
        public final Program program;
        long[] times;
        long lastTransition;
        final FiniteStateMachine fsm;
        final Clock clock;

        Mon(Simulator s) {
            this.simulator = s;
            this.program = s.getProgram();
            this.fsm = ((DefaultMCU)s.getMicrocontroller()).getFSM();
            this.clock = this.fsm.getClock();
            this.times = new long[this.fsm.getNumberOfStates()];
            this.fsm.insertProbe(this);
        }

        public void report() {
            this.recordCycles(this.fsm.getCurrentState());
            TermUtil.printSeparator("Sleep Monitor results for node " + this.simulator.getID());
            Terminal.printGreen("State                      Cycles  Percent");
            Terminal.nextln();
            TermUtil.printThinSeparator(78);
            long total = this.clock.getCount();
            for (int cntr = 0; cntr < this.times.length; ++cntr) {
                String state = this.fsm.getStateName(cntr);
                Terminal.printGreen(StringUtil.leftJustify(state, 23));
                Terminal.printBrightCyan(StringUtil.rightJustify(this.times[cntr], 10));
                float pcnt = 100.0f * (float)this.times[cntr] / (float)total;
                Terminal.printBrightCyan(StringUtil.rightJustify(StringUtil.toFixedFloat(pcnt, 4), 9));
                Terminal.print(" %");
                Terminal.nextln();
            }
            Terminal.nextln();
        }

        public void fireBeforeTransition(int bs, int as) {
        }

        public void fireAfterTransition(int bs, int as) {
            this.recordCycles(bs);
        }

        private void recordCycles(int bs) {
            long now = this.clock.getCount();
            int n = bs;
            this.times[n] = this.times[n] + (now - this.lastTransition);
            this.lastTransition = now;
        }
    }
}

